/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.charm;

import com.someguyssoftware.gottschcore.cube.Cube;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.charm.Charm;
import com.someguyssoftware.treasure2.charm.ICharm;
import com.someguyssoftware.treasure2.charm.ICharmEntity;
import com.someguyssoftware.treasure2.charm.IlluminationCharmEntity;
import com.someguyssoftware.treasure2.util.ResourceLocationUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class IlluminationCharm
extends Charm {
    public static String ILLUMINATION_TYPE = "illumination";
    private static final Class<?> REGISTERED_EVENT = LivingEvent.LivingUpdateEvent.class;

    IlluminationCharm(Builder builder) {
        super(builder);
    }

    @Override
    public Class<?> getRegisteredEvent() {
        return REGISTERED_EVENT;
    }

    @Override
    public ICharmEntity createEntity() {
        IlluminationCharmEntity entity = new IlluminationCharmEntity(this);
        return entity;
    }

    @Override
    public ICharmEntity createEntity(ICharmEntity entity) {
        IlluminationCharmEntity newEntity = new IlluminationCharmEntity((IlluminationCharmEntity)entity);
        return newEntity;
    }

    @Override
    public boolean update(World world, Random random, ICoords coords, EntityPlayer player, Event event, ICharmEntity entity) {
        boolean result = false;
        if (world.func_82737_E() % 100L == 0L && !player.field_70128_L && entity.getMana() > 0.0) {
            Coords currentCoords = new Coords((int)Math.floor(player.field_70165_t), (int)Math.floor(player.field_70163_u), (int)Math.floor(player.field_70161_v));
            Cube cube = new Cube(world, (ICoords)currentCoords);
            if (!cube.isAir() && !cube.isReplaceable()) {
                return false;
            }
            cube = new Cube(world, currentCoords.down(1));
            if (!cube.isSolid()) {
                Treasure.LOGGER.debug("not solid at -> {}", (Object)currentCoords.down(1));
                return false;
            }
            if (!(entity instanceof IlluminationCharmEntity)) {
                Treasure.LOGGER.debug("data are not instance of IlluminationCharmEntity -> {}.{}", (Object)this.getClass().getSimpleName(), (Object)entity.getClass().getSimpleName());
                return false;
            }
            IlluminationCharmEntity charmData = (IlluminationCharmEntity)entity;
            List<ICoords> list = charmData.getCoordsList();
            Treasure.LOGGER.debug("charm coords list size -> {}", (Object)list.size());
            double value = entity.getMana();
            boolean isUpdated = false;
            if (list.isEmpty()) {
                list.add(0, (ICoords)currentCoords);
                isUpdated = true;
            } else {
                ICoords firstCoords = list.get(0);
                if (!currentCoords.equals((Object)firstCoords) && firstCoords.getDistanceSq((ICoords)currentCoords) >= 25.0) {
                    list.add(0, (ICoords)currentCoords);
                    if (list.size() > (int)charmData.getMana()) {
                        int diff = (int)((double)list.size() - charmData.getMana());
                        for (int index = 0; index < diff; ++index) {
                            ICoords lastCoords = list.get(list.size() - 1);
                            Block block = world.func_180495_p(lastCoords.toPos()).func_177230_c();
                            if (block == Blocks.field_150478_aa) {
                                world.func_175698_g(lastCoords.toPos());
                            } else {
                                value -= 1.0;
                            }
                            list.remove(lastCoords);
                        }
                    }
                    isUpdated = true;
                }
            }
            if (isUpdated) {
                world.func_175656_a(currentCoords.toPos(), Blocks.field_150478_aa.func_176223_P());
                if (value < 0.0) {
                    value = 0.0;
                }
                entity.setMana(value);
                result = true;
            }
        }
        return result;
    }

    @Override
    public String getCharmDesc(ICharmEntity entity) {
        return I18n.func_74837_a((String)"tooltip.charm.rate.illumination", (Object[])new Object[0]);
    }

    public static class Builder
    extends Charm.Builder {
        public Builder(Integer level) {
            super(ResourceLocationUtil.create(Builder.makeName(ILLUMINATION_TYPE, level)), ILLUMINATION_TYPE, level);
        }

        @Override
        public ICharm build() {
            return new IlluminationCharm(this);
        }
    }
}

