/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.charm;

import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.charm.ICharm;
import com.someguyssoftware.treasure2.charm.cost.CostEvaluator;
import com.someguyssoftware.treasure2.charm.cost.ICostEvaluator;
import net.minecraft.nbt.NBTTagCompound;

public interface ICharmEntity {
    public static final String CHARM = "charm";
    @Deprecated
    public static final String VALUE = "value";
    public static final String MANA = "mana";
    public static final String MAX_MANA = "maxMana";
    public static final String DURATION = "duration";
    public static final String FREQUENCY = "frequency";
    public static final String AMOUNT = "amount";
    public static final String COOLDOWN = "cooldown";
    public static final String RANGE = "range";
    public static final String COST_EVALUATOR = "costEvaluator";
    public static final String EXCLUSIVE = "exclusive";
    public static final String RECHARGES = "recharges";
    public static final String MAX_RECHARGES = "maxRecharges";

    public ICharm getCharm();

    public void setCharm(ICharm var1);

    public double getMana();

    public void setMana(double var1);

    public int getDuration();

    public void setDuration(int var1);

    public double getFrequency();

    public void setFrequency(double var1);

    public double getRange();

    public void setRange(double var1);

    public double getCooldown();

    public void setCooldown(double var1);

    public double getAmount();

    public void setAmount(double var1);

    public ICostEvaluator getCostEvaluator();

    public void setCostEvaluator(ICostEvaluator var1);

    public double getMaxMana();

    public void setMaxMana(double var1);

    public void update(ICharmEntity var1);

    public NBTTagCompound save(NBTTagCompound var1);

    default public boolean load(NBTTagCompound nbt) {
        if (nbt.func_74764_b(MANA)) {
            this.setMana(nbt.func_74769_h(MANA));
        } else if (nbt.func_74764_b(VALUE)) {
            this.setMana(nbt.func_74769_h(VALUE));
        }
        if (nbt.func_74764_b(DURATION)) {
            this.setDuration(nbt.func_74762_e(DURATION));
        }
        if (nbt.func_74764_b(FREQUENCY)) {
            this.setFrequency(nbt.func_74769_h(FREQUENCY));
        }
        if (nbt.func_74764_b(AMOUNT)) {
            this.setAmount(nbt.func_74769_h(AMOUNT));
        }
        if (nbt.func_74764_b(COOLDOWN)) {
            this.setCooldown(nbt.func_74769_h(COOLDOWN));
        }
        if (nbt.func_74764_b(RANGE)) {
            this.setRange(nbt.func_74769_h(RANGE));
        }
        if (nbt.func_74764_b(COST_EVALUATOR) && nbt.func_74775_l(COST_EVALUATOR).func_74764_b("costClass")) {
            try {
                NBTTagCompound tag = nbt.func_74775_l(COST_EVALUATOR);
                String costEvalClass = tag.func_74779_i("costClass");
                Object o = Class.forName(costEvalClass).newInstance();
                ((ICostEvaluator)o).load(tag);
                this.setCostEvaluator((ICostEvaluator)o);
            }
            catch (Exception e) {
                Treasure.LOGGER.warn("unable to create cost evaluator from class string -> {}", (Object)nbt.func_74775_l(COST_EVALUATOR).func_74779_i("costClass"));
                Treasure.LOGGER.error((Object)e);
                this.setCostEvaluator(new CostEvaluator());
            }
        } else {
            this.setCostEvaluator(new CostEvaluator());
        }
        if (nbt.func_74764_b(MAX_MANA)) {
            this.setMaxMana(nbt.func_74769_h(MAX_MANA));
        }
        if (nbt.func_74764_b(EXCLUSIVE)) {
            this.setExclusive(nbt.func_74767_n(EXCLUSIVE));
        }
        if (nbt.func_74764_b(RECHARGES)) {
            this.setRecharges(nbt.func_74762_e(RECHARGES));
        }
        if (nbt.func_74764_b(MAX_RECHARGES)) {
            this.setMaxRecharges(nbt.func_74762_e(MAX_RECHARGES));
        }
        return true;
    }

    public boolean isExclusive();

    public void setExclusive(boolean var1);

    public int getRecharges();

    public void setRecharges(int var1);

    public int getMaxRecharges();

    public void setMaxRecharges(int var1);
}

