/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.charm;

import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.charm.Charm;
import com.someguyssoftware.treasure2.charm.ICharm;
import com.someguyssoftware.treasure2.charm.ICharmEntity;
import com.someguyssoftware.treasure2.util.ResourceLocationUtil;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class HarvestingCharm
extends Charm {
    public static String HARVESTING_TYPE = "harvesting";
    private static final Class<?> REGISTERED_EVENT = BlockEvent.HarvestDropsEvent.class;

    HarvestingCharm(Builder builder) {
        super(builder);
    }

    @Override
    public Class<?> getRegisteredEvent() {
        return REGISTERED_EVENT;
    }

    @Override
    public boolean update(World world, Random random, ICoords coords, EntityPlayer player, Event event, ICharmEntity entity) {
        boolean result = false;
        if (entity.getMana() > 0.0 && !player.field_70128_L) {
            for (ItemStack stack : ((BlockEvent.HarvestDropsEvent)event).getDrops()) {
                Block block = Block.func_149634_a((Item)stack.func_77973_b());
                if (block != Blocks.field_150350_a && block.hasTileEntity(block.func_176223_P())) {
                    Treasure.LOGGER.debug("skipped item because it has a tile entity.");
                    continue;
                }
                int size = (int)((double)stack.func_190916_E() * entity.getAmount());
                stack.func_190920_e(size);
            }
            ((BlockEvent.HarvestDropsEvent)event).setDropChance(1.0f);
            this.applyCost(world, random, coords, player, event, entity, this.getAmount());
            result = true;
        }
        return result;
    }

    @Override
    public String getCharmDesc(ICharmEntity entity) {
        return I18n.func_74837_a((String)"tooltip.charm.rate.harvest", (Object[])new Object[]{Math.toIntExact((long)this.getAmount())});
    }

    public static class Builder
    extends Charm.Builder {
        public Builder(Integer level) {
            super(ResourceLocationUtil.create(Builder.makeName(HARVESTING_TYPE, level)), HARVESTING_TYPE, level);
        }

        @Override
        public ICharm build() {
            return new HarvestingCharm(this);
        }
    }
}

