/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.charm;

import com.google.common.util.concurrent.AtomicDouble;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.charm.Charm;
import com.someguyssoftware.treasure2.charm.ICharm;
import com.someguyssoftware.treasure2.charm.ICharmEntity;
import com.someguyssoftware.treasure2.util.ResourceLocationUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class DrainCharm
extends Charm {
    public static final String DRAIN_TYPE = "drain";
    private static final Class<?> REGISTERED_EVENT = LivingEvent.LivingUpdateEvent.class;

    DrainCharm(Builder builder) {
        super(builder);
    }

    @Override
    public boolean isCurse() {
        return true;
    }

    @Override
    public Class<?> getRegisteredEvent() {
        return REGISTERED_EVENT;
    }

    @Override
    public boolean update(World world, Random random, ICoords coords, EntityPlayer player, Event event, ICharmEntity entity) {
        boolean result = false;
        if ((double)world.func_82737_E() % entity.getFrequency() == 0.0 && entity.getMana() > 0.0 && player.func_110143_aJ() < player.func_110138_aP() && !player.field_70128_L) {
            double px = player.field_70165_t;
            double py = player.field_70163_u;
            double pz = player.field_70161_v;
            double range = entity.getRange();
            AtomicDouble drainedHealth = new AtomicDouble(0.0);
            List mobs = world.func_72872_a(EntityMob.class, new AxisAlignedBB(px - range, py - range, pz - range, px + range, py + range, pz + range));
            if (mobs.isEmpty()) {
                return result;
            }
            mobs.forEach(mob -> {
                boolean flag = mob.func_70097_a(DamageSource.field_76377_j, (float)this.getAmount());
                Treasure.LOGGER.debug("health drained from mob -> {} was successful -> {}", (Object)mob.func_70005_c_(), (Object)flag);
                if (flag) {
                    drainedHealth.addAndGet(this.getAmount());
                }
            });
            if (drainedHealth.get() > 0.0) {
                player.func_70606_j(MathHelper.func_76131_a((float)(player.func_110143_aJ() + (float)drainedHealth.get()), (float)0.0f, (float)player.func_110138_aP()));
                this.applyCost(world, random, coords, player, event, entity, 1.0);
                result = true;
            }
        }
        return result;
    }

    @Override
    public String getCharmDesc(ICharmEntity entity) {
        return I18n.func_74837_a((String)"tooltip.charm.rate.drain", (Object[])new Object[]{entity.getRange()});
    }

    public static class Builder
    extends Charm.Builder {
        public Builder(Integer level) {
            super(ResourceLocationUtil.create(Builder.makeName(DrainCharm.DRAIN_TYPE, level)), DrainCharm.DRAIN_TYPE, level);
        }

        @Override
        public ICharm build() {
            return new DrainCharm(this);
        }
    }
}

