/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.charm;

import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.treasure2.charm.Charm;
import com.someguyssoftware.treasure2.charm.ICharm;
import com.someguyssoftware.treasure2.charm.ICharmEntity;
import com.someguyssoftware.treasure2.util.ResourceLocationUtil;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class DecrepitCurse
extends Charm {
    public static String DECREPIT_TYPE = "decrepit";
    private static final Class<?> REGISTERED_EVENT = LivingDamageEvent.class;

    DecrepitCurse(Builder builder) {
        super(builder);
    }

    @Override
    public Class<?> getRegisteredEvent() {
        return REGISTERED_EVENT;
    }

    @Override
    public boolean isCurse() {
        return true;
    }

    @Override
    public boolean update(World world, Random random, ICoords coords, EntityPlayer player, Event event, ICharmEntity entity) {
        boolean result = false;
        if (!player.field_70128_L && entity.getMana() > 0.0 && (double)player.func_110143_aJ() > 0.0) {
            double amount = ((LivingDamageEvent)event).getAmount();
            double newAmount = amount + amount * entity.getAmount();
            ((LivingDamageEvent)event).setAmount((float)newAmount);
            this.applyCost(world, random, coords, player, event, entity, newAmount);
            result = true;
        }
        return result;
    }

    @Override
    public TextFormatting getCharmLabelColor() {
        return TextFormatting.DARK_RED;
    }

    @Override
    public String getCharmDesc(ICharmEntity entity) {
        return I18n.func_74837_a((String)"tooltip.charm.rate.decrepit", (Object[])new Object[]{Math.round(entity.getAmount() * 100.0)});
    }

    public static class Builder
    extends Charm.Builder {
        public Builder(Integer level) {
            super(ResourceLocationUtil.create(Builder.makeName(DECREPIT_TYPE, level)), DECREPIT_TYPE, level);
        }

        @Override
        public ICharm build() {
            return new DecrepitCurse(this);
        }
    }
}

