/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.charm;

import com.someguyssoftware.treasure2.capability.ICharmableCapability;
import com.someguyssoftware.treasure2.capability.InventoryType;
import com.someguyssoftware.treasure2.charm.ICharmEntity;
import java.util.Comparator;
import java.util.function.Consumer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;

public class CharmContext {
    private EnumHand hand;
    private String slotProviderId;
    private Integer slot;
    private ItemStack itemStack;
    private ICharmableCapability capability;
    private InventoryType type;
    private int index;
    private ICharmEntity entity;
    public static Comparator<CharmContext> priorityComparator = new Comparator<CharmContext>(){

        @Override
        public int compare(CharmContext p1, CharmContext p2) {
            if (p1.getEntity().getCharm().getPriority() < p2.getEntity().getCharm().getPriority()) {
                return 1;
            }
            return -1;
        }
    };

    CharmContext(Builder builder) {
        this.hand = builder.hand;
        this.slotProviderId = builder.slotProviderId;
        this.slot = builder.slot;
        this.itemStack = builder.itemStack;
        this.capability = builder.capability;
        this.type = builder.type;
        this.index = builder.index;
        this.entity = builder.entity;
    }

    public EnumHand getHand() {
        return this.hand;
    }

    public String getSlotProviderId() {
        return this.slotProviderId;
    }

    public Integer getSlot() {
        return this.slot;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public ICharmableCapability getCapability() {
        return this.capability;
    }

    public InventoryType getType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    public ICharmEntity getEntity() {
        return this.entity;
    }

    public String toString() {
        return "CharmContext [hand=" + this.hand + ", slotProviderId=" + this.slotProviderId + ", slot=" + this.slot + ", itemStack=" + this.itemStack == null ? "N/A" : this.itemStack.func_82833_r() + ", capability=" + this.capability + ", type=" + (Object)((Object)this.type) + ", index=" + this.index + ", entity=" + this.entity + "]";
    }

    public static class Builder {
        public EnumHand hand;
        public String slotProviderId;
        public Integer slot;
        public ItemStack itemStack;
        public ICharmableCapability capability;
        public InventoryType type;
        public int index;
        public ICharmEntity entity;

        public Builder with(Consumer<Builder> builder) {
            builder.accept(this);
            return this;
        }

        public CharmContext build() {
            return new CharmContext(this);
        }
    }
}

