/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.charm;

import com.someguyssoftware.treasure2.capability.InventoryType;
import com.someguyssoftware.treasure2.charm.Charm;
import com.someguyssoftware.treasure2.charm.ICharm;
import com.someguyssoftware.treasure2.charm.ICharmEntity;
import com.someguyssoftware.treasure2.charm.ShieldingCharm;
import com.someguyssoftware.treasure2.charm.ShieldingCharmEntity;
import com.someguyssoftware.treasure2.util.ResourceLocationUtil;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class AegisCharm
extends ShieldingCharm {
    public static String AEGIS_TYPE = "aegis";

    AegisCharm(Builder builder) {
        super(builder);
    }

    @Override
    public void addInformation(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flagIn, ICharmEntity entity, InventoryType type) {
        ShieldingCharmEntity charmEntity = (ShieldingCharmEntity)entity;
        TextFormatting color = TextFormatting.BLUE;
        tooltip.add(this.getLabel(entity, type == InventoryType.SOCKET));
        if (charmEntity.getCooldownEnd() > 0.0 && (double)world.func_82737_E() < charmEntity.getCooldownEnd()) {
            tooltip.add(TextFormatting.GRAY + "" + TextFormatting.ITALIC + I18n.func_74837_a((String)"tooltip.indent4", (Object[])new Object[]{I18n.func_74838_a((String)"tooltip.charm.rate.aegis") + " " + I18n.func_74837_a((String)"tooltip.charm.cooldown.meter", (Object[])new Object[]{DECIMAL_FORMAT.format((charmEntity.getCooldownEnd() - (double)world.func_82737_E()) / 20.0)})}));
        } else {
            tooltip.add(TextFormatting.GRAY + "" + TextFormatting.ITALIC + I18n.func_74837_a((String)"tooltip.indent2", (Object[])new Object[]{I18n.func_74838_a((String)"tooltip.charm.rate.aegis")}));
        }
    }

    public static class Builder
    extends Charm.Builder {
        public Builder(Integer level) {
            super(ResourceLocationUtil.create(Builder.makeName(AEGIS_TYPE, level)), AEGIS_TYPE, level);
        }

        @Override
        public ICharm build() {
            return new AegisCharm(this);
        }
    }
}

