/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.capability;

import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.capability.IRunestonesCapability;
import com.someguyssoftware.treasure2.capability.InventoryType;
import com.someguyssoftware.treasure2.rune.IRune;
import com.someguyssoftware.treasure2.rune.IRuneEntity;
import com.someguyssoftware.treasure2.rune.Rune;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public class RunestonesCapabilityStorage
implements Capability.IStorage<IRunestonesCapability> {
    private static final String BINDABLE_TAG = "bindable";
    private static final String SOCKETABLE_TAG = "socketable";

    public NBTBase writeNBT(Capability<IRunestonesCapability> capability, IRunestonesCapability instance, EnumFacing side) {
        NBTTagCompound mainTag = new NBTTagCompound();
        try {
            for (InventoryType type : InventoryType.values()) {
                List<IRuneEntity> entityList = instance.getEntities(type);
                if (entityList == null || entityList.isEmpty()) continue;
                NBTTagList listNbt = new NBTTagList();
                for (IRuneEntity entity : entityList) {
                    NBTTagCompound entityNbt = new NBTTagCompound();
                    listNbt.func_74742_a((NBTBase)entity.save(entityNbt));
                }
                mainTag.func_74782_a(type.name(), (NBTBase)listNbt);
            }
            mainTag.func_74757_a(BINDABLE_TAG, instance.isBindable());
            mainTag.func_74757_a(SOCKETABLE_TAG, instance.isSocketable());
        }
        catch (Exception e) {
            Treasure.LOGGER.error("Unable to write state to NBT:", (Throwable)e);
        }
        return mainTag;
    }

    public void readNBT(Capability<IRunestonesCapability> capability, IRunestonesCapability instance, EnumFacing side, NBTBase nbt) {
        if (nbt instanceof NBTTagCompound) {
            NBTTagCompound tag = (NBTTagCompound)nbt;
            try {
                instance.clear();
                for (InventoryType type : InventoryType.values()) {
                    if (!tag.func_74764_b(type.name())) continue;
                    NBTTagList listNbt = tag.func_150295_c(type.name(), 10);
                    listNbt.forEach(e -> {
                        Optional<IRune> runestone = Rune.load(((NBTTagCompound)e).func_74775_l("runestone"));
                        if (!runestone.isPresent()) {
                            return;
                        }
                        IRuneEntity entity = runestone.get().createEntity();
                        entity.load((NBTTagCompound)e);
                        instance.add(type, entity);
                    });
                }
                if (tag.func_74764_b(BINDABLE_TAG)) {
                    instance.setBindable(tag.func_74767_n(BINDABLE_TAG));
                }
                if (tag.func_74764_b(SOCKETABLE_TAG)) {
                    instance.setSocketable(tag.func_74767_n(SOCKETABLE_TAG));
                }
            }
            catch (Exception e2) {
                Treasure.LOGGER.error("Unable to write state to NBT:", (Throwable)e2);
            }
        }
    }
}

