/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.capability;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.capability.IRunestonesCapability;
import com.someguyssoftware.treasure2.capability.InventoryType;
import com.someguyssoftware.treasure2.capability.TreasureCapabilities;
import com.someguyssoftware.treasure2.rune.IRune;
import com.someguyssoftware.treasure2.rune.IRuneEntity;
import com.someguyssoftware.treasure2.rune.RuneEntity;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class RunestonesCapability
implements IRunestonesCapability {
    Multimap<InventoryType, IRuneEntity> runestoneEntities = ArrayListMultimap.create();
    private boolean bindable;
    private boolean socketable;
    private int maxSocketSize;
    private int maxImbueSize;
    private int maxInnateSize;

    public RunestonesCapability(int maxInnateSize, int maxImbueSize, int maxSocketSize) {
        this.maxInnateSize = maxInnateSize;
        this.maxImbueSize = maxImbueSize;
        this.maxSocketSize = maxSocketSize;
    }

    public RunestonesCapability(Builder builder) {
        this.bindable = builder.bindable;
        this.socketable = builder.socketable;
        this.maxInnateSize = builder.maxInnateSize;
        this.maxImbueSize = builder.maxImbueSize;
        this.maxSocketSize = builder.maxSocketSize;
    }

    public static RunestonesCapability create() {
        return new RunestonesCapability(0, 0, 0);
    }

    @Override
    public void appendHoverText(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        if (this.hasSlots()) {
            tooltip.add(TextFormatting.DARK_PURPLE + I18n.func_74838_a((String)"tooltip.runestones.title"));
            this.appendHoverText(stack, world, tooltip, flag, InventoryType.INNATE, false);
            this.appendHoverText(stack, world, tooltip, flag, InventoryType.SOCKET, true);
        }
    }

    private boolean hasSlots() {
        return this.getMaxInnateSize() + this.getMaxImbueSize() + this.getMaxSocketSize() > 0;
    }

    public void appendHoverText(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag, InventoryType inventoryType, boolean titleFlag) {
        List<IRuneEntity> entityList = this.getEntities(inventoryType);
        switch (inventoryType) {
            case INNATE: {
                break;
            }
            case SOCKET: {
                if (this.isSocketable()) break;
                return;
            }
            default: {
                return;
            }
        }
        if (titleFlag) {
            tooltip.add(TextFormatting.GOLD + I18n.func_74837_a((String)"tooltip.indent1", (Object[])new Object[]{I18n.func_74838_a((String)("tooltip.runestones.inventory." + inventoryType.name().toLowerCase()))}) + TextFormatting.WHITE + this.getCapacityHoverText(stack, world, inventoryType));
        }
        for (IRuneEntity entity : entityList) {
            entity.getRunestone().addInformation(stack, world, tooltip, flag, entity);
        }
    }

    public String getCapacityHoverText(ItemStack stack, World world, InventoryType type) {
        return I18n.func_74837_a((String)"tooltip.runestones.slots", (Object[])new Object[]{String.valueOf(Math.toIntExact(Math.round(this.getCurrentSize(type)))), String.valueOf(Math.toIntExact(Math.round(this.getMaxSize(type))))});
    }

    @Override
    public boolean hasRunestone() {
        return this.runestoneEntities.values().size() > 0;
    }

    @Override
    public void clear() {
        this.runestoneEntities.clear();
    }

    @Override
    public void copyTo(ItemStack stack) {
        Treasure.LOGGER.debug("in copyTo...");
        if (stack.hasCapability(TreasureCapabilities.RUNESTONES, null)) {
            IRunestonesCapability cap = (IRunestonesCapability)stack.getCapability(TreasureCapabilities.RUNESTONES, null);
            cap.setBindable(this.isBindable());
            cap.setSocketable(this.isSocketable());
            this.runestoneEntities.forEach((type, runestone) -> {
                Treasure.LOGGER.debug("copyTo - source entity in-> {}", runestone);
                RuneEntity newRune = new RuneEntity((IRuneEntity)runestone);
                Treasure.LOGGER.debug("copyTo - new runestone entity -> {}", (Object)newRune);
                cap.add((InventoryType)((Object)type), newRune);
            });
        }
    }

    @Override
    public void transferTo(ItemStack dest, InventoryType sourceType, InventoryType destType) {
        if (dest.hasCapability(TreasureCapabilities.RUNESTONES, null)) {
            IRunestonesCapability cap = (IRunestonesCapability)dest.getCapability(TreasureCapabilities.RUNESTONES, null);
            List<IRuneEntity> runestones = this.getEntities(sourceType);
            for (IRuneEntity entity : runestones) {
                if (cap.getCurrentSize(destType) >= cap.getMaxSize(destType)) continue;
                Treasure.LOGGER.debug("transferTo - runestone entity in-> {}", (Object)entity);
                RuneEntity newRune = new RuneEntity(entity);
                Treasure.LOGGER.debug("transferTo - new runestone entity -> {}", (Object)newRune);
                cap.add(destType, newRune);
            }
        }
    }

    @Override
    public boolean contains(IRune runestone) {
        return false;
    }

    @Override
    public List<IRuneEntity> getEntities(InventoryType type) {
        return (List)this.runestoneEntities.get((Object)type);
    }

    @Override
    public Multimap<InventoryType, IRuneEntity> getEntitiesCopy() {
        ArrayListMultimap map = ArrayListMultimap.create();
        this.runestoneEntities.forEach((arg_0, arg_1) -> RunestonesCapability.lambda$getEntitiesCopy$1((Multimap)map, arg_0, arg_1));
        return map;
    }

    @Override
    public int getCurrentSize(InventoryType type) {
        return this.getEntities(type).size();
    }

    @Override
    public int getMaxSize(InventoryType type) {
        return type == InventoryType.SOCKET ? this.getMaxSocketSize() : (type == InventoryType.IMBUE ? this.getMaxImbueSize() : this.getMaxInnateSize());
    }

    @Override
    public void add(InventoryType type, IRuneEntity entity) {
        if (this.getCurrentSize(type) < this.getMaxSize(type)) {
            this.runestoneEntities.get((Object)type).add(entity);
        }
    }

    @Override
    public boolean remove(InventoryType type, IRuneEntity entity) {
        if (this.runestoneEntities.get((Object)type).size() > 0) {
            return this.runestoneEntities.get((Object)type).removeIf(r -> r.getRunestone().getName().equals((Object)entity.getRunestone().getName()));
        }
        return false;
    }

    @Override
    public boolean isBindable() {
        return this.bindable;
    }

    @Override
    public void setBindable(boolean bindable) {
        this.bindable = bindable;
    }

    @Override
    public boolean isSocketable() {
        return this.socketable;
    }

    @Override
    public void setSocketable(boolean socketable) {
        this.socketable = socketable;
    }

    public int getMaxSocketSize() {
        return this.maxSocketSize;
    }

    public int getMaxImbueSize() {
        return this.maxImbueSize;
    }

    public int getMaxInnateSize() {
        return this.maxInnateSize;
    }

    private static /* synthetic */ void lambda$getEntitiesCopy$1(Multimap map, InventoryType key, IRuneEntity value) {
        RuneEntity entity = new RuneEntity(value);
        map.put((Object)key, (Object)entity);
    }

    public static class Builder {
        public boolean bindable;
        public boolean socketable;
        private int maxSocketSize;
        private int maxImbueSize;
        private int maxInnateSize;

        public Builder(int maxInnateSize, int maxImbueSize, int maxSocketSize) {
            this.maxInnateSize = maxInnateSize;
            this.maxImbueSize = maxImbueSize;
            this.maxSocketSize = maxSocketSize;
        }

        public Builder with(Consumer<Builder> builder) {
            builder.accept(this);
            return this;
        }

        public IRunestonesCapability build() {
            return new RunestonesCapability(this);
        }
    }
}

