/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.capability;

import com.someguyssoftware.treasure2.capability.IDurabilityCapability;
import com.someguyssoftware.treasure2.capability.TreasureCapabilities;
import com.someguyssoftware.treasure2.material.CharmableMaterial;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class DurabilityCapability
implements IDurabilityCapability {
    private int maxDurability = 1000;
    private int durability;
    private boolean infinite;
    private int maxRepairs;
    private int repairs;

    public DurabilityCapability() {
        this.setDurability(1000);
    }

    public DurabilityCapability(int durability) {
        this.setDurability(durability);
    }

    public DurabilityCapability(int durability, int max) {
        this.setMaxDurability(max);
        this.setDurability(durability);
    }

    public DurabilityCapability(int durability, int max, CharmableMaterial material) {
        this(durability, max);
        this.setRepairs(material.getMaxRepairs());
        this.setMaxRepairs(material.getMaxRepairs());
    }

    @Override
    public void copyTo(ItemStack stack) {
        if (stack.hasCapability(TreasureCapabilities.DURABILITY, null)) {
            IDurabilityCapability cap = (IDurabilityCapability)stack.getCapability(TreasureCapabilities.DURABILITY, null);
            cap.setMaxDurability(this.getMaxDurability());
            cap.setDurability(this.getDurability());
            cap.setInfinite(this.isInfinite());
            cap.setMaxRepairs(this.getMaxRepairs());
            cap.setRepairs(this.getRepairs());
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        if (!this.isInfinite()) {
            String text = TextFormatting.WHITE.toString() + I18n.func_74837_a((String)"tooltip.durability.amount", (Object[])new Object[]{this.getDurability() - stack.func_77952_i(), this.getDurability()});
            if (this.getMaxRepairs() > 0) {
                text = text + " " + I18n.func_74837_a((String)"tooltip.durability.repairs", (Object[])new Object[]{this.getRepairs(), this.getMaxRepairs()});
            }
            tooltip.add(text);
        } else {
            tooltip.add(TextFormatting.WHITE.toString() + I18n.func_74838_a((String)"tooltip.durability.amount.infinite"));
        }
    }

    @Override
    public int getDurability() {
        return this.durability;
    }

    @Override
    public void setDurability(int maxDamage) {
        this.durability = maxDamage > this.getMaxDurability() ? this.getMaxDurability() : maxDamage;
    }

    @Override
    public int getMaxDurability() {
        return this.maxDurability;
    }

    @Override
    public void setMaxDurability(int maxDurability) {
        this.maxDurability = maxDurability;
    }

    @Override
    public boolean isInfinite() {
        return this.infinite;
    }

    @Override
    public void setInfinite(boolean infinite) {
        this.infinite = infinite;
    }

    @Override
    public int getMaxRepairs() {
        return this.maxRepairs;
    }

    @Override
    public void setMaxRepairs(int maxRepairs) {
        this.maxRepairs = maxRepairs;
    }

    @Override
    public int getRepairs() {
        return this.repairs;
    }

    @Override
    public void setRepairs(int repairs) {
        this.repairs = repairs;
    }

    public String toString() {
        return "DurabilityCapability [maxDurability=" + this.maxDurability + ", durability=" + this.durability + ", infinite=" + this.infinite + ", maxRepairs=" + this.maxRepairs + ", repairs=" + this.repairs + "]";
    }
}

