/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.capability;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.capability.ICharmableCapability;
import com.someguyssoftware.treasure2.capability.InventoryType;
import com.someguyssoftware.treasure2.capability.TreasureCapabilities;
import com.someguyssoftware.treasure2.capability.modifier.ILevelModifier;
import com.someguyssoftware.treasure2.capability.modifier.NoLevelModifier;
import com.someguyssoftware.treasure2.charm.ICharm;
import com.someguyssoftware.treasure2.charm.ICharmEntity;
import com.someguyssoftware.treasure2.material.CharmableMaterial;
import com.someguyssoftware.treasure2.material.TreasureCharmableMaterials;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class CharmableCapability
implements ICharmableCapability {
    Multimap<InventoryType, ICharmEntity> charmEntities = ArrayListMultimap.create();
    private boolean source;
    private boolean executing;
    private boolean bindable;
    private boolean socketable;
    private boolean imbuing;
    private boolean imbuable;
    private boolean innate;
    private ResourceLocation baseMaterial;
    private ResourceLocation sourceItem;
    private int maxLevel;
    private ICharmEntity highestLevel;
    private boolean namedByMaterial;
    private boolean namedByCharm;
    private ILevelModifier levelModifier;
    private int maxSocketSize;
    private int maxImbueSize;
    private int maxInnateSize;
    public static Comparator<ICharmEntity> levelComparator = new SortByLevel();

    public static CharmableCapability create() {
        return new CharmableCapability(0, 0, 0);
    }

    public CharmableCapability(int maxInnateSize, int maxImbueSize, int maxSocketSize) {
        this.maxInnateSize = maxInnateSize;
        this.maxImbueSize = maxImbueSize;
        this.maxSocketSize = maxSocketSize;
    }

    public CharmableCapability(Builder builder) {
        this.source = builder.source;
        this.executing = builder.executing;
        this.bindable = builder.bindable;
        this.innate = builder.innate;
        this.imbuing = builder.imbuing;
        this.imbuable = builder.imbuable;
        this.socketable = builder.socketable;
        this.baseMaterial = builder.baseMaterial;
        this.sourceItem = builder.sourceItem;
        this.namedByCharm = builder.namedByCharm;
        this.namedByMaterial = builder.namedByMaterial;
        this.levelModifier = builder.levelModifier;
        this.maxInnateSize = builder.maxInnateSize;
        this.maxImbueSize = builder.maxImbueSize;
        this.maxSocketSize = builder.maxSocketSize;
    }

    @Override
    public boolean isCharmed() {
        return this.charmEntities.values().size() > 0;
    }

    @Override
    public boolean contains(ICharm charm) {
        for (ICharmEntity entity : this.charmEntities.values()) {
            if (!entity.getCharm().getType().equalsIgnoreCase(charm.getType()) && !entity.getCharm().getName().equals((Object)charm.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void copyTo(ItemStack stack) {
        if (stack.hasCapability(TreasureCapabilities.CHARMABLE, null)) {
            ICharmableCapability cap = (ICharmableCapability)stack.getCapability(TreasureCapabilities.CHARMABLE, null);
            cap.setBaseMaterial(this.getBaseMaterial());
            cap.setBindable(this.isBindable());
            cap.setExecuting(this.isExecuting());
            cap.setImbuable(this.isImbuable());
            cap.setImbuing(this.isImbuing());
            cap.setInnate(this.isInnate());
            cap.setLevelModifier(this.getLevelModifier());
            cap.setNamedByCharm(this.isNamedByCharm());
            cap.setNamedByMaterial(this.isNamedByMaterial());
            cap.setSocketable(this.isSocketable());
            cap.setSource(this.isSource());
            cap.setSourceItem(this.getSourceItem());
            cap.setMaxSocketSize(this.getMaxSocketSize());
            this.getCharmEntities().forEach((type, entity) -> {
                ICharmEntity newEntity = entity.getCharm().createEntity((ICharmEntity)entity);
                cap.add((InventoryType)((Object)type), newEntity);
            });
        }
    }

    @Override
    public void transferTo(ItemStack dest, InventoryType sourceType, InventoryType destType) {
        if (dest.hasCapability(TreasureCapabilities.CHARMABLE, null)) {
            ICharmableCapability cap = (ICharmableCapability)dest.getCapability(TreasureCapabilities.CHARMABLE, null);
            List charms = (List)this.getCharmEntities().get((Object)sourceType);
            Comparator<ICharmEntity> comparator = Collections.reverseOrder(new SortByLevel());
            Collections.sort(charms, comparator);
            for (ICharmEntity entity : charms) {
                if (cap.getMaxCharmLevel() < entity.getCharm().getLevel() || cap.getCurrentSize(destType) >= cap.getMaxSize(destType)) continue;
                ICharmEntity newEntity = entity.getCharm().createEntity(entity);
                cap.add(destType, newEntity);
            }
        }
    }

    @Override
    public boolean hasCharmType(ItemStack source, ItemStack dest, InventoryType sourceType, InventoryType destType) {
        if (source.hasCapability(TreasureCapabilities.CHARMABLE, null) && dest.hasCapability(TreasureCapabilities.CHARMABLE, null)) {
            ICharmableCapability sourceCap = (ICharmableCapability)source.getCapability(TreasureCapabilities.CHARMABLE, null);
            ICharmableCapability destCap = (ICharmableCapability)dest.getCapability(TreasureCapabilities.CHARMABLE, null);
            for (ICharmEntity sourceEntity : sourceCap.getCharmEntities().get((Object)sourceType)) {
                for (ICharmEntity destEntity : destCap.getCharmEntities().get((Object)destType)) {
                    if (!destEntity.getCharm().getType().equals(sourceEntity.getCharm().getType())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public int getCurrentSize(InventoryType type) {
        return this.getCharmEntities().get((Object)type).size();
    }

    @Override
    public int getMaxSize(InventoryType type) {
        return type == InventoryType.SOCKET ? this.getMaxSocketSize() : (type == InventoryType.IMBUE ? this.getMaxImbueSize() : this.getMaxInnateSize());
    }

    @Override
    public void add(InventoryType type, ICharmEntity entity) {
        if (this.getCurrentSize(type) < this.getMaxSize(type)) {
            this.charmEntities.get((Object)type).add(entity);
            if (this.highestLevel == null || entity.getCharm().getLevel() > this.highestLevel.getCharm().getLevel()) {
                this.highestLevel = entity;
            }
        }
    }

    @Override
    public void remove(InventoryType type, int index) {
        ((List)this.getCharmEntities().get((Object)type)).remove(index);
        this.highestLevel = null;
        this.getCharmEntities().values().forEach(entity -> {
            if (this.highestLevel == null || entity.getCharm().getLevel() > this.highestLevel.getCharm().getLevel()) {
                this.highestLevel = entity;
            }
        });
    }

    @Override
    public void clearCharms() {
        Treasure.LOGGER.debug("clearing charms");
        this.getCharmEntities().clear();
    }

    @Override
    public int getMaxCharmLevel() {
        Optional<CharmableMaterial> base = TreasureCharmableMaterials.getBaseMaterial(this.baseMaterial);
        Optional<CharmableMaterial> source = TreasureCharmableMaterials.getSourceItem(this.sourceItem);
        CharmableMaterial effectiveBase = base.isPresent() ? base.get() : TreasureCharmableMaterials.COPPER;
        return this.levelModifier.modifyMaxLevel(effectiveBase.getMaxLevel()) + (int)Math.floor(this.levelModifier.modifyLevelMultiplier(effectiveBase.getLevelMultiplier()) * (double)(source.isPresent() ? source.get().getMaxLevel() : 0));
    }

    @Override
    public void appendHoverText(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        if (this.isImbuable() || this.isSocketable()) {
            tooltip.add(TextFormatting.DARK_AQUA + I18n.func_74837_a((String)"tooltip.label.charms", (Object[])new Object[]{this.getMaxCharmLevel()}));
        } else {
            tooltip.add(TextFormatting.DARK_AQUA + I18n.func_74837_a((String)"tooltip.label.charms.no_level", (Object[])new Object[]{this.getMaxCharmLevel()}));
        }
        this.appendHoverText(stack, world, tooltip, flag, InventoryType.INNATE, false);
        this.appendHoverText(stack, world, tooltip, flag, InventoryType.IMBUE, true);
        this.appendHoverText(stack, world, tooltip, flag, InventoryType.SOCKET, true);
    }

    @Override
    public void appendHoverText(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag, InventoryType inventoryType, boolean titleFlag) {
        List entityList = (List)this.getCharmEntities().get((Object)inventoryType);
        switch (inventoryType) {
            case INNATE: {
                if (this.isInnate()) break;
                return;
            }
            case IMBUE: {
                if (this.isImbuable()) break;
                return;
            }
            case SOCKET: {
                if (this.isSocketable()) break;
                return;
            }
        }
        if (titleFlag) {
            tooltip.add(TextFormatting.GOLD + I18n.func_74837_a((String)"tooltip.indent1", (Object[])new Object[]{I18n.func_74838_a((String)("tooltip.charmable.inventory." + inventoryType.name().toLowerCase()))}) + TextFormatting.WHITE + this.getCapacityHoverText(stack, world, inventoryType));
        }
        for (ICharmEntity entity : entityList) {
            entity.getCharm().addInformation(stack, world, tooltip, flag, entity, inventoryType);
        }
    }

    @Override
    public String getCapacityHoverText(ItemStack stack, World world, InventoryType type) {
        return I18n.func_74837_a((String)"tooltip.charmable.slots", (Object[])new Object[]{String.valueOf(Math.toIntExact(Math.round(this.getCurrentSize(type)))), String.valueOf(Math.toIntExact(Math.round(this.getMaxSize(type))))});
    }

    @Override
    public void addMaxSocketSize(int increment) {
        this.maxSocketSize = this.getMaxSocketSize() + increment;
    }

    @Override
    public Multimap<InventoryType, ICharmEntity> getCharmEntities() {
        return this.charmEntities;
    }

    public void setCharmEntities(Multimap<InventoryType, ICharmEntity> charmEntities) {
        this.charmEntities = charmEntities;
    }

    @Override
    public boolean isSource() {
        return this.source;
    }

    @Override
    public void setSource(boolean source) {
        this.source = source;
    }

    @Override
    public boolean isExecuting() {
        return this.executing;
    }

    @Override
    public void setExecuting(boolean executing) {
        this.executing = executing;
    }

    @Override
    public boolean isBindable() {
        return this.bindable;
    }

    @Override
    public void setBindable(boolean bindable) {
        this.bindable = bindable;
    }

    @Override
    public boolean isSocketable() {
        return this.socketable;
    }

    @Override
    public void setSocketable(boolean socketable) {
        this.socketable = socketable;
    }

    @Override
    public boolean isImbuing() {
        return this.imbuing;
    }

    @Override
    public void setImbuing(boolean imbuing) {
        this.imbuing = imbuing;
    }

    @Override
    public boolean isImbuable() {
        return this.imbuable;
    }

    @Override
    public void setImbuable(boolean imbuable) {
        this.imbuable = imbuable;
    }

    @Override
    public boolean isInnate() {
        return this.innate;
    }

    @Override
    public void setInnate(boolean innate) {
        this.innate = innate;
    }

    @Override
    public ResourceLocation getBaseMaterial() {
        return this.baseMaterial;
    }

    @Override
    public void setBaseMaterial(ResourceLocation baseMaterial) {
        this.baseMaterial = baseMaterial;
    }

    @Override
    public ResourceLocation getSourceItem() {
        return this.sourceItem;
    }

    @Override
    public void setSourceItem(ResourceLocation sourceItem) {
        this.sourceItem = sourceItem;
    }

    @Override
    public ICharmEntity getHighestLevel() {
        return this.highestLevel;
    }

    @Override
    public void setHighestLevel(ICharmEntity highestLevel) {
        this.highestLevel = highestLevel;
    }

    @Override
    public boolean isNamedByMaterial() {
        return this.namedByMaterial;
    }

    @Override
    public void setNamedByMaterial(boolean namedByMaterial) {
        this.namedByMaterial = namedByMaterial;
    }

    @Override
    public boolean isNamedByCharm() {
        return this.namedByCharm;
    }

    @Override
    public void setNamedByCharm(boolean namedByCharm) {
        this.namedByCharm = namedByCharm;
    }

    @Override
    public void setMaxSocketSize(int size) {
        this.maxSocketSize = size;
    }

    @Override
    public int getMaxSocketSize() {
        return this.maxSocketSize;
    }

    @Override
    public int getMaxImbueSize() {
        return this.maxImbueSize;
    }

    @Override
    public int getMaxInnateSize() {
        return this.maxInnateSize;
    }

    @Override
    public int getSocketSize() {
        return this.getCharmEntities().get((Object)InventoryType.SOCKET).size();
    }

    @Override
    public int getImbueSize() {
        return this.getCharmEntities().get((Object)InventoryType.IMBUE).size();
    }

    @Override
    public int getInnateSize() {
        return this.getCharmEntities().get((Object)InventoryType.INNATE).size();
    }

    @Override
    public ILevelModifier getLevelModifier() {
        return this.levelModifier;
    }

    @Override
    public void setLevelModifier(ILevelModifier levelModifier) {
        this.levelModifier = levelModifier;
    }

    public static class Builder {
        public boolean source;
        public boolean executing = true;
        public boolean bindable;
        public boolean socketable;
        public boolean imbuing;
        public boolean imbuable;
        public boolean innate;
        public boolean namedByMaterial;
        public boolean namedByCharm;
        public ResourceLocation baseMaterial = TreasureCharmableMaterials.COPPER.getName();
        public ResourceLocation sourceItem = Items.field_190931_a.getRegistryName();
        public ILevelModifier levelModifier = new NoLevelModifier();
        private int maxSocketSize;
        private int maxImbueSize;
        private int maxInnateSize;

        public Builder(int maxInnateSize, int maxImbueSize, int maxSocketSize) {
            this.maxInnateSize = maxInnateSize;
            this.maxImbueSize = maxImbueSize;
            this.maxSocketSize = maxSocketSize;
        }

        public Builder with(Consumer<Builder> builder) {
            builder.accept(this);
            return this;
        }

        public ICharmableCapability build() {
            return new CharmableCapability(this);
        }
    }

    public static class SortByLevel
    implements Comparator<ICharmEntity> {
        @Override
        public int compare(ICharmEntity e1, ICharmEntity e2) {
            return e1.getCharm().getLevel() - e2.getCharm().getLevel();
        }
    }
}

