/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.adornment;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.adornment.AdornmentSize;
import com.someguyssoftware.treasure2.capability.ICharmableCapability;
import com.someguyssoftware.treasure2.capability.IDurabilityCapability;
import com.someguyssoftware.treasure2.capability.IRunestonesCapability;
import com.someguyssoftware.treasure2.capability.InventoryType;
import com.someguyssoftware.treasure2.capability.TreasureCapabilities;
import com.someguyssoftware.treasure2.enums.AdornmentType;
import com.someguyssoftware.treasure2.item.Adornment;
import com.someguyssoftware.treasure2.material.CharmableMaterial;
import com.someguyssoftware.treasure2.util.ResourceLocationUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class TreasureAdornmentRegistry {
    private static final List<Adornment> ADORNMENTS_CACHE = new ArrayList<Adornment>();
    public static final Map<Key, Adornment> REGISTRY = Maps.newHashMap();
    private static final Multimap<AdornmentType, Adornment> BY_TYPE = ArrayListMultimap.create();
    private static final Multimap<ResourceLocation, Adornment> BY_MATERIAL = ArrayListMultimap.create();
    public static final AdornmentSize STANDARD = new AdornmentSize("standard");
    public static final AdornmentSize GREAT = new AdornmentSize("great"){

        @Override
        public double modifyMaxLevel(double level) {
            return level + 3.0;
        }

        @Override
        public double modifyLevelMultiplier(double multi) {
            return multi + 0.25;
        }
    };
    public static final AdornmentSize LORDS = new AdornmentSize("lords"){

        @Override
        public double modifyMaxLevel(double level) {
            return level + 5.0;
        }

        @Override
        public double modifyLevelMultiplier(double multi) {
            return multi + 0.5;
        }
    };

    public static void register(AdornmentType type, AdornmentSize size, ResourceLocation material, ResourceLocation source, Adornment adornment) {
        TreasureAdornmentRegistry.register(new Key(type, size, material, source), adornment);
    }

    public static void register(ResourceLocation material, ResourceLocation source, Adornment adornment) {
        TreasureAdornmentRegistry.register(new Key(adornment.getType(), adornment.getSize(), material, source), adornment);
    }

    public static void register(Key key, Adornment adornment) {
        REGISTRY.put(key, adornment);
        BY_TYPE.put((Object)key.getType(), (Object)adornment);
        BY_MATERIAL.put((Object)key.getMaterial(), (Object)adornment);
    }

    public static Optional<Adornment> get(AdornmentType type, AdornmentSize size, ResourceLocation material, ResourceLocation source) {
        return TreasureAdornmentRegistry.get(new Key(type, size, material, source));
    }

    public static Optional<Adornment> get(Key key) {
        Adornment adornment = REGISTRY.get(key);
        return adornment == null ? Optional.empty() : Optional.of(adornment);
    }

    public static List<Adornment> getAll() {
        if (ADORNMENTS_CACHE.isEmpty()) {
            ADORNMENTS_CACHE.addAll(REGISTRY.values());
        }
        return ADORNMENTS_CACHE;
    }

    public static List<Adornment> getByType(AdornmentType type) {
        return (List)BY_TYPE.get((Object)type);
    }

    public static List<Adornment> getByMaterial(String material) {
        try {
            return TreasureAdornmentRegistry.getByMaterial(ResourceLocationUtil.create(material));
        }
        catch (Exception e) {
            return TreasureAdornmentRegistry.getAll();
        }
    }

    public static List<Adornment> getByMaterial(ResourceLocation material) {
        return (List)BY_MATERIAL.get((Object)material);
    }

    public static List<Adornment> getByMaterial(CharmableMaterial material) {
        return TreasureAdornmentRegistry.getByMaterial(material.getName());
    }

    public static Optional<Adornment> getAdornment(ItemStack baseStack, ItemStack stoneStack) {
        if (baseStack.hasCapability(TreasureCapabilities.CHARMABLE, null) && baseStack.func_77973_b() instanceof Adornment) {
            ICharmableCapability cap = (ICharmableCapability)baseStack.getCapability(TreasureCapabilities.CHARMABLE, null);
            Adornment sourceAdornment = (Adornment)baseStack.func_77973_b();
            return TreasureAdornmentRegistry.get(sourceAdornment.getType(), sourceAdornment.getSize(), cap.getBaseMaterial(), stoneStack.func_77973_b().getRegistryName());
        }
        return Optional.empty();
    }

    public static ItemStack copyStack(ItemStack source, ItemStack dest) {
        ItemStack resultStack = dest.func_77946_l();
        ResourceLocation sourceItem = ((ICharmableCapability)resultStack.getCapability(TreasureCapabilities.CHARMABLE, null)).getSourceItem();
        resultStack.func_77964_b(source.func_77952_i());
        if (resultStack.hasCapability(TreasureCapabilities.DURABILITY, null)) {
            Treasure.LOGGER.debug("calling durability copyTo()");
            ((IDurabilityCapability)source.getCapability(TreasureCapabilities.DURABILITY, null)).copyTo(resultStack);
        }
        if (dest.hasCapability(TreasureCapabilities.CHARMABLE, null)) {
            ((ICharmableCapability)resultStack.getCapability(TreasureCapabilities.CHARMABLE, null)).clearCharms();
            ((ICharmableCapability)source.getCapability(TreasureCapabilities.CHARMABLE, null)).copyTo(resultStack);
        }
        if (dest.hasCapability(TreasureCapabilities.RUNESTONES, null)) {
            ((IRunestonesCapability)resultStack.getCapability(TreasureCapabilities.RUNESTONES, null)).clear();
            ((IRunestonesCapability)source.getCapability(TreasureCapabilities.RUNESTONES, null)).copyTo(resultStack);
        }
        ((ICharmableCapability)resultStack.getCapability(TreasureCapabilities.CHARMABLE, null)).setSourceItem(sourceItem);
        return resultStack;
    }

    public static Optional<ItemStack> transferCapabilities(ItemStack source, ItemStack dest, InventoryType sourceType, InventoryType destType) {
        Treasure.LOGGER.debug("transfering caps...");
        ItemStack stack = new ItemStack(dest.func_77973_b());
        stack.func_77964_b(dest.func_77952_i());
        if (dest.hasCapability(TreasureCapabilities.DURABILITY, null)) {
            ((IDurabilityCapability)dest.getCapability(TreasureCapabilities.DURABILITY, null)).copyTo(stack);
        }
        Treasure.LOGGER.debug("new stack damage -> {}", (Object)stack.func_77952_i());
        boolean charmSizeChanged = false;
        boolean runeSizeChanged = false;
        if (dest.hasCapability(TreasureCapabilities.CHARMABLE, null)) {
            ((ICharmableCapability)stack.getCapability(TreasureCapabilities.CHARMABLE, null)).clearCharms();
            ((ICharmableCapability)dest.getCapability(TreasureCapabilities.CHARMABLE, null)).copyTo(stack);
            if (source.hasCapability(TreasureCapabilities.CHARMABLE, null)) {
                ((ICharmableCapability)source.getCapability(TreasureCapabilities.CHARMABLE, null)).transferTo(stack, sourceType, destType);
                if (((ICharmableCapability)stack.getCapability(TreasureCapabilities.CHARMABLE, null)).getCurrentSize(destType) > ((ICharmableCapability)dest.getCapability(TreasureCapabilities.CHARMABLE, null)).getCurrentSize(destType)) {
                    charmSizeChanged = true;
                }
            }
        }
        if (dest.hasCapability(TreasureCapabilities.RUNESTONES, null)) {
            ((IRunestonesCapability)stack.getCapability(TreasureCapabilities.RUNESTONES, null)).clear();
            Treasure.LOGGER.debug("before copyTo, runes size -> {}", (Object)((IRunestonesCapability)stack.getCapability(TreasureCapabilities.RUNESTONES, null)).getEntitiesCopy().size());
            ((IRunestonesCapability)dest.getCapability(TreasureCapabilities.RUNESTONES, null)).copyTo(stack);
            Treasure.LOGGER.debug("after copyTo, runes size -> {}", (Object)((IRunestonesCapability)stack.getCapability(TreasureCapabilities.RUNESTONES, null)).getEntitiesCopy().size());
            if (source.hasCapability(TreasureCapabilities.RUNESTONES, null)) {
                Treasure.LOGGER.debug("source(runestone)'s runes ->");
                ((IRunestonesCapability)source.getCapability(TreasureCapabilities.RUNESTONES, null)).getEntities(InventoryType.INNATE).forEach(entity -> Treasure.LOGGER.debug("source entity -> {}", entity));
                ((IRunestonesCapability)source.getCapability(TreasureCapabilities.RUNESTONES, null)).transferTo(stack, sourceType, destType);
                Treasure.LOGGER.debug("after transferTo, runes size -> {}", (Object)((IRunestonesCapability)stack.getCapability(TreasureCapabilities.RUNESTONES, null)).getEntitiesCopy().size());
                if (((IRunestonesCapability)stack.getCapability(TreasureCapabilities.RUNESTONES, null)).getCurrentSize(destType) > ((IRunestonesCapability)dest.getCapability(TreasureCapabilities.RUNESTONES, null)).getCurrentSize(destType)) {
                    runeSizeChanged = true;
                }
            }
        }
        if (charmSizeChanged | runeSizeChanged) {
            return Optional.of(stack);
        }
        return Optional.empty();
    }

    public static class Key {
        private AdornmentType type;
        private AdornmentSize size;
        private ResourceLocation material;
        private ResourceLocation source;

        public Key(AdornmentType type, AdornmentSize size, ResourceLocation material, ResourceLocation source) {
            this.type = type;
            this.size = size;
            this.material = material;
            this.source = source;
        }

        public AdornmentType getType() {
            return this.type;
        }

        public void setType(AdornmentType type) {
            this.type = type;
        }

        public ResourceLocation getMaterial() {
            return this.material;
        }

        public void setMaterial(ResourceLocation material) {
            this.material = material;
        }

        public ResourceLocation getSource() {
            return this.source;
        }

        public void setSource(ResourceLocation source) {
            this.source = source;
        }

        public AdornmentSize getSize() {
            return this.size;
        }

        public void setSize(AdornmentSize size) {
            this.size = size;
        }

        public String toString() {
            return "Key [type=" + this.type + ", size=" + this.size + ", material=" + this.material + ", source=" + this.source + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.material == null ? 0 : this.material.hashCode());
            result = 31 * result + (this.size == null ? 0 : this.size.hashCode());
            result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.material == null ? other.material != null : !this.material.equals((Object)other.material)) {
                return false;
            }
            if (this.size == null ? other.size != null : !this.size.equals(other.size)) {
                return false;
            }
            if (this.source == null ? other.source != null : !this.source.equals((Object)other.source)) {
                return false;
            }
            return this.type == other.type;
        }
    }
}

