/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.world;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import pokefenn.totemic.api.TotemicRegistries;
import pokefenn.totemic.api.totem.TotemEffect;
import pokefenn.totemic.block.totem.BlockTotemBase;
import pokefenn.totemic.block.totem.BlockTotemPole;
import pokefenn.totemic.init.ModBlocks;
import pokefenn.totemic.init.ModVillagers;
import pokefenn.totemic.lib.WoodVariant;
import pokefenn.totemic.tileentity.totem.TileTotemPole;

public class ComponentMedicineWheel
extends StructureVillagePieces.Village {
    private WoodVariant poleWood = WoodVariant.CEDAR;

    public ComponentMedicineWheel() {
    }

    public ComponentMedicineWheel(StructureVillagePieces.Start start, int type, Random rand, StructureBoundingBox bb, EnumFacing facing) {
        super(start, type);
        this.func_186164_a(facing);
        this.field_74887_e = bb;
        if (rand.nextBoolean()) {
            switch (type) {
                default: {
                    this.poleWood = WoodVariant.OAK;
                    break;
                }
                case 2: {
                    this.poleWood = WoodVariant.ACACIA;
                    break;
                }
                case 3: {
                    this.poleWood = WoodVariant.SPRUCE;
                    break;
                }
            }
        } else {
            this.poleWood = WoodVariant.CEDAR;
        }
    }

    public static ComponentMedicineWheel createPiece(StructureVillagePieces.Start startPiece, List<StructureComponent> pieces, Random random, int strucMinX, int strucMinY, int strucMinZ, EnumFacing facing, int type) {
        StructureBoundingBox bb = StructureBoundingBox.func_175897_a((int)strucMinX, (int)strucMinY, (int)strucMinZ, (int)0, (int)0, (int)0, (int)9, (int)6, (int)9, (EnumFacing)facing);
        if (ComponentMedicineWheel.func_74895_a((StructureBoundingBox)bb) && StructureComponent.func_74883_a(pieces, (StructureBoundingBox)bb) == null) {
            return new ComponentMedicineWheel(startPiece, type, random, bb, facing);
        }
        return null;
    }

    public boolean func_74875_a(World world, Random random, StructureBoundingBox bb) {
        if (this.field_143015_k < 0) {
            this.field_143015_k = this.func_74889_b(world, bb);
            if (this.field_143015_k < 0) {
                return true;
            }
            this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 6 - 1, 0);
        }
        this.func_74878_a(world, bb, 2, 0, 0, 6, 5, 0);
        this.func_74878_a(world, bb, 1, 0, 1, 7, 5, 1);
        this.func_74878_a(world, bb, 0, 0, 2, 8, 5, 6);
        this.func_74878_a(world, bb, 1, 0, 7, 7, 5, 7);
        this.func_74878_a(world, bb, 2, 0, 8, 6, 5, 8);
        this.func_175811_a(world, ModBlocks.totem_base.func_176223_P().func_177226_a((IProperty)BlockTotemBase.FACING, (Comparable)EnumFacing.SOUTH).func_177226_a(BlockTotemBase.WOOD, (Comparable)((Object)this.poleWood)), 4, 0, 4, bb);
        ArrayList totemList = new ArrayList(TotemicRegistries.totemEffects().getValuesCollection());
        for (int i = 0; i < 5; ++i) {
            int x = 4;
            int y = 1 + i;
            int z = 4;
            this.func_175811_a(world, ModBlocks.totem_pole.func_176223_P().func_177226_a((IProperty)BlockTotemBase.FACING, (Comparable)EnumFacing.SOUTH).func_177226_a(BlockTotemPole.WOOD, (Comparable)((Object)this.poleWood)), x, y, z, bb);
            BlockPos pos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
            TileEntity tile = world.func_175625_s(pos);
            if (!(tile instanceof TileTotemPole)) continue;
            ((TileTotemPole)tile).setEffect((TotemEffect)((Object)totemList.get(random.nextInt(totemList.size()))));
        }
        this.func_175811_a(world, ModBlocks.drum.func_176223_P(), 4, 0, 0, bb);
        this.func_175811_a(world, ModBlocks.drum.func_176223_P(), 0, 0, 4, bb);
        this.func_175811_a(world, ModBlocks.drum.func_176223_P(), 8, 0, 4, bb);
        IBlockState log = this.func_175847_a(Blocks.field_150364_r.func_176223_P());
        IBlockState log_z = this.func_175847_a(Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Z));
        for (int i = 0; i < 3; ++i) {
            this.func_175811_a(world, log, 4, i, 8, bb);
        }
        this.func_175811_a(world, log_z, 4, 3, 8, bb);
        this.func_175811_a(world, log_z, 4, 3, 7, bb);
        this.func_175811_a(world, ModBlocks.wind_chime.func_176223_P(), 4, 2, 7, bb);
        if (!this.field_189929_i) {
            this.func_175811_a(world, ModBlocks.totem_torch.func_176223_P(), 1, 0, 1, bb);
            this.func_175811_a(world, ModBlocks.totem_torch.func_176223_P(), 7, 0, 1, bb);
            this.func_175811_a(world, ModBlocks.totem_torch.func_176223_P(), 7, 0, 7, bb);
            this.func_175811_a(world, ModBlocks.totem_torch.func_176223_P(), 1, 0, 7, bb);
        }
        IBlockState ground = this.field_189928_h != 1 ? Blocks.field_150346_d.func_176223_P() : Blocks.field_150354_m.func_176223_P();
        IBlockState grass = this.func_175847_a(Blocks.field_150349_c.func_176223_P());
        for (int z = 0; z < 9; ++z) {
            for (int x = 0; x < 9; ++x) {
                if (!((x != 0 && x != 8 || z > 1 && z < 7) && (x != 1 && x != 7 || z != 0 && z != 8))) continue;
                this.func_74871_b(world, x, 6, z, bb);
                this.func_175808_b(world, ground, x, -1, z, bb);
                if (this.func_175807_a(world, x, -1, z, bb).func_177230_c() != Blocks.field_150346_d) continue;
                this.func_175811_a(world, grass, x, -1, z, bb);
            }
        }
        IBlockState cobble = this.func_175847_a(Blocks.field_150347_e.func_176223_P());
        if (cobble.func_177230_c() == Blocks.field_150322_A) {
            cobble = Blocks.field_180395_cM.func_176223_P();
        }
        this.func_175804_a(world, bb, 4, -1, 0, 4, -1, 8, cobble, cobble, false);
        this.func_175804_a(world, bb, 0, -1, 4, 8, -1, 4, cobble, cobble, false);
        this.func_175811_a(world, cobble, 5, -1, 0, bb);
        this.func_175811_a(world, cobble, 6, -1, 0, bb);
        this.func_175811_a(world, cobble, 7, -1, 1, bb);
        this.func_175811_a(world, cobble, 8, -1, 2, bb);
        this.func_175811_a(world, cobble, 8, -1, 3, bb);
        this.func_175811_a(world, cobble, 8, -1, 5, bb);
        this.func_175811_a(world, cobble, 8, -1, 6, bb);
        this.func_175811_a(world, cobble, 7, -1, 7, bb);
        this.func_175811_a(world, cobble, 6, -1, 8, bb);
        this.func_175811_a(world, cobble, 5, -1, 8, bb);
        this.func_175811_a(world, cobble, 3, -1, 8, bb);
        this.func_175811_a(world, cobble, 2, -1, 8, bb);
        this.func_175811_a(world, cobble, 1, -1, 7, bb);
        this.func_175811_a(world, cobble, 0, -1, 6, bb);
        this.func_175811_a(world, cobble, 0, -1, 5, bb);
        this.func_175811_a(world, cobble, 0, -1, 3, bb);
        this.func_175811_a(world, cobble, 0, -1, 2, bb);
        this.func_175811_a(world, cobble, 1, -1, 1, bb);
        this.func_175811_a(world, cobble, 2, -1, 0, bb);
        this.func_175811_a(world, cobble, 3, -1, 0, bb);
        this.func_74893_a(world, bb, 4, 1, 2, 1);
        return true;
    }

    protected VillagerRegistry.VillagerProfession chooseForgeProfession(int count, VillagerRegistry.VillagerProfession prof) {
        return ModVillagers.profTotemist;
    }

    protected void func_143012_a(NBTTagCompound tag) {
        super.func_143012_a(tag);
        tag.func_74774_a("PoleWood", (byte)this.poleWood.getID());
    }

    protected void func_143011_b(NBTTagCompound tag, TemplateManager templateMgr) {
        super.func_143011_b(tag, templateMgr);
        this.poleWood = WoodVariant.fromID(tag.func_74762_e("PoleWood"));
    }

    public static class CreationHandler
    implements VillagerRegistry.IVillageCreationHandler {
        public StructureVillagePieces.PieceWeight getVillagePieceWeight(Random random, int size) {
            return new StructureVillagePieces.PieceWeight(ComponentMedicineWheel.class, 15, MathHelper.func_76136_a((Random)random, (int)(0 + size), (int)(1 + size)));
        }

        public Class<?> getComponentClass() {
            return ComponentMedicineWheel.class;
        }

        public StructureVillagePieces.Village buildComponent(StructureVillagePieces.PieceWeight villagePiece, StructureVillagePieces.Start startPiece, List<StructureComponent> pieces, Random random, int strucMinX, int strucMinY, int strucMinZ, EnumFacing facing, int type) {
            return ComponentMedicineWheel.createPiece(startPiece, pieces, random, strucMinX, strucMinY, strucMinZ, facing, type);
        }
    }
}

