/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.item.equipment.music;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.api.music.ItemInstrument;
import pokefenn.totemic.init.ModSounds;
import pokefenn.totemic.util.EntityUtil;

public class ItemFlute
extends ItemInstrument {
    private final Set<Entity> temptedEntities = Collections.newSetFromMap(new WeakHashMap());

    public ItemFlute() {
        this.setSound(ModSounds.flute);
        this.setRegistryName("flute");
        this.func_77655_b("totemic:flute");
        this.func_77637_a(Totemic.tabsTotem);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        if (stack.func_77952_i() == 1) {
            tooltip.add(I18n.func_135052_a((String)(this.func_77658_a() + ".tooltip1"), (Object[])new Object[0]));
        }
        tooltip.add(I18n.func_135052_a((String)(this.func_77658_a() + ".tooltip0"), (Object[])new Object[0]));
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            this.useInstrument(stack, (Entity)player, 20);
            if (stack.func_77952_i() == 1 && !player.func_70093_af()) {
                this.temptEntities(world, player.field_70165_t, player.field_70163_u, player.field_70161_v);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return stack.func_77952_i() == 1 ? EnumRarity.UNCOMMON : EnumRarity.COMMON;
    }

    @Override
    protected void playMusic(ItemStack stack, Entity entity) {
        int bonusMusic = stack.func_77952_i() == 1 ? entity.field_70170_p.field_73012_v.nextInt(2) : 0;
        TotemicAPI.get().music().playMusic(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity, this.instrument, 5, this.instrument.getBaseOutput() + bonusMusic);
        this.spawnParticles((WorldServer)entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, false);
        if (this.sound != null) {
            entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, this.sound, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    private void temptEntities(World world, double x, double y, double z) {
        for (EntityLiving entity2 : EntityUtil.listEntitiesInRange(EntityLiving.class, world, x, y, z, 2.0, 2.0, entity -> (entity instanceof EntityAnimal && entity.func_70661_as() instanceof PathNavigateGround || entity instanceof EntityVillager) && !this.temptedEntities.contains(entity))) {
            double speed = entity2 instanceof EntityAnimal ? 1.0 : 0.5;
            entity2.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAITempt((EntityCreature)entity2, speed, (Item)this, false));
            this.temptedEntities.add((Entity)entity2);
        }
    }

    public String func_77667_c(ItemStack stack) {
        if (stack.func_77952_i() == 1) {
            return "item.totemic:infused_flute";
        }
        return "item.totemic:flute";
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            list.add((Object)new ItemStack((Item)this, 1, 0));
            list.add((Object)new ItemStack((Item)this, 1, 1));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77952_i() == 1;
    }
}

