/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.timecore.client.obj.loader.model;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.MathHelper;
import ru.timeconqueror.timecore.api.client.obj.model.ObjModelBase;
import ru.timeconqueror.timecore.api.client.obj.model.ObjModelRenderer;
import ru.timeconqueror.timecore.client.obj.loader.ObjModel;

public class ObjModelBiped
extends ObjModelBase {
    public ObjModelRenderer head;
    public ObjModelRenderer body;
    public ObjModelRenderer armRight;
    public ObjModelRenderer armLeft;
    public ObjModelRenderer legRight;
    public ObjModelRenderer legLeft;
    public boolean isSneak;

    public ObjModelBiped(ObjModel modelIn, String head, String body, String armLeft, String armRight, String legLeft, String legRight) {
        super(modelIn);
        this.initParts(head, body, armLeft, armRight, legLeft, legRight);
    }

    public void initParts(String head, String body, String armLeft, String armRight, String legLeft, String legRight) {
        for (ObjModelRenderer renderer : this.model.getParts()) {
            if (renderer.getName().equals(head)) {
                this.head = renderer;
                continue;
            }
            if (renderer.getName().equals(body)) {
                this.body = renderer;
                continue;
            }
            if (renderer.getName().equals(armLeft)) {
                this.armLeft = renderer;
                continue;
            }
            if (renderer.getName().equals(armRight)) {
                this.armRight = renderer;
                continue;
            }
            if (renderer.getName().equals(legLeft)) {
                this.legLeft = renderer;
                continue;
            }
            if (!renderer.getName().equals(legRight)) continue;
            this.legRight = renderer;
        }
    }

    @Override
    public void func_78088_a(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, entityIn);
        GlStateManager.func_179094_E();
        if (this.field_78091_s) {
            float f = 2.0f;
            GlStateManager.func_179152_a((float)0.75f, (float)0.75f, (float)0.75f);
            GlStateManager.func_179109_b((float)0.0f, (float)(16.0f * scale), (float)0.0f);
            this.head.render(scale);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.func_179109_b((float)0.0f, (float)(24.0f * scale), (float)0.0f);
            this.body.render(scale);
            this.armRight.render(scale);
            this.armLeft.render(scale);
            this.legRight.render(scale);
            this.legLeft.render(scale);
        } else {
            if (entityIn.func_70093_af()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
            }
            this.head.render(scale);
            this.body.render(scale);
            this.armRight.render(scale);
            this.armLeft.render(scale);
            this.legRight.render(scale);
            this.legLeft.render(scale);
        }
        GlStateManager.func_179121_F();
    }

    public void func_78087_a(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entityIn) {
        boolean flag = entityIn instanceof EntityLivingBase && ((EntityLivingBase)entityIn).func_184599_cB() > 4;
        this.head.rotateAngleY = netHeadYaw * ((float)Math.PI / 180);
        this.head.rotateAngleX = flag ? -0.7853982f : headPitch * ((float)Math.PI / 180);
        this.body.rotateAngleY = 0.0f;
        float f = 1.0f;
        if (flag) {
            f = (float)(entityIn.field_70159_w * entityIn.field_70159_w + entityIn.field_70181_x * entityIn.field_70181_x + entityIn.field_70179_y * entityIn.field_70179_y);
            f /= 0.2f;
            f = f * f * f;
        }
        if (f < 1.0f) {
            f = 1.0f;
        }
        this.armRight.rotateAngleX = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f / f;
        this.armLeft.rotateAngleX = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f / f;
        this.armRight.rotateAngleZ = 0.0f;
        this.armLeft.rotateAngleZ = 0.0f;
        this.legRight.rotateAngleX = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount / f;
        this.legLeft.rotateAngleX = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount / f;
        this.legRight.rotateAngleY = 0.0f;
        this.legLeft.rotateAngleY = 0.0f;
        this.legRight.rotateAngleZ = 0.0f;
        this.legLeft.rotateAngleZ = 0.0f;
        if (this.field_78093_q) {
            this.armRight.rotateAngleX += -0.62831855f;
            this.armLeft.rotateAngleX += -0.62831855f;
            this.legRight.rotateAngleX = -1.4137167f;
            this.legRight.rotateAngleY = 0.31415927f;
            this.legRight.rotateAngleZ = 0.07853982f;
            this.legLeft.rotateAngleX = -1.4137167f;
            this.legLeft.rotateAngleY = -0.31415927f;
            this.legLeft.rotateAngleZ = -0.07853982f;
        }
        this.armRight.rotateAngleY = 0.0f;
        this.armRight.rotateAngleZ = 0.0f;
        this.armRight.rotateAngleZ += MathHelper.func_76134_b((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        this.armLeft.rotateAngleZ -= MathHelper.func_76134_b((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        this.armRight.rotateAngleX += MathHelper.func_76126_a((float)(ageInTicks * 0.067f)) * 0.05f;
        this.armLeft.rotateAngleX -= MathHelper.func_76126_a((float)(ageInTicks * 0.067f)) * 0.05f;
    }

    public void func_178686_a(ModelBase model) {
        super.func_178686_a(model);
        if (model instanceof ModelBiped) {
            ModelBiped modelbiped = (ModelBiped)model;
            this.isSneak = modelbiped.field_78117_n;
        }
    }

    public void setVisible(boolean state) {
        this.head.isHidden = !state;
        this.body.isHidden = !state;
        this.armRight.isHidden = !state;
        this.armLeft.isHidden = !state;
        this.legRight.isHidden = !state;
        this.legLeft.isHidden = !state;
    }

    protected ObjModelRenderer getArmForSide(EnumHandSide side) {
        return side == EnumHandSide.LEFT ? this.armLeft : this.armRight;
    }

    protected EnumHandSide getMainHand(Entity entityIn) {
        if (entityIn instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)entityIn;
            EnumHandSide enumhandside = entitylivingbase.func_184591_cq();
            return entitylivingbase.field_184622_au == EnumHand.MAIN_HAND ? enumhandside : enumhandside.func_188468_a();
        }
        return EnumHandSide.RIGHT;
    }
}

