/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.tidychunk.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.lang3.StringUtils;
import org.blockartistry.tidychunk.TidyChunk;

public class Translations {
    public static final String DEFAULT_LANGUAGE = "en_us";
    private Map<String, String> lookup = new HashMap<String, String>();

    protected void merge(@Nonnull InputStream stream) throws IOException {
        FMLCommonHandler.instance().loadLanguage(this.lookup, stream);
    }

    public void load(@Nonnull String assetRoot, String ... languages) {
        for (String lang : languages) {
            String assetName = StringUtils.appendIfMissing((String)assetRoot, (CharSequence)"/", (CharSequence[])new CharSequence[0]) + lang + ".lang";
            try (InputStream stream = Translations.class.getResourceAsStream(assetName);){
                if (stream == null) continue;
                this.merge(stream);
            }
            catch (Throwable t) {
                TidyChunk.log().error("Error merging language " + assetName, t);
            }
        }
    }

    @Nonnull
    public String format(@Nonnull String translateKey, Object ... parameters) {
        String xlated = this.lookup.get(translateKey);
        return xlated == null ? translateKey : String.format(xlated, parameters);
    }

    @Nonnull
    public String loadString(@Nonnull String translateKey) {
        String xlated = this.lookup.get(translateKey);
        return xlated == null ? translateKey : xlated;
    }

    public void put(@Nonnull String key, @Nonnull String value) {
        this.lookup.put(key, value);
    }

    public void forAll(@Nonnull Predicate<Map.Entry<String, String>> pred) {
        for (Map.Entry<String, String> e : this.lookup.entrySet()) {
            pred.apply(e);
        }
    }

    public void transform(@Nonnull Function<Map.Entry<String, String>, String> func) {
        Map<String, String> old = this.lookup;
        this.lookup = new HashMap<String, String>();
        for (Map.Entry<String, String> e : old.entrySet()) {
            this.lookup.put(e.getKey(), (String)func.apply(e));
        }
    }
}

