/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.tidychunk;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.blockartistry.tidychunk.TidyChunk;

@Mod.EventBusSubscriber(modid="tidychunk")
@Config(modid="tidychunk", type=Config.Type.INSTANCE, name="tidychunk")
public class Configuration {
    @Config.LangKey(value="config.tidychunk.logging")
    public static Logging logging = new Logging();
    @Config.LangKey(value="config.tidychunk.options")
    public static Options options = new Options();

    @SubscribeEvent
    public static void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("tidychunk")) {
            ConfigManager.sync((String)"tidychunk", (Config.Type)Config.Type.INSTANCE);
            TidyChunk.log().setDebug(Configuration.logging.enableLogging);
        }
    }

    public static class Options {
        @Config.LangKey(value="config.tidychunk.options.tickspan")
        @Config.Comment(value={"Number of ticks post chunk generation to check for EntityItems", "0 means use internal default (10 ticks)"})
        @Config.RangeInt(min=0, max=100)
        public int tickSpan = 0;
        @Config.LangKey(value="config.tidychunk.options.fakeplayers")
        @Config.Comment(value={"List of fake players from which to remove block drops", "May not work in all circumstances due to Forge swiss army knife interfaces"})
        public String[] fakePlayers = new String[0];
    }

    public static class Logging {
        @Config.LangKey(value="config.tidychunk.logging.enableLogging")
        @Config.Comment(value={"Enables debug logging output for diagnostics"})
        public boolean enableLogging = false;
        @Config.LangKey(value="config.tidychunk.logging.enableVersionCheck")
        @Config.Comment(value={"Enables display of chat messages related to newer versions", "of the mod being available."})
        public boolean enableVersionCheck = true;
    }
}

