/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.multiblock;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class NoComodSet<E>
extends AbstractSet<E> {
    public final Set<E> set;
    int modCount = 0;

    public NoComodSet() {
        this(new LinkedHashSet());
    }

    public NoComodSet(Set<E> set) {
        this.set = set;
    }

    @Override
    public boolean add(E aMultiBlock) {
        this.updateModCount();
        return this.set.add(aMultiBlock);
    }

    public void updateModCount() {
        ++this.modCount;
    }

    @Override
    public void clear() {
        this.updateModCount();
        this.set.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    public boolean remove(Object o) {
        this.updateModCount();
        return this.set.remove(o);
    }

    @Override
    public Iterator<E> iterator() {
        return new NoComodIterator(this.set.iterator());
    }

    @Override
    public int size() {
        return this.set.size();
    }

    public class NoComodIterator
    implements Iterator<E> {
        private final Iterator<E> iterator;
        int expectedModCount;

        public NoComodIterator(Iterator<E> iterator) {
            this.iterator = iterator;
            this.expectedModCount = NoComodSet.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.expectedModCount == NoComodSet.this.modCount && this.iterator.hasNext();
        }

        @Override
        public E next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

