/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.util.phys;

import java.util.Arrays;
import thebetweenlands.util.phys.DiffEqSolver;
import thebetweenlands.util.phys.Simulation;

public final class RungeKuttaSolver
implements DiffEqSolver {
    private final Simulation sim;
    private float[] inp = new float[0];
    private float[] k1 = new float[0];
    private float[] k2 = new float[0];
    private float[] k3 = new float[0];
    private float[] k4 = new float[0];

    public RungeKuttaSolver(Simulation sim) {
        this.sim = sim;
    }

    @Override
    public void step(float stepSize) {
        int i;
        float[] vars = this.sim.getState();
        int N = vars.length;
        if (this.inp.length < N) {
            this.inp = new float[N];
            this.k1 = new float[N];
            this.k2 = new float[N];
            this.k3 = new float[N];
            this.k4 = new float[N];
        }
        float[] inp = this.inp;
        float[] k1 = this.k1;
        float[] k2 = this.k2;
        float[] k3 = this.k3;
        float[] k4 = this.k4;
        System.arraycopy(vars, 0, inp, 0, N);
        Arrays.fill(k1, 0.0f);
        this.sim.evaluate(inp, k1);
        for (i = 0; i < N; ++i) {
            inp[i] = vars[i] + k1[i] * stepSize / 2.0f;
        }
        Arrays.fill(k2, 0.0f);
        this.sim.evaluate(inp, k2);
        for (i = 0; i < N; ++i) {
            inp[i] = vars[i] + k2[i] * stepSize / 2.0f;
        }
        Arrays.fill(k3, 0.0f);
        this.sim.evaluate(inp, k3);
        for (i = 0; i < N; ++i) {
            inp[i] = vars[i] + k3[i] * stepSize;
        }
        Arrays.fill(k4, 0.0f);
        this.sim.evaluate(inp, k4);
        for (i = 0; i < N; ++i) {
            int n = i;
            vars[n] = vars[n] + (k1[i] + 2.0f * k2[i] + 2.0f * k3[i] + k4[i]) * stepSize / 6.0f;
        }
    }
}

