/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.util;

import net.minecraft.client.shader.Framebuffer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public class Stencil
implements AutoCloseable {
    private static final Stencil INVALID = new Stencil(-1);
    public final int bit;
    public final int mask;

    private Stencil(int bit) {
        this.bit = bit;
        this.mask = !this.valid() ? 0 : 1 << bit;
    }

    public boolean valid() {
        return this.bit != -1;
    }

    public void clear(boolean value) {
        GL11.glStencilMask((int)this.mask);
        GL11.glClearStencil((int)(value ? this.mask : 0));
        GL11.glClear((int)1024);
    }

    public void op(int fail, int zfail, int zpass) {
        GL11.glStencilMask((int)this.mask);
        GL11.glStencilOp((int)fail, (int)zfail, (int)zpass);
    }

    public void op(int func) {
        this.op(func, func, func);
    }

    public void func(int func, boolean value) {
        GL11.glStencilFunc((int)func, (int)(value ? this.mask : 0), (int)this.mask);
    }

    @Override
    public void close() {
        if (this.valid()) {
            MinecraftForgeClient.releaseStencilBit((int)this.bit);
        }
    }

    public static Stencil reserve(Framebuffer framebuffer) {
        int stencilBit = MinecraftForgeClient.reserveStencilBit();
        if (stencilBit >= 0) {
            if (framebuffer.isStencilEnabled() || framebuffer.enableStencil()) {
                return new Stencil(stencilBit);
            }
            MinecraftForgeClient.releaseStencilBit((int)stencilBit);
        }
        return INVALID;
    }
}

