/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature;

import java.util.Random;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.gen.biome.decorator.DecorationHelper;

public class WorldGenBigBulbCappedMushroom
extends WorldGenerator {
    private IBlockState head;
    private IBlockState stalk;

    public void generateHead(World world, BlockPos pos) {
        int startY;
        world.func_180501_a(pos, this.head, 2);
        world.func_180501_a(pos.func_177982_a(0, -1, 0), this.head, 2);
        for (int yy = startY = pos.func_177956_o(); yy >= startY - 4; --yy) {
            pos = new BlockPos(pos.func_177958_n(), yy, pos.func_177952_p());
            world.func_180501_a(pos.func_177982_a(1, 0, 0), this.head, 2);
            world.func_180501_a(pos.func_177982_a(-1, 0, 0), this.head, 2);
            world.func_180501_a(pos.func_177982_a(0, 0, 1), this.head, 2);
            world.func_180501_a(pos.func_177982_a(0, 0, -1), this.head, 2);
            world.func_180501_a(pos.func_177982_a(1, 0, -1), this.head, 2);
            world.func_180501_a(pos.func_177982_a(-1, 0, -1), this.head, 2);
            world.func_180501_a(pos.func_177982_a(1, 0, 1), this.head, 2);
            world.func_180501_a(pos.func_177982_a(-1, 0, 1), this.head, 2);
            if (yy < startY - 3 || yy > startY - 1) continue;
            world.func_180501_a(pos.func_177982_a(-2, 0, 0), this.head, 2);
            world.func_180501_a(pos.func_177982_a(2, 0, 0), this.head, 2);
            world.func_180501_a(pos.func_177982_a(0, 0, -2), this.head, 2);
            world.func_180501_a(pos.func_177982_a(0, 0, 2), this.head, 2);
            world.func_180501_a(pos.func_177982_a(-2, 0, -1), this.head, 2);
            world.func_180501_a(pos.func_177982_a(-2, 0, 1), this.head, 2);
            world.func_180501_a(pos.func_177982_a(2, 0, -1), this.head, 2);
            world.func_180501_a(pos.func_177982_a(2, 0, 1), this.head, 2);
            world.func_180501_a(pos.func_177982_a(-1, 0, 2), this.head, 2);
            world.func_180501_a(pos.func_177982_a(1, 0, 2), this.head, 2);
            world.func_180501_a(pos.func_177982_a(-1, 0, -2), this.head, 2);
            world.func_180501_a(pos.func_177982_a(1, 0, -2), this.head, 2);
        }
    }

    public boolean func_180709_b(World world, Random rand, BlockPos position) {
        this.head = BlockRegistry.BULB_CAPPED_MUSHROOM_CAP.func_176223_P();
        this.stalk = BlockRegistry.BULB_CAPPED_MUSHROOM_STALK.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y);
        int height = rand.nextInt(2) + 8;
        int maxRadius = 2;
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        int x = position.func_177958_n();
        int y = position.func_177956_o();
        int z = position.func_177952_p();
        for (int xx = x - maxRadius; xx <= x + maxRadius; ++xx) {
            for (int zz = z - maxRadius; zz <= z + maxRadius; ++zz) {
                for (int yy = y + 2; yy < y + height; ++yy) {
                    if (world.func_175623_d((BlockPos)checkPos.func_181079_c(xx, yy, zz))) continue;
                    return false;
                }
            }
        }
        for (int yy = y; yy < y + height; ++yy) {
            if (yy == y) {
                world.func_180501_a(new BlockPos(x, yy, z), this.stalk, 2);
            } else {
                world.func_180501_a(new BlockPos(x, yy, z), this.stalk, 2);
            }
            if (yy != y + height - 1) continue;
            this.generateHead(world, new BlockPos(x, yy, z));
        }
        DecorationHelper.GEN_BULB_CAPPED_MUSHROOMS.func_180709_b(world, rand, position);
        return true;
    }
}

