/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.event;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.world.World;
import thebetweenlands.api.environment.IPredictableEnvironmentEvent;
import thebetweenlands.common.network.datamanager.GenericDataManager;
import thebetweenlands.common.registries.GameruleRegistry;
import thebetweenlands.common.world.event.BLEnvironmentEvent;
import thebetweenlands.common.world.event.BLEnvironmentEventRegistry;

public abstract class TimedEnvironmentEvent
extends BLEnvironmentEvent
implements IPredictableEnvironmentEvent {
    protected static final DataParameter<Integer> TICKS = GenericDataManager.createKey(TimedEnvironmentEvent.class, DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> START_TICKS = GenericDataManager.createKey(TimedEnvironmentEvent.class, DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> NEXT_DURATION = GenericDataManager.createKey(TimedEnvironmentEvent.class, DataSerializers.field_187192_b);
    protected ActiveStateEstimator activeStateEstimator = new ActiveStateEstimator(this);

    public TimedEnvironmentEvent(BLEnvironmentEventRegistry registry) {
        super(registry);
    }

    @Override
    protected void initDataParameters() {
        super.initDataParameters();
        this.dataManager.register(TICKS, 20, 0);
        this.dataManager.register(START_TICKS, 0);
        this.dataManager.register(NEXT_DURATION, 0);
    }

    @Override
    public void update(World world) {
        super.update(world);
        if (!this.getRegistry().isDisabled() && !this.isCurrentStateFromRemote() && GameruleRegistry.getGameRuleBooleanValue("blTimedEvents")) {
            if (this.isActive() || this.canActivate()) {
                this.dataManager.set(TICKS, this.getTicks() - 1);
            }
            if (!world.field_72995_K && this.getTicks() <= 0) {
                int nextDuration = this.dataManager.get(NEXT_DURATION);
                if (this.isActive() || this.canActivate()) {
                    this.setActive(!this.isActive());
                }
                this.dataManager.set(TICKS, nextDuration).syncImmediately();
                this.dataManager.set(START_TICKS, nextDuration);
                if (!this.isActive()) {
                    this.dataManager.set(NEXT_DURATION, this.getOnTime(world.field_73012_v));
                } else {
                    this.dataManager.set(NEXT_DURATION, this.getOffTime(world.field_73012_v));
                }
            }
        }
    }

    protected boolean canActivate() {
        return true;
    }

    public void setTicks(int ticks) {
        int currTicks = this.getTicks();
        int diff = ticks - currTicks;
        this.dataManager.set(TICKS, currTicks + diff);
        this.dataManager.set(START_TICKS, Math.max(this.getStartTicks() + diff, 0));
    }

    public int getTicks() {
        return this.dataManager.get(TICKS);
    }

    public int getStartTicks() {
        return this.dataManager.get(START_TICKS);
    }

    public int getTicksElapsed() {
        return this.getStartTicks() - this.getTicks();
    }

    @Override
    public void setActive(boolean active) {
        if (!active || this.canActivate()) {
            super.setActive(active);
            if (!this.getWorld().field_72995_K) {
                if (!this.isActive()) {
                    int offTime = this.getOffTime(this.getWorld().field_73012_v);
                    this.dataManager.set(TICKS, offTime).syncImmediately();
                    this.dataManager.set(START_TICKS, offTime);
                    this.dataManager.set(NEXT_DURATION, this.getOnTime(this.getWorld().field_73012_v));
                } else {
                    int onTime = this.getOnTime(this.getWorld().field_73012_v);
                    this.dataManager.set(TICKS, onTime).syncImmediately();
                    this.dataManager.set(START_TICKS, onTime);
                    this.dataManager.set(NEXT_DURATION, this.getOffTime(this.getWorld().field_73012_v));
                }
            }
        }
    }

    @Override
    public void saveEventData() {
        super.saveEventData();
        this.getData().func_74768_a("ticks", this.getTicks());
        this.getData().func_74768_a("startTicks", this.getStartTicks());
        this.getData().func_74768_a("nextDuration", this.dataManager.get(NEXT_DURATION).intValue());
    }

    @Override
    public void loadEventData() {
        super.loadEventData();
        this.dataManager.set(TICKS, this.getData().func_74762_e("ticks")).syncImmediately();
        this.dataManager.set(START_TICKS, this.getData().func_74762_e("startTicks"));
        if (!this.getData().func_150297_b("nextDuration", 3)) {
            this.dataManager.set(NEXT_DURATION, this.isActive() ? this.getOffTime(new Random()) : this.getOnTime(new Random()));
        } else {
            this.dataManager.set(NEXT_DURATION, this.getData().func_74762_e("nextDuration"));
        }
    }

    @Override
    public void setDefaults() {
        Random rnd = new Random();
        this.dataManager.set(TICKS, this.getOffTime(rnd));
        this.dataManager.set(NEXT_DURATION, this.getOnTime(rnd));
    }

    public abstract int getOffTime(Random var1);

    public abstract int getOnTime(Random var1);

    @Override
    public int estimateTimeUntil(IPredictableEnvironmentEvent.State state) {
        return this.activeStateEstimator.estimateTimeUntil(state);
    }

    public ActiveStateEstimator getActiveStateEstimator() {
        return this.activeStateEstimator;
    }

    public static class ActiveStateEstimator {
        private final TimedEnvironmentEvent event;
        private final List<Supplier<ActiveStateEstimator>> dependencies = new ArrayList<Supplier<ActiveStateEstimator>>();
        private int minTimeForActivity = 600;
        private int activationOffsetTime = -2400;
        private int maxActivationOffsetTimeFromDependency = 1;

        public ActiveStateEstimator(TimedEnvironmentEvent event) {
            this.event = event;
        }

        public ActiveStateEstimator dependsOnEvent(TimedEnvironmentEvent event) {
            return this.dependsOn(event.getActiveStateEstimator());
        }

        public ActiveStateEstimator dependsOnEvent(Supplier<TimedEnvironmentEvent> event) {
            return this.dependsOn(event.get().getActiveStateEstimator());
        }

        public ActiveStateEstimator dependsOn(ActiveStateEstimator dependency) {
            return this.dependsOn(() -> dependency);
        }

        public ActiveStateEstimator dependsOn(Supplier<ActiveStateEstimator> dependency) {
            this.dependencies.add(dependency);
            return this;
        }

        public ActiveStateEstimator activationOffsetTime(int offset, int maxOffsetFromDependency) {
            this.activationOffsetTime = offset;
            this.maxActivationOffsetTimeFromDependency = maxOffsetFromDependency;
            return this;
        }

        public ActiveStateEstimator minTimeForActivity(int minTime) {
            this.minTimeForActivity = minTime;
            return this;
        }

        public int estimateTimeUntil(IPredictableEnvironmentEvent.State state) {
            if (state == IPredictableEnvironmentEvent.State.ACTIVE) {
                if (this.event.isActive()) {
                    return 0;
                }
                if (!this.dependencies.isEmpty()) {
                    int startDepTime = 0;
                    int endDepTime = Integer.MAX_VALUE;
                    for (Supplier<ActiveStateEstimator> dep : this.dependencies) {
                        ActiveStateEstimator estimator = dep.get();
                        int startEstimate = estimator.estimateTimeUntil(IPredictableEnvironmentEvent.State.ACTIVE);
                        startDepTime = Math.max(startDepTime, startEstimate);
                        int endEstimate = estimator.event.isActive() ? estimator.event.estimateTimeRemaining(IPredictableEnvironmentEvent.State.ACTIVE) : startEstimate + estimator.estimateNextStateDuration();
                        endDepTime = Math.min(endDepTime, endEstimate);
                    }
                    int depDuration = endDepTime - startDepTime;
                    int timeUntilActivation = this.event.getTicks();
                    if (timeUntilActivation < depDuration && depDuration - timeUntilActivation >= this.minTimeForActivity) {
                        return Math.max(1, Math.max(startDepTime - this.maxActivationOffsetTimeFromDependency, Math.min(endDepTime + this.maxActivationOffsetTimeFromDependency, startDepTime + timeUntilActivation + (this.activationOffsetTime < 0 && startDepTime > 0 || this.activationOffsetTime > 0 ? this.activationOffsetTime : 0))));
                    }
                    return -1;
                }
                if (this.event.canActivate()) {
                    return this.event.getTicks();
                }
            } else if (state == IPredictableEnvironmentEvent.State.INACTIVE) {
                if (!this.event.isActive()) {
                    return 0;
                }
                if (!this.dependencies.isEmpty()) {
                    int endDepTime = 0;
                    for (Supplier<ActiveStateEstimator> dep : this.dependencies) {
                        ActiveStateEstimator estimator = dep.get();
                        endDepTime = Math.min(endDepTime, estimator.estimateTimeUntil(IPredictableEnvironmentEvent.State.ACTIVE) + estimator.estimateNextStateDuration());
                    }
                    return Math.min(endDepTime, this.event.getTicks());
                }
                return this.event.getTicks();
            }
            return -1;
        }

        public int estimateNextStateDuration() {
            return this.event.dataManager.get(NEXT_DURATION);
        }
    }
}

