/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.event;

import java.util.Random;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.world.WorldProviderBetweenlands;
import thebetweenlands.common.world.event.BLEnvironmentEventRegistry;
import thebetweenlands.common.world.event.TimedEnvironmentEvent;

public class EventDenseFog
extends TimedEnvironmentEvent {
    public static final ResourceLocation ID = new ResourceLocation("thebetweenlands", "dense_fog");
    protected static final ResourceLocation[] VISION_TEXTURES = new ResourceLocation[]{new ResourceLocation("thebetweenlands:textures/events/dense_fog.png")};
    private float fade = 1.0f;
    private float lastFade = 1.0f;

    public EventDenseFog(BLEnvironmentEventRegistry registry) {
        super(registry);
    }

    @Override
    public ResourceLocation getEventName() {
        return ID;
    }

    @Override
    public int getOffTime(Random rnd) {
        return rnd.nextInt(10000) + 30000;
    }

    @Override
    public int getOnTime(Random rnd) {
        return rnd.nextInt(5000) + 5000;
    }

    @Override
    public void update(World world) {
        super.update(world);
        if (world.field_72995_K) {
            if (this.isActive()) {
                if (this.fade > 0.0f) {
                    this.lastFade = this.fade;
                    this.fade -= 0.002f;
                } else {
                    this.fade = 0.0f;
                    this.lastFade = 0.0f;
                }
            } else if (this.fade < 1.0f) {
                this.lastFade = this.fade;
                this.fade += 0.002f;
            } else {
                this.fade = 1.0f;
                this.lastFade = 1.0f;
            }
        }
    }

    public float getFade(float partialTicks) {
        return this.fade + (this.fade - this.lastFade) * partialTicks;
    }

    public static boolean isDenseFog(World world) {
        WorldProviderBetweenlands provider;
        if (world != null && (provider = WorldProviderBetweenlands.getProvider(world)) != null) {
            return provider.getEnvironmentEventRegistry().denseFog.isActive();
        }
        return false;
    }

    @Override
    public ResourceLocation[] getVisionTextures() {
        return VISION_TEXTURES;
    }

    @Override
    public SoundEvent getChimesSound() {
        return SoundRegistry.CHIMES_DENSE_FOG;
    }
}

