/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile.spawner;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;

public abstract class MobSpawnerLogicBetweenlands {
    private final List<WeightedSpawnerEntity> entitySpawnList = new ArrayList<WeightedSpawnerEntity>();
    public double entityRotation;
    public double lastEntityRotation;
    private WeightedSpawnerEntity randomEntity = new WeightedSpawnerEntity();
    private Entity cachedEntity;
    private int spawnDelay = 20;
    private int minSpawnDelay = 200;
    private int maxSpawnDelay = 800;
    private int spawnCount = 4;
    private int maxNearbyEntities = 6;
    private int activatingRangeFromPlayer = 16;
    private int spawnRange = 4;
    private double checkRange = 8.0;
    private boolean hasParticles = true;
    private boolean spawnInAir = true;

    @Nullable
    public ResourceLocation getEntityId() {
        String s = this.randomEntity.func_185277_b().func_74779_i("id");
        return StringUtils.func_151246_b((String)s) ? null : new ResourceLocation(s);
    }

    public MobSpawnerLogicBetweenlands setNextEntityName(String name) {
        this.randomEntity.func_185277_b().func_74778_a("id", name);
        if (this.getSpawnerWorld() != null && this.getSpawnerWorld().field_72995_K) {
            this.cachedEntity = null;
        }
        return this;
    }

    public MobSpawnerLogicBetweenlands setNextEntity(WeightedSpawnerEntity entity) {
        this.randomEntity = entity;
        if (this.getSpawnerWorld() != null && this.getSpawnerWorld().field_72995_K) {
            this.cachedEntity = null;
        }
        return this;
    }

    public MobSpawnerLogicBetweenlands setNextEntity(String name) {
        this.randomEntity = new WeightedSpawnerEntity();
        this.setNextEntityName(name);
        return this;
    }

    public MobSpawnerLogicBetweenlands setEntitySpawnList(List<WeightedSpawnerEntity> entitySpawnList) {
        this.entitySpawnList.clear();
        this.entitySpawnList.addAll(entitySpawnList);
        if (!this.entitySpawnList.isEmpty()) {
            this.setNextEntity((WeightedSpawnerEntity)WeightedRandom.func_76271_a((Random)this.getSpawnerWorld().field_73012_v, this.entitySpawnList));
        } else {
            this.setNextEntity(new WeightedSpawnerEntity());
        }
        return this;
    }

    public MobSpawnerLogicBetweenlands setSpawnInAir(boolean spawnInAir) {
        this.spawnInAir = spawnInAir;
        return this;
    }

    public boolean canSpawnInAir() {
        return this.spawnInAir;
    }

    public MobSpawnerLogicBetweenlands setParticles(boolean hasParticles) {
        this.hasParticles = hasParticles;
        return this;
    }

    public boolean hasParticles() {
        return this.hasParticles;
    }

    public int getMaxEntities() {
        return this.maxNearbyEntities;
    }

    public MobSpawnerLogicBetweenlands setMaxEntities(int maxEntities) {
        this.maxNearbyEntities = maxEntities;
        return this;
    }

    public MobSpawnerLogicBetweenlands setDelayRange(int minDelay, int maxDelay) {
        this.minSpawnDelay = minDelay;
        this.maxSpawnDelay = maxDelay;
        return this;
    }

    public MobSpawnerLogicBetweenlands setDelay(int delay) {
        this.spawnDelay = delay;
        return this;
    }

    public int getMinDelay() {
        return this.minSpawnDelay;
    }

    public int getMaxDelay() {
        return this.maxSpawnDelay;
    }

    public int getSpawnRange() {
        return this.spawnRange;
    }

    public MobSpawnerLogicBetweenlands setSpawnRange(int range) {
        this.spawnRange = range;
        return this;
    }

    public double getCheckRange() {
        return this.checkRange;
    }

    public MobSpawnerLogicBetweenlands setCheckRange(double range) {
        this.checkRange = range;
        return this;
    }

    public boolean isActivated() {
        return this.getSpawnerWorld().func_184137_a((double)this.getSpawnerX() + 0.5, (double)this.getSpawnerY() + 0.5, (double)this.getSpawnerZ() + 0.5, (double)this.activatingRangeFromPlayer, false) != null;
    }

    public void setMaxSpawnCount(int count) {
        this.spawnCount = count;
    }

    public int getMaxSpawnCount() {
        return this.spawnCount;
    }

    public void updateSpawner() {
        if (!this.isActivated()) {
            this.lastEntityRotation = this.entityRotation;
        } else if (this.getSpawnerWorld().field_72995_K) {
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            }
            if (this.hasParticles()) {
                this.spawnParticles();
            }
            this.lastEntityRotation = this.entityRotation;
            this.entityRotation = (this.entityRotation + (double)(1000.0f / ((float)this.spawnDelay + 200.0f))) % 360.0;
        } else {
            if (this.spawnDelay == -1) {
                this.resetTimer();
            }
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
                return;
            }
            int spawnCount = this.spawnCount > 1 ? this.getSpawnerWorld().field_73012_v.nextInt(this.spawnCount) + 1 : this.spawnCount;
            boolean entitySpawned = false;
            for (int i = 0; i < 128 && spawnCount > 0; ++i) {
                EntityLiving entityLiving;
                boolean canSpawn;
                int tags;
                double rx = 1.0 - this.getSpawnerWorld().field_73012_v.nextDouble() * 2.0;
                double ry = 1.0 - this.getSpawnerWorld().field_73012_v.nextDouble() * 2.0;
                double rz = 1.0 - this.getSpawnerWorld().field_73012_v.nextDouble() * 2.0;
                double len = Math.sqrt(rx * rx + ry * ry + rz * rz);
                rx = (double)this.getSpawnerX() + rx / len * (double)this.spawnRange;
                ry = (double)this.getSpawnerY() + ry / len * (double)this.spawnRange;
                rz = (double)this.getSpawnerZ() + rz / len * (double)this.spawnRange;
                NBTTagCompound entityNbt = this.randomEntity.func_185277_b();
                NBTTagList posNbt = entityNbt.func_150295_c("Pos", 6);
                World world = this.getSpawnerWorld();
                Entity entity = AnvilChunkLoader.func_186054_a((NBTTagCompound)entityNbt, (World)world, (double)(rx = (tags = posNbt.func_74745_c()) >= 1 ? posNbt.func_150309_d(0) : rx), (double)(ry = tags >= 2 ? posNbt.func_150309_d(1) : ry), (double)(rz = tags >= 3 ? posNbt.func_150309_d(2) : rz), (boolean)false);
                if (entity == null) {
                    return;
                }
                List entitiesInReach = this.getSpawnerWorld().func_72872_a(entity.getClass(), new AxisAlignedBB((double)this.getSpawnerX(), (double)this.getSpawnerY(), (double)this.getSpawnerZ(), (double)(this.getSpawnerX() + 1), (double)(this.getSpawnerY() + 1), (double)(this.getSpawnerZ() + 1)).func_72314_b(this.checkRange, this.checkRange, this.checkRange));
                int nearbyEntities = 0;
                for (Entity e : entitiesInReach) {
                    if (!(e.func_70011_f((double)this.getSpawnerX() + 0.5, (double)this.getSpawnerY() + 0.5, (double)this.getSpawnerZ() + 0.5) <= this.checkRange)) continue;
                    ++nearbyEntities;
                }
                if (nearbyEntities >= this.maxNearbyEntities) {
                    this.resetTimer();
                    return;
                }
                entity.func_70012_b(rx, ry, rz, this.getSpawnerWorld().field_73012_v.nextFloat() * 360.0f, 0.0f);
                boolean bl = canSpawn = this.canSpawnInAir() || entity.func_174813_aQ() == null;
                if (!canSpawn) {
                    AxisAlignedBB boundingBox;
                    BlockPos down = new BlockPos(rx, ry, rz).func_177977_b();
                    IBlockState blockState = this.getSpawnerWorld().func_180495_p(down);
                    if (blockState.func_177230_c() != Blocks.field_150350_a && (boundingBox = blockState.func_185890_d((IBlockAccess)this.getSpawnerWorld(), down)) != null) {
                        RayTraceResult intercept;
                        boundingBox = boundingBox.func_186670_a(down);
                        AxisAlignedBB entityBoundingBox = entity.func_174813_aQ();
                        if (boundingBox.func_186668_a(entityBoundingBox.field_72340_a, boundingBox.field_72338_b, entityBoundingBox.field_72339_c, entityBoundingBox.field_72336_d, boundingBox.field_72337_e, entityBoundingBox.field_72334_f) && (intercept = boundingBox.func_72327_a(entity.func_174791_d(), entity.func_174791_d().func_72441_c(0.0, -2.0, 0.0))) != null) {
                            canSpawn = true;
                            entity.func_70012_b(entity.field_70165_t, intercept.field_72307_f.field_72448_b + 0.1, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
                        }
                    }
                }
                if (!canSpawn) continue;
                EntityLiving entityLiving2 = entityLiving = entity instanceof EntityLiving ? (EntityLiving)entity : null;
                if (entityLiving != null && !ForgeEventFactory.canEntitySpawnSpawner((EntityLiving)entityLiving, (World)this.getSpawnerWorld(), (float)((float)entity.field_70165_t), (float)((float)entity.field_70163_u), (float)((float)entity.field_70161_v))) continue;
                if (entityLiving != null && !ForgeEventFactory.doSpecialSpawn((EntityLiving)entityLiving, (World)this.getSpawnerWorld(), (float)((float)entity.field_70165_t), (float)((float)entity.field_70163_u), (float)((float)entity.field_70161_v))) {
                    ((EntityLiving)entity).func_180482_a(this.getSpawnerWorld().func_175649_E(new BlockPos(entity)), (IEntityLivingData)null);
                }
                AnvilChunkLoader.func_186052_a((Entity)entity, (World)this.getSpawnerWorld());
                this.getSpawnerWorld().func_175718_b(2004, entity.func_180425_c(), 0);
                if (entityLiving != null) {
                    entityLiving.func_70656_aK();
                }
                --spawnCount;
                entitySpawned = true;
            }
            if (entitySpawned) {
                this.resetTimer();
            }
        }
    }

    protected void spawnParticles() {
        double rx = this.getSpawnerWorld().field_73012_v.nextFloat();
        double ry = this.getSpawnerWorld().field_73012_v.nextFloat();
        double rz = this.getSpawnerWorld().field_73012_v.nextFloat();
        double len = Math.sqrt(rx * rx + ry * ry + rz * rz);
        BLParticles.SPAWNER.spawn(this.getSpawnerWorld(), (double)this.getSpawnerX() + rx, (double)this.getSpawnerY() + ry, (double)this.getSpawnerZ() + rz, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion((rx - 0.5) / len * 0.05, (ry - 0.5) / len * 0.05, (rz - 0.5) / len * 0.05));
    }

    public Entity spawnEntity(Entity entity) {
        ((EntityLiving)entity).func_180482_a(this.getSpawnerWorld().func_175649_E(new BlockPos(entity)), (IEntityLivingData)null);
        this.getSpawnerWorld().func_72838_d(entity);
        return entity;
    }

    public void resetTimer() {
        if (this.maxSpawnDelay <= this.minSpawnDelay) {
            this.spawnDelay = this.minSpawnDelay;
        } else {
            int i = this.maxSpawnDelay - this.minSpawnDelay;
            this.spawnDelay = this.minSpawnDelay + this.getSpawnerWorld().field_73012_v.nextInt(i);
        }
        if (!this.entitySpawnList.isEmpty()) {
            this.setNextEntity((WeightedSpawnerEntity)WeightedRandom.func_76271_a((Random)this.getSpawnerWorld().field_73012_v, this.entitySpawnList));
        }
        this.broadcastEvent(1);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagCompound entityNbt = nbt.func_74775_l("SpawnData");
        if (!entityNbt.func_150297_b("id", 8)) {
            entityNbt.func_74778_a("id", "Pig");
        }
        this.setNextEntity(new WeightedSpawnerEntity(1, entityNbt));
        this.spawnDelay = nbt.func_74765_d("Delay");
        this.entitySpawnList.clear();
        if (nbt.func_150297_b("SpawnPotentials", 9)) {
            NBTTagList nbttaglist = nbt.func_150295_c("SpawnPotentials", 10);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                this.entitySpawnList.add(new WeightedSpawnerEntity(nbttaglist.func_150305_b(i)));
            }
        }
        if (nbt.func_150297_b("MinSpawnDelay", 99)) {
            this.minSpawnDelay = nbt.func_74765_d("MinSpawnDelay");
            this.maxSpawnDelay = nbt.func_74765_d("MaxSpawnDelay");
            this.spawnCount = nbt.func_74765_d("SpawnCount");
        }
        if (nbt.func_150297_b("MaxNearbyEntities", 99)) {
            this.maxNearbyEntities = nbt.func_74765_d("MaxNearbyEntities");
            this.activatingRangeFromPlayer = nbt.func_74765_d("RequiredPlayerRange");
        }
        if (nbt.func_150297_b("SpawnRange", 99)) {
            this.spawnRange = nbt.func_74765_d("SpawnRange");
        }
        if (nbt.func_150297_b("CheckRange", 99)) {
            this.checkRange = nbt.func_74769_h("CheckRange");
        }
        if (nbt.func_74764_b("HasParticles")) {
            this.hasParticles = nbt.func_74767_n("HasParticles");
        }
        if (nbt.func_74764_b("SpawnInAir")) {
            this.spawnInAir = nbt.func_74767_n("SpawnInAir");
        }
        if (this.getSpawnerWorld() != null && this.getSpawnerWorld().field_72995_K) {
            this.cachedEntity = null;
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("SpawnData", (NBTBase)this.randomEntity.func_185277_b().func_74737_b());
        NBTTagList entityNbtList = new NBTTagList();
        if (this.entitySpawnList.isEmpty()) {
            entityNbtList.func_74742_a((NBTBase)this.randomEntity.func_185278_a());
        } else {
            for (WeightedSpawnerEntity weightedspawnerentity : this.entitySpawnList) {
                entityNbtList.func_74742_a((NBTBase)weightedspawnerentity.func_185278_a());
            }
        }
        nbt.func_74782_a("SpawnPotentials", (NBTBase)entityNbtList);
        nbt.func_74777_a("Delay", (short)this.spawnDelay);
        nbt.func_74777_a("MinSpawnDelay", (short)this.minSpawnDelay);
        nbt.func_74777_a("MaxSpawnDelay", (short)this.maxSpawnDelay);
        nbt.func_74777_a("SpawnCount", (short)this.spawnCount);
        nbt.func_74777_a("MaxNearbyEntities", (short)this.maxNearbyEntities);
        nbt.func_74777_a("RequiredPlayerRange", (short)this.activatingRangeFromPlayer);
        nbt.func_74777_a("SpawnRange", (short)this.spawnRange);
        nbt.func_74780_a("CheckRange", this.checkRange);
        nbt.func_74757_a("HasParticles", this.hasParticles);
        nbt.func_74757_a("SpawnInAir", this.spawnInAir);
    }

    public boolean setDelayToMin(int event) {
        if (event == 1 && this.getSpawnerWorld().field_72995_K) {
            this.spawnDelay = this.minSpawnDelay;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public Entity getCachedEntity() {
        if (this.cachedEntity == null) {
            this.cachedEntity = AnvilChunkLoader.func_186051_a((NBTTagCompound)this.randomEntity.func_185277_b(), (World)this.getSpawnerWorld(), (boolean)false);
            if (this.randomEntity.func_185277_b().func_186856_d() == 1 && this.randomEntity.func_185277_b().func_150297_b("id", 8) && this.cachedEntity instanceof EntityLiving) {
                ((EntityLiving)this.cachedEntity).func_180482_a(this.getSpawnerWorld().func_175649_E(new BlockPos(this.cachedEntity)), (IEntityLivingData)null);
            }
        }
        return this.cachedEntity;
    }

    public abstract void broadcastEvent(int var1);

    public abstract World getSpawnerWorld();

    public abstract int getSpawnerX();

    public abstract int getSpawnerY();

    public abstract int getSpawnerZ();
}

