/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile;

import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.environment.IEnvironmentEvent;
import thebetweenlands.api.environment.IPredictableEnvironmentEvent;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.BatchedParticleRenderer;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.render.particle.entity.ParticleVisionOrb;
import thebetweenlands.common.registries.AdvancementCriterionRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.world.event.BLEnvironmentEventRegistry;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;

public class TileEntityWindChime
extends TileEntity
implements ITickable {
    public int renderTicks;
    public int ticksUntilChimes;
    public int prevChimeTicks;
    public int chimeTicks;
    @SideOnly(value=Side.CLIENT)
    private BatchedParticleRenderer.ParticleBatch particleBatch;
    private int fadeOutTimer = 0;
    private IPredictableEnvironmentEvent predictedEvent;
    private int predictedTimeUntilActivation;
    private ResourceLocation predictedEventVision;
    private ResourceLocation attunedEvent;

    public int getMaxPredictionTime() {
        return this.attunedEvent != null ? 12000 : 6000;
    }

    @Nullable
    public ResourceLocation getAttunedEvent() {
        return this.attunedEvent;
    }

    public void setAttunedEvent(@Nullable ResourceLocation event) {
        this.attunedEvent = event;
        this.func_70296_d();
        if (this.field_145850_b != null) {
            IBlockState stat = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, stat, stat, 3);
        }
    }

    @Nullable
    public ResourceLocation cycleAttunedEvent() {
        BLEnvironmentEventRegistry registry = BetweenlandsWorldStorage.forWorld(this.field_145850_b).getEnvironmentEventRegistry();
        ArrayList<IPredictableEnvironmentEvent> choices = new ArrayList<IPredictableEnvironmentEvent>();
        int currentAttunedIndex = -1;
        int i = 0;
        for (Map.Entry<ResourceLocation, IEnvironmentEvent> entry : registry.getEvents().entrySet()) {
            if (!(entry.getValue() instanceof IPredictableEnvironmentEvent)) continue;
            choices.add((IPredictableEnvironmentEvent)entry.getValue());
            if (this.attunedEvent != null && this.attunedEvent.equals((Object)entry.getKey())) {
                currentAttunedIndex = i;
            }
            ++i;
        }
        ResourceLocation newAttunement = currentAttunedIndex >= 0 ? (currentAttunedIndex == choices.size() - 1 ? null : ((IPredictableEnvironmentEvent)choices.get(currentAttunedIndex + 1)).getEventName()) : (choices.size() > 0 ? ((IPredictableEnvironmentEvent)choices.get(0)).getEventName() : null);
        this.setAttunedEvent(newAttunement);
        return newAttunement;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public BatchedParticleRenderer.ParticleBatch getParticleBatch() {
        return this.particleBatch;
    }

    public IPredictableEnvironmentEvent getPredictedEvent() {
        return this.predictedEvent;
    }

    public int getPredictedTimeUntilActivation() {
        return this.predictedTimeUntilActivation;
    }

    @Nullable
    public ResourceLocation getPredictedEventVision() {
        return this.predictedEventVision;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            ++this.renderTicks;
            if (this.ticksUntilChimes > 0) {
                --this.ticksUntilChimes;
                if (this.ticksUntilChimes <= 0) {
                    this.ticksUntilChimes = 0;
                } else if (this.ticksUntilChimes <= 4) {
                    this.chimeTicks += 25;
                }
            }
            this.prevChimeTicks = this.chimeTicks;
            this.chimeTicks = Math.max(this.chimeTicks - 1, 0);
        }
        BLEnvironmentEventRegistry registry = BetweenlandsWorldStorage.forWorld(this.field_145850_b).getEnvironmentEventRegistry();
        int maxPredictionTime = this.getMaxPredictionTime();
        int nextPrediction = Integer.MAX_VALUE;
        IPredictableEnvironmentEvent nextEvent = null;
        ResourceLocation[] nextEventVisions = null;
        for (IEnvironmentEvent event : registry.getEvents().values()) {
            int prediction;
            IPredictableEnvironmentEvent predictable;
            ResourceLocation[] visions;
            if (!(event instanceof IPredictableEnvironmentEvent) || this.attunedEvent != null && !this.attunedEvent.equals((Object)event.getEventName()) || (visions = (predictable = (IPredictableEnvironmentEvent)event).getVisionTextures()) == null || (prediction = predictable.estimateTimeUntil(IPredictableEnvironmentEvent.State.ACTIVE)) <= 0 || prediction >= nextPrediction || prediction >= maxPredictionTime) continue;
            nextPrediction = prediction;
            nextEvent = predictable;
            nextEventVisions = visions;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.predictedEvent != null && this.predictedEvent != nextEvent) {
                this.predictedEvent = nextEvent;
                this.predictedTimeUntilActivation = -1;
            } else if (this.predictedEvent == null) {
                this.predictedEvent = nextEvent;
            }
            if (this.predictedEvent == nextEvent && nextEvent != null) {
                if (this.predictedTimeUntilActivation == -1 || this.predictedTimeUntilActivation >= maxPredictionTime && nextPrediction < maxPredictionTime) {
                    this.triggerAdvancement();
                } else if ((float)this.predictedTimeUntilActivation >= (float)maxPredictionTime * 0.4f && (float)nextPrediction < (float)maxPredictionTime * 0.4f) {
                    this.triggerAdvancement();
                } else if ((float)this.predictedTimeUntilActivation >= (float)maxPredictionTime * 0.2f && (float)nextPrediction < (float)maxPredictionTime * 0.2f) {
                    this.triggerAdvancement();
                }
                this.predictedTimeUntilActivation = nextPrediction;
            } else {
                this.predictedTimeUntilActivation = -1;
            }
        } else {
            this.updateParticles(maxPredictionTime, nextPrediction, nextEvent, nextEventVisions);
        }
    }

    private void triggerAdvancement() {
        AxisAlignedBB aabb = new AxisAlignedBB(this.func_174877_v()).func_186662_g(16.0);
        for (EntityPlayerMP player : this.field_145850_b.func_175647_a(EntityPlayerMP.class, aabb, EntitySelectors.field_180132_d)) {
            if (!(player.func_174818_b(this.func_174877_v()) <= 256.0)) continue;
            AdvancementCriterionRegistry.WIND_CHIME_PREDICTION.trigger(player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateParticles(int maxPredictionTime, int nextPrediction, IPredictableEnvironmentEvent nextEvent, ResourceLocation[] nextEventVisions) {
        if (this.predictedEvent != null && this.predictedEvent != nextEvent && this.fadeOutTimer < 20) {
            ++this.fadeOutTimer;
            if (this.fadeOutTimer >= 20) {
                this.fadeOutTimer = 0;
                this.predictedEvent = nextEvent;
                this.predictedTimeUntilActivation = -1;
                ResourceLocation resourceLocation = this.predictedEventVision = nextEventVisions != null && nextEventVisions.length >= 1 ? nextEventVisions[this.field_145850_b.field_73012_v.nextInt(nextEventVisions.length)] : null;
                this.particleBatch = this.predictedEventVision != null ? ParticleVisionOrb.createParticleBatch(() -> this.predictedEventVision) : null;
            }
        } else if (this.predictedEvent == null) {
            this.predictedEvent = nextEvent;
            if (nextEvent != null) {
                ResourceLocation resourceLocation = this.predictedEventVision = nextEventVisions != null && nextEventVisions.length >= 1 ? nextEventVisions[this.field_145850_b.field_73012_v.nextInt(nextEventVisions.length)] : null;
                this.particleBatch = this.predictedEventVision != null ? ParticleVisionOrb.createParticleBatch(() -> this.predictedEventVision) : null;
            } else {
                this.predictedEventVision = null;
                this.particleBatch = null;
            }
        }
        if (this.predictedEvent == nextEvent && nextEvent != null) {
            Entity view;
            if (this.predictedTimeUntilActivation == -1 || this.predictedTimeUntilActivation >= maxPredictionTime && nextPrediction < maxPredictionTime) {
                this.playChimes(nextEvent);
            } else if ((float)this.predictedTimeUntilActivation >= (float)maxPredictionTime * 0.4f && (float)nextPrediction < (float)maxPredictionTime * 0.4f) {
                this.playChimes(nextEvent);
            } else if ((float)this.predictedTimeUntilActivation >= (float)maxPredictionTime * 0.2f && (float)nextPrediction < (float)maxPredictionTime * 0.2f) {
                this.playChimes(nextEvent);
            }
            this.predictedTimeUntilActivation = nextPrediction;
            if (this.particleBatch != null && (view = Minecraft.func_71410_x().func_175606_aa()) != null && view.func_174818_b(this.func_174877_v()) < 256.0) {
                double cx = (float)this.field_174879_c.func_177958_n() + 0.5f;
                double cy = (float)this.field_174879_c.func_177956_o() + 0.2f;
                double cz = (float)this.field_174879_c.func_177952_p() + 0.5f;
                double rx = this.field_145850_b.field_73012_v.nextFloat() - 0.5f;
                double ry = this.field_145850_b.field_73012_v.nextFloat() - 0.5f;
                double rz = this.field_145850_b.field_73012_v.nextFloat() - 0.5f;
                double len = MathHelper.func_76133_a((double)(rx * rx + ry * ry + rz * rz));
                rx /= len;
                ry /= len;
                rz /= len;
                int size = this.field_145850_b.field_73012_v.nextInt(3);
                ParticleVisionOrb particle = (ParticleVisionOrb)BLParticles.WIND_CHIME_VISION.create(this.field_145850_b, cx + (rx *= (double)(0.6f + (float)size * 0.1f)), cy + (ry *= (double)(0.6f + (float)size * 0.1f)), cz + (rz *= (double)(0.6f + (float)size * 0.1f)), (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(cx, cy, cz, 150)).withMotion(0.0, 0.0, 0.0)).withColor(1.0f, 1.0f, 1.0f, 0.85f)).withScale(0.85f));
                particle.setAlphaFunction(() -> Float.valueOf(1.0f - (float)this.fadeOutTimer / 20.0f));
                BatchedParticleRenderer.INSTANCE.addParticle(this.particleBatch, particle);
            }
        } else {
            this.predictedTimeUntilActivation = -1;
        }
        if (this.particleBatch != null) {
            BatchedParticleRenderer.INSTANCE.updateBatch(this.particleBatch);
        }
    }

    private void playChimes(IPredictableEnvironmentEvent event) {
        this.ticksUntilChimes = 15;
        SoundEvent chimes = event.getChimesSound();
        if (chimes != null) {
            this.field_145850_b.func_184134_a((double)((float)this.func_174877_v().func_177958_n() + 0.5f), (double)((float)this.func_174877_v().func_177956_o() + 0.5f), (double)((float)this.func_174877_v().func_177952_p() + 0.5f), chimes, SoundCategory.BLOCKS, 2.0f, 1.0f, false);
        }
        this.field_145850_b.func_184134_a((double)((float)this.func_174877_v().func_177958_n() + 0.5f), (double)((float)this.func_174877_v().func_177956_o() + 0.5f), (double)((float)this.func_174877_v().func_177952_p() + 0.5f), (SoundEvent)SoundRegistry.CHIMES_WIND, SoundCategory.BLOCKS, 2.0f, 1.0f, false);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_150297_b("attunedEvent", 8)) {
            this.setAttunedEvent(new ResourceLocation(nbt.func_74779_i("attunedEvent")));
        } else {
            this.setAttunedEvent(null);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        if (this.attunedEvent != null) {
            nbt.func_74778_a("attunedEvent", this.attunedEvent.toString());
        }
        return nbt;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.attunedEvent != null) {
            nbt.func_74778_a("attunedEvent", this.attunedEvent.toString());
        }
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        if (nbt.func_150297_b("attunedEvent", 8)) {
            this.setAttunedEvent(new ResourceLocation(nbt.func_74779_i("attunedEvent")));
        } else {
            this.setAttunedEvent(null);
        }
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        if (this.attunedEvent != null) {
            nbt.func_74778_a("attunedEvent", this.attunedEvent.toString());
        }
        return nbt;
    }
}

