/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.registries;

import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.audio.ambience.AmbienceLayer;
import thebetweenlands.client.audio.ambience.AmbienceManager;
import thebetweenlands.client.audio.ambience.list.CaveAmbienceType;
import thebetweenlands.client.audio.ambience.list.DenseFogSurfaceAmbienceType;
import thebetweenlands.client.audio.ambience.list.EventAmbienceType;
import thebetweenlands.client.audio.ambience.list.FloatingIslandAmbienceType;
import thebetweenlands.client.audio.ambience.list.FrostyAmbienceType;
import thebetweenlands.client.audio.ambience.list.LocationAmbienceType;
import thebetweenlands.client.audio.ambience.list.MountRainAmbienceType;
import thebetweenlands.client.audio.ambience.list.PresentAmbienceType;
import thebetweenlands.client.audio.ambience.list.SnowFallAmbienceType;
import thebetweenlands.client.audio.ambience.list.SpiritTreeAmbienceType;
import thebetweenlands.client.audio.ambience.list.SurfaceAmbienceType;
import thebetweenlands.client.audio.ambience.list.WaterAmbienceType;
import thebetweenlands.client.audio.ambience.list.WindAmbienceType;
import thebetweenlands.common.entity.EntityDecayPitTarget;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.world.event.EventBloodSky;
import thebetweenlands.common.world.event.EventSpoopy;
import thebetweenlands.common.world.storage.location.LocationAmbience;
import thebetweenlands.common.world.storage.location.LocationSludgeWormDungeon;
import thebetweenlands.common.world.storage.location.LocationStorage;

@SideOnly(value=Side.CLIENT)
public class AmbienceRegistry {
    public static final AmbienceLayer BASE_LAYER = new AmbienceLayer(new ResourceLocation("base_layer"));
    public static final AmbienceLayer DETAIL_LAYER = new AmbienceLayer(new ResourceLocation("detail_layer"));

    public static void preInit() {
        AmbienceManager.INSTANCE.registerAmbience(new SurfaceAmbienceType());
        AmbienceManager.INSTANCE.registerAmbience(new DenseFogSurfaceAmbienceType());
        AmbienceManager.INSTANCE.registerAmbience(new CaveAmbienceType());
        AmbienceManager.INSTANCE.registerAmbience(new WaterAmbienceType(true));
        AmbienceManager.INSTANCE.registerAmbience(new WaterAmbienceType(false));
        AmbienceManager.INSTANCE.registerAmbience(new WindAmbienceType());
        AmbienceManager.INSTANCE.registerAmbience(new FloatingIslandAmbienceType());
        AmbienceManager.INSTANCE.registerAmbience(new MountRainAmbienceType());
        AmbienceManager.INSTANCE.registerAmbience(new LocationAmbienceType(LocationAmbience.EnumLocationAmbience.WIGHT_TOWER, SoundRegistry.AMBIENT_WIGHT_FORTRESS){

            @Override
            public boolean isActive() {
                return super.isActive() && !this.getAmbience().getLocation().getName().equals("wight_tower_boss");
            }
        });
        AmbienceManager.INSTANCE.registerAmbience(new LocationAmbienceType(LocationAmbience.EnumLocationAmbience.WIGHT_TOWER, SoundRegistry.AMBIENT_WIGHT_FORTRESS){

            @Override
            public boolean isActive() {
                return super.isActive() && this.getAmbience().getLocation().getName().equals("wight_tower_boss");
            }

            @Override
            public float getVolume() {
                return 0.0f;
            }
        });
        AmbienceManager.INSTANCE.registerAmbience(new LocationAmbienceType(LocationAmbience.EnumLocationAmbience.SLUDGE_WORM_DUNGEON, SoundRegistry.AMBIENT_SLUDGE_WORM_DUNGEON){

            @Override
            public boolean isActive() {
                LocationStorage location;
                LocationAmbience ambience;
                if (super.isActive() && (ambience = this.getAmbience()) != null && (location = ambience.getLocation()) instanceof LocationSludgeWormDungeon) {
                    return this.getPlayer().func_174824_e((float)1.0f).field_72448_b < (double)((LocationSludgeWormDungeon)location).getStructurePos().func_177956_o();
                }
                return false;
            }

            private float getProgressiveVolume() {
                LocationStorage location;
                LocationAmbience ambience = this.getAmbience();
                if (ambience != null && (location = ambience.getLocation()) instanceof LocationSludgeWormDungeon) {
                    double dist = (double)((LocationSludgeWormDungeon)location).getStructurePos().func_177956_o() - this.getPlayer().func_174824_e((float)1.0f).field_72448_b;
                    return Math.min((float)dist / 12.0f, 1.0f);
                }
                return 0.0f;
            }

            @Override
            public float getLowerPriorityVolume() {
                return Math.max(0.0f, 1.0f - this.getProgressiveVolume());
            }

            @Override
            public float getVolume() {
                return this.getProgressiveVolume();
            }
        });
        AmbienceManager.INSTANCE.registerAmbience(new LocationAmbienceType(LocationAmbience.EnumLocationAmbience.SLUDGE_WORM_DUNGEON, SoundRegistry.PIT_OF_DECAY_LOOP){

            @Override
            public boolean isActive() {
                LocationStorage location;
                if (super.isActive() && this.getAmbience() != null && (location = this.getAmbience().getLocation()).getName().equals("sludge_worm_dungeon_pit")) {
                    List targets = this.getPlayer().field_70170_p.func_72872_a(EntityDecayPitTarget.class, location.getEnclosingBounds());
                    for (EntityDecayPitTarget target : targets) {
                        if (!location.isInside(target)) continue;
                        return true;
                    }
                }
                return false;
            }

            @Override
            public SoundCategory getCategory() {
                return SoundCategory.MUSIC;
            }
        });
        AmbienceManager.INSTANCE.registerAmbience(new SpiritTreeAmbienceType());
        AmbienceManager.INSTANCE.registerAmbience(new EventAmbienceType(EventSpoopy.class, SoundRegistry.AMBIENT_SPOOPY, 0));
        AmbienceManager.INSTANCE.registerAmbience(new EventAmbienceType(EventBloodSky.class, SoundRegistry.AMBIENT_BLOOD_SKY, 1).setDelay(140));
        AmbienceManager.INSTANCE.registerAmbience(new FrostyAmbienceType());
        AmbienceManager.INSTANCE.registerAmbience(new SnowFallAmbienceType());
        AmbienceManager.INSTANCE.registerAmbience(new PresentAmbienceType());
    }
}

