/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.shields;

import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.capability.item.ILivingWeedwoodShieldCapability;
import thebetweenlands.common.entity.projectiles.EntitySapSpit;
import thebetweenlands.common.item.shields.ItemWeedwoodShield;
import thebetweenlands.common.network.clientbound.MessageLivingWeedwoodShieldSpit;
import thebetweenlands.common.registries.CapabilityRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class ItemLivingWeedwoodShield
extends ItemWeedwoodShield {
    @Override
    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (entityIn instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)entityIn;
            if (!worldIn.field_72995_K) {
                boolean offhand;
                boolean mainhand = living.func_184586_b(EnumHand.MAIN_HAND) == stack;
                boolean bl = offhand = living.func_184586_b(EnumHand.OFF_HAND) == stack;
                if (living.func_184585_cz() && (mainhand || offhand)) {
                    int spitCooldown = this.getSpitCooldown(stack);
                    if (spitCooldown <= 0) {
                        this.trySpit(stack, worldIn, living, mainhand ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND);
                        this.setSpitCooldown(stack, 30 + worldIn.field_73012_v.nextInt(30));
                    } else {
                        this.setSpitCooldown(stack, spitCooldown - 1);
                    }
                    if (worldIn.field_73012_v.nextInt(60) == 0) {
                        worldIn.func_184148_a(null, entityIn.field_70165_t, entityIn.field_70163_u + (double)(entityIn.field_70131_O / 2.0f), entityIn.field_70161_v, (SoundEvent)SoundRegistry.SPIRIT_TREE_FACE_SMALL_LIVING, SoundCategory.PLAYERS, 0.35f, 1.4f);
                    }
                }
            } else {
                int spitTicks = this.getSpitTicks(stack);
                if (spitTicks > 0) {
                    this.setSpitTicks(stack, spitTicks - 1);
                }
            }
        }
    }

    @Override
    protected void onShieldBreak(ItemStack stack, EntityLivingBase attacked, EnumHand hand, DamageSource source) {
        super.onShieldBreak(stack, attacked, hand, source);
        if (this.getBurningTicks(stack) == 0) {
            attacked.func_184611_a(hand, new ItemStack(ItemRegistry.SPIRIT_TREE_FACE_SMALL_MASK));
        }
    }

    public void setSpitTicks(ItemStack stack, int ticks) {
        ILivingWeedwoodShieldCapability cap = (ILivingWeedwoodShieldCapability)stack.getCapability(CapabilityRegistry.CAPABILITY_LIVING_WEEDWOOD_SHIELD, null);
        if (cap != null) {
            cap.setSpitTicks(ticks);
        }
    }

    public int getSpitTicks(ItemStack stack) {
        ILivingWeedwoodShieldCapability cap = (ILivingWeedwoodShieldCapability)stack.getCapability(CapabilityRegistry.CAPABILITY_LIVING_WEEDWOOD_SHIELD, null);
        if (cap != null) {
            return cap.getSpitTicks();
        }
        return 0;
    }

    public void setSpitCooldown(ItemStack stack, int ticks) {
        ILivingWeedwoodShieldCapability cap = (ILivingWeedwoodShieldCapability)stack.getCapability(CapabilityRegistry.CAPABILITY_LIVING_WEEDWOOD_SHIELD, null);
        if (cap != null) {
            cap.setSpitCooldown(ticks);
        }
    }

    public int getSpitCooldown(ItemStack stack) {
        ILivingWeedwoodShieldCapability cap = (ILivingWeedwoodShieldCapability)stack.getCapability(CapabilityRegistry.CAPABILITY_LIVING_WEEDWOOD_SHIELD, null);
        if (cap != null) {
            return cap.getSpitCooldown();
        }
        return 0;
    }

    protected boolean trySpit(ItemStack stack, World world, EntityLivingBase owner, EnumHand hand) {
        EntityLivingBase target = null;
        List entities = world.func_175647_a(EntityLivingBase.class, owner.func_174813_aQ().func_72314_b(8.0, 3.0, 8.0), arg_0 -> ((Predicate)IMob.field_82192_a).apply(arg_0));
        Vec3d lookVec = owner.func_70040_Z().func_72432_b();
        for (EntityLivingBase e : entities) {
            if (!(Math.toDegrees(Math.acos(lookVec.func_72430_b(e.func_174824_e(1.0f).func_178788_d(owner.func_174824_e(1.0f)).func_72432_b()))) <= 70.0) || target != null && !(target.func_70032_d((Entity)owner) > e.func_70032_d((Entity)owner))) continue;
            target = e;
        }
        if (target != null) {
            float yaw = -(180.0f - owner.field_70761_aq);
            Vec3d bodyForward = new Vec3d((double)MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI)), 0.0, (double)MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI)));
            Vec3d up = new Vec3d(0.0, 1.0, 0.0);
            Vec3d right = bodyForward.func_72431_c(up);
            Vec3d offset = new Vec3d(bodyForward.field_72450_a, (double)owner.func_70047_e(), bodyForward.field_72449_c).func_178787_e(right.func_186678_a(hand == EnumHand.MAIN_HAND ? 0.35 : -0.35).func_72441_c(0.0, lookVec.field_72448_b * 0.5 - 0.4, 0.0).func_178787_e(bodyForward.func_186678_a(-0.1)));
            EntitySapSpit spit = new EntitySapSpit(world, owner, 4.5f);
            spit.func_70107_b(owner.field_70165_t + owner.field_70159_w + offset.field_72450_a, owner.field_70163_u + offset.field_72448_b, owner.field_70161_v + owner.field_70179_y + offset.field_72449_c);
            double dx = target.field_70165_t - spit.field_70165_t;
            double dy = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - spit.field_70163_u;
            double dz = target.field_70161_v - spit.field_70161_v;
            double dist = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
            spit.func_70186_c(dx, dy + dist * (double)0.2f, dz, 1.0f, 1.0f);
            world.func_72838_d((Entity)spit);
            world.func_184148_a(null, spit.field_70165_t, spit.field_70163_u, spit.field_70161_v, (SoundEvent)SoundRegistry.SPIRIT_TREE_FACE_SMALL_SPIT, SoundCategory.PLAYERS, 1.0f, 1.0f);
            TheBetweenlands.networkWrapper.sendToAllAround((IMessage)new MessageLivingWeedwoodShieldSpit(owner, hand == EnumHand.MAIN_HAND, 15), new NetworkRegistry.TargetPoint(owner.field_71093_bK, owner.field_70165_t, owner.field_70163_u, owner.field_70161_v, 64.0));
            return true;
        }
        return false;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }
}

