/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public interface IGenericItem {
    public static final TypeContainer TYPE_CONTAINER = new TypeContainer();

    public String getTranslationKey();

    public String getModelName();

    public int getID();

    public Item getItem();

    default public ItemStack create(int size) {
        return new ItemStack(this.getItem(), size, this.getID());
    }

    default public boolean isItemOf(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() == this.getItem() && stack.func_77952_i() == this.getID();
    }

    default public boolean isItemEqual(IGenericItem item) {
        return item != null && item.getItem() == this.getItem() && item.getID() == this.getID();
    }

    public static List<IGenericItem> getGenericItems(Class<? extends Enum<?>> type) {
        ArrayList<IGenericItem> genericItems = (ArrayList<IGenericItem>)TYPE_CONTAINER.typeToItems.get(type);
        if (genericItems == null) {
            if (!IGenericItem.class.isAssignableFrom(type)) {
                throw new RuntimeException("Type " + type + " does not implement IGenericItem");
            }
            genericItems = new ArrayList<IGenericItem>();
            TYPE_CONTAINER.typeToItems.put(type, genericItems);
            for (Enum<?> item : type.getEnumConstants()) {
                genericItems.add((IGenericItem)((Object)item));
            }
        }
        return genericItems;
    }

    public static IGenericItem getFromID(Class<? extends Enum<?>> type, int id) {
        for (IGenericItem item : IGenericItem.getGenericItems(type)) {
            if (item.getID() != id) continue;
            return item;
        }
        return null;
    }

    public static IGenericItem getFromStack(Class<? extends Enum<?>> type, ItemStack stack) {
        return stack.func_190926_b() ? null : IGenericItem.getFromID(type, stack.func_77952_i());
    }

    public static class TypeContainer {
        private final Map<Class<? extends Enum<?>>, List<IGenericItem>> typeToItems = new HashMap();
    }
}

