/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.handler;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.storage.IChunkStorage;
import thebetweenlands.api.storage.IWorldStorage;
import thebetweenlands.common.world.storage.WorldStorageImpl;

public final class WorldEventHandler {
    public static final String CHUNK_NBT_TAG = "thebetweenlands:chunk_data";
    private static final Map<Chunk, IWorldStorage> UNLOAD_QUEUE = new HashMap<Chunk, IWorldStorage>();

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        IWorldStorage cap = WorldStorageImpl.getCapability(event.getWorld());
        if (cap != null) {
            IChunkStorage chunkStorage;
            cap.loadChunk(event.getChunk());
            if (!event.getWorld().field_72995_K && (chunkStorage = cap.getChunkStorage(event.getChunk())) != null) {
                cap.getLocalStorageHandler().loadDeferredOperations(chunkStorage);
            }
        }
    }

    @SubscribeEvent
    public static void onChunkRead(ChunkDataEvent.Load event) {
        IWorldStorage cap;
        if (event.getData().func_150297_b(CHUNK_NBT_TAG, 10) && (cap = WorldStorageImpl.getCapability(event.getWorld())) != null) {
            cap.readAndLoadChunk(event.getChunk(), event.getData().func_74775_l(CHUNK_NBT_TAG));
        }
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        IWorldStorage cap = WorldStorageImpl.getCapability(event.getWorld());
        if (cap != null) {
            if (event.getWorld().field_72995_K) {
                cap.unloadChunk(event.getChunk());
            } else {
                UNLOAD_QUEUE.put(event.getChunk(), cap);
            }
        }
    }

    @SubscribeEvent
    public static void onChunkSave(ChunkDataEvent.Save event) {
        IWorldStorage cap = WorldStorageImpl.getCapability(event.getWorld());
        if (cap != null) {
            NBTTagCompound nbt = cap.saveChunk(event.getChunk());
            if (nbt != null) {
                event.getData().func_74782_a(CHUNK_NBT_TAG, (NBTBase)nbt);
            }
            if (!event.getChunk().func_177410_o()) {
                cap.unloadChunk(event.getChunk());
                UNLOAD_QUEUE.remove(event.getChunk());
            }
        }
    }

    @SubscribeEvent
    public static void onWatchChunk(ChunkWatchEvent.Watch event) {
        IWorldStorage cap = WorldStorageImpl.getCapability(event.getChunkInstance().func_177412_p());
        if (cap != null) {
            cap.watchChunk(event.getChunkInstance().func_76632_l(), event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onUnwatchChunk(ChunkWatchEvent.UnWatch event) {
        IWorldStorage cap = WorldStorageImpl.getCapability(event.getChunkInstance().func_177412_p());
        if (cap != null) {
            cap.unwatchChunk(event.getChunkInstance().func_76632_l(), event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onWorldSave(WorldEvent.Save event) {
        IWorldStorage worldStorage = WorldStorageImpl.getCapability(event.getWorld());
        worldStorage.getLocalStorageHandler().saveAll();
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            for (Map.Entry<Chunk, IWorldStorage> entry : UNLOAD_QUEUE.entrySet()) {
                Chunk chunk = entry.getKey();
                if (chunk.func_177410_o()) continue;
                entry.getValue().unloadChunk(chunk);
            }
            UNLOAD_QUEUE.clear();
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.world.field_72995_K) {
            WorldEventHandler.tickWorld(event.world);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        WorldClient world;
        if (event.phase == TickEvent.Phase.END && (world = Minecraft.func_71410_x().field_71441_e) != null && !Minecraft.func_71410_x().func_147113_T()) {
            WorldEventHandler.tickWorld((World)world);
        }
    }

    private static void tickWorld(World world) {
        IWorldStorage cap = WorldStorageImpl.getCapability(world);
        if (cap != null) {
            cap.tick();
        }
    }
}

