/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.handler;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.capability.IDecayCapability;
import thebetweenlands.api.capability.IFoodSicknessCapability;
import thebetweenlands.api.item.IFoodSicknessItem;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.capability.decay.DecayStats;
import thebetweenlands.common.capability.foodsickness.FoodSickness;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.config.properties.ItemDecayFoodProperty;
import thebetweenlands.common.handler.OverworldItemHandler;
import thebetweenlands.common.network.clientbound.MessageShowFoodSicknessLine;
import thebetweenlands.common.registries.CapabilityRegistry;
import thebetweenlands.common.registries.GameruleRegistry;

public class FoodSicknessHandler {
    private static EnumHand lastHand = EnumHand.MAIN_HAND;
    private static ItemStack lastUsedItem = ItemStack.field_190927_a;
    private static FoodSickness lastSickness = null;

    private FoodSicknessHandler() {
    }

    public static boolean isFoodSicknessEnabled(World world) {
        if (GameruleRegistry.getGameRuleBooleanValue("blFoodSickness")) {
            if (world.field_73011_w.getDimension() == BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId && BetweenlandsConfig.GENERAL.useFoodSicknessInBetweenlands) {
                return true;
            }
            if (world.field_73011_w.getDimension() != BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId && BetweenlandsConfig.GENERAL.useFoodSicknessOutsideBetweenlands) {
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        EntityPlayer player = TheBetweenlands.proxy.getClientPlayer();
        if (!(player == null || lastUsedItem.func_190926_b() || !player.func_184586_b(lastHand).func_190926_b() && player.func_184586_b(lastHand).func_77969_a(lastUsedItem))) {
            lastUsedItem = ItemStack.field_190927_a;
            lastSickness = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected static void addSicknessMessage(EntityPlayer player, ItemStack item, FoodSickness sickness) {
        if (lastUsedItem.func_190926_b() || !item.func_77969_a(lastUsedItem) || lastSickness == null || lastSickness != sickness) {
            player.func_146105_b((ITextComponent)new TextComponentString(String.format(sickness.getRandomLine(player.func_70681_au()), item.func_82833_r())), true);
        }
        lastUsedItem = item;
        lastSickness = sickness;
    }

    @SubscribeEvent
    public static void onStartItemUse(LivingEntityUseItemEvent.Start event) {
        IFoodSicknessCapability cap;
        EntityPlayer player = event.getEntity() instanceof EntityPlayer ? (EntityPlayer)event.getEntity() : null;
        ItemStack itemStack = event.getItem();
        if (player != null && !itemStack.func_190926_b() && FoodSicknessHandler.isFoodSicknessEnabled(event.getEntity().func_130014_f_()) && itemStack.func_77973_b() instanceof IFoodSicknessItem && ((IFoodSicknessItem)itemStack.func_77973_b()).canGetSickOf(player, itemStack) && (cap = (IFoodSicknessCapability)player.getCapability(CapabilityRegistry.CAPABILITY_FOOD_SICKNESS, null)) != null) {
            Item item = itemStack.func_77973_b();
            FoodSickness sickness = cap.getSickness(item);
            if (player.field_70170_p.field_72995_K && sickness == FoodSickness.SICK) {
                FoodSicknessHandler.addSicknessMessage(player, itemStack, sickness);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onUseItemTick(LivingEntityUseItemEvent.Tick event) {
        if (!event.getEntityLiving().func_130014_f_().field_72995_K && event.getDuration() <= 1) {
            IFoodSicknessCapability cap;
            EntityPlayer player = event.getEntity() instanceof EntityPlayer ? (EntityPlayer)event.getEntity() : null;
            ItemStack itemStack = event.getItem();
            if (player != null && !itemStack.func_190926_b() && FoodSicknessHandler.isFoodSicknessEnabled(event.getEntity().func_130014_f_()) && itemStack.func_77973_b() instanceof IFoodSicknessItem && ((IFoodSicknessItem)itemStack.func_77973_b()).canGetSickOf(player, itemStack) && (cap = (IFoodSicknessCapability)player.getCapability(CapabilityRegistry.CAPABILITY_FOOD_SICKNESS, null)) != null) {
                Item item = itemStack.func_77973_b();
                FoodSickness lastSickness = cap.getLastSickness();
                int prevFoodHatred = cap.getFoodHatred(item);
                FoodSickness currentSickness = cap.getSickness(item);
                if (player.field_70170_p.field_72995_K && currentSickness != lastSickness && lastSickness == FoodSickness.SICK) {
                    FoodSicknessHandler.addSicknessMessage(player, itemStack, currentSickness);
                }
                int sicknessIncrease = 5;
                if (currentSickness == FoodSickness.SICK) {
                    IDecayCapability decayCap;
                    ItemDecayFoodProperty.DecayFoodStats decayFoodStats;
                    if (item instanceof ItemFood) {
                        int foodLevel = ((ItemFood)itemStack.func_77973_b()).func_150905_g(itemStack);
                        double foodLoss = 0.6666666666666666;
                        if (player.field_70170_p.field_72995_K) {
                            player.func_71024_bL().func_75122_a(-Math.min(MathHelper.func_76143_f((double)((double)foodLevel * foodLoss)), foodLevel), 0.0f);
                        } else {
                            int minFoodGain = player.field_70170_p.field_73012_v.nextInt(4) == 0 ? 1 : 0;
                            player.func_71024_bL().func_75122_a(-Math.min(MathHelper.func_76143_f((double)((double)foodLevel * foodLoss)), Math.max(foodLevel - minFoodGain, 0)), 0.0f);
                        }
                    }
                    if ((decayFoodStats = OverworldItemHandler.getDecayFoodStats(itemStack)) != null && (decayCap = (IDecayCapability)player.getCapability(CapabilityRegistry.CAPABILITY_DECAY, null)) != null) {
                        int decayLevel = decayFoodStats.decay;
                        DecayStats decayStats = decayCap.getDecayStats();
                        double decayLoss = 0.6666666666666666;
                        if (player.field_70170_p.field_72995_K) {
                            decayStats.addStats(-Math.min(MathHelper.func_76143_f((double)((double)decayLevel * decayLoss)), decayLevel), 0.0f);
                        } else {
                            int minDecayGain = player.field_70170_p.field_73012_v.nextInt(4) == 0 ? 1 : 0;
                            decayStats.addStats(-Math.min(MathHelper.func_76143_f((double)((double)decayLevel * decayLoss)), Math.max(decayLevel - minDecayGain, 0)), 0.0f);
                        }
                    }
                    if (!player.field_70170_p.field_72995_K) {
                        cap.increaseFoodHatred(item, sicknessIncrease, 0);
                    }
                } else if (!player.field_70170_p.field_72995_K) {
                    cap.increaseFoodHatred(item, sicknessIncrease, prevFoodHatred <= 10 ? 4 : 3);
                }
                FoodSickness newSickness = cap.getSickness(item);
                if (!player.field_70170_p.field_72995_K && player instanceof EntityPlayerMP && newSickness != lastSickness) {
                    TheBetweenlands.networkWrapper.sendTo((IMessage)new MessageShowFoodSicknessLine(itemStack, newSickness), (EntityPlayerMP)player);
                }
                cap.setLastSickness(newSickness);
            }
        }
    }
}

