/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.handler;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import thebetweenlands.api.item.IExtendedReach;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.network.serverbound.MessageExtendedReach;

public class ExtendedReachHandler {
    @SubscribeEvent
    public static void onMouseInput(InputEvent.MouseInputEvent event) {
        if (Mouse.getEventButtonState() && Minecraft.func_71410_x().field_71474_y.field_74312_F.isActiveAndMatches(Mouse.getEventButton() - 100)) {
            ExtendedReachHandler.handleAttack();
        }
    }

    @SubscribeEvent
    public static void onKeyboardInput(InputEvent.KeyInputEvent event) {
        int i;
        int n = i = Keyboard.getEventKey() == 0 ? Keyboard.getEventCharacter() + 256 : Keyboard.getEventKey();
        if (Keyboard.getEventKeyState() && Minecraft.func_71410_x().field_71474_y.field_74312_F.isActiveAndMatches(i)) {
            ExtendedReachHandler.handleAttack();
        }
    }

    private static void handleAttack() {
        ArrayList<Entity> hitEntities = new ArrayList<Entity>();
        if (ExtendedReachHandler.extendedRayTrace(trace -> hitEntities.add(trace.field_72308_g))) {
            ItemStack stack;
            Minecraft mc = Minecraft.func_71410_x();
            EntityPlayerSP player = mc.field_71439_g;
            if (player != null && !(stack = player.func_184586_b(EnumHand.MAIN_HAND)).func_190926_b() && stack.func_77973_b() instanceof IExtendedReach) {
                ((IExtendedReach)stack.func_77973_b()).onLeftClick((EntityPlayer)player, stack);
            }
            TheBetweenlands.networkWrapper.sendToServer((IMessage)new MessageExtendedReach(hitEntities));
        }
    }

    @SubscribeEvent
    public static void onCrosshairRenderPost(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            ExtendedReachHandler.extendedRayTrace(trace -> {
                Minecraft mc = Minecraft.func_71410_x();
                if (mc.field_147125_j == null && mc.field_71474_y.field_74320_O == 0) {
                    if (mc.field_71442_b.func_78747_a() && mc.field_147125_j == null) {
                        RayTraceResult raytraceresult = mc.field_71476_x;
                        if (raytraceresult == null || raytraceresult.field_72313_a != RayTraceResult.Type.BLOCK) {
                            return;
                        }
                        BlockPos blockpos = raytraceresult.func_178782_a();
                        IBlockState state = mc.field_71441_e.func_180495_p(blockpos);
                        if (!state.func_177230_c().hasTileEntity(state) || !(mc.field_71441_e.func_175625_s(blockpos) instanceof IInventory)) {
                            return;
                        }
                    }
                    if (mc.field_71474_y.field_186716_M == 1 && (!mc.field_71474_y.field_74330_P || mc.field_71474_y.field_74319_N || mc.field_71439_g.func_175140_cp() || mc.field_71474_y.field_178879_v)) {
                        GuiIngame gui = mc.field_71456_v;
                        mc.func_110434_K().func_110577_a(Gui.field_110324_m);
                        float f = mc.field_71439_g.func_184825_o(0.0f);
                        boolean flag = false;
                        if (trace.field_72308_g instanceof EntityLivingBase && f >= 1.0f) {
                            flag = mc.field_71439_g.func_184818_cX() > 5.0f;
                            flag &= trace.field_72308_g.func_70089_S();
                        }
                        int l = event.getResolution().func_78326_a();
                        int i1 = event.getResolution().func_78328_b();
                        int i = i1 / 2 - 7 + 16;
                        int j = l / 2 - 8;
                        if (flag) {
                            gui.func_73729_b(j, i, 68, 94, 16, 16);
                        } else if (f < 1.0f) {
                            int k = (int)(f * 17.0f);
                            gui.func_73729_b(j, i, 36, 94, 16, 4);
                            gui.func_73729_b(j, i, 52, 94, k, 4);
                        }
                    }
                }
            });
        }
    }

    private static boolean extendedRayTrace(Consumer<RayTraceResult> consumer) {
        ItemStack stack;
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (player != null && !(stack = player.func_184586_b(EnumHand.MAIN_HAND)).func_190926_b() && stack.func_77973_b() instanceof IExtendedReach) {
            double reach = ((IExtendedReach)stack.func_77973_b()).getReach();
            RayTraceResult trace = ExtendedReachHandler.getExtendedRayTrace(reach);
            if (trace != null && trace.field_72308_g != null && trace.field_72308_g.field_70172_ad == 0 && trace.field_72308_g != player) {
                consumer.accept(trace);
            }
            return true;
        }
        return false;
    }

    public static RayTraceResult getExtendedRayTrace(double dist) {
        Minecraft mc = Minecraft.func_71410_x();
        Entity viewEntity = mc.func_175606_aa();
        RayTraceResult result = null;
        if (mc.field_71441_e != null && viewEntity != null) {
            result = viewEntity.func_174822_a(dist, 0.0f);
            Vec3d viewPos = viewEntity.func_174824_e(0.0f);
            double calcdist = dist;
            if (result != null) {
                calcdist = result.field_72307_f.func_72438_d(viewPos);
            }
            Vec3d startVec = viewEntity.func_70676_i(1.0f);
            Vec3d endVec = viewPos.func_72441_c(startVec.field_72450_a * dist, startVec.field_72448_b * dist, startVec.field_72449_c * dist);
            Entity targetEntity = null;
            Vec3d hitVec = null;
            List list = mc.field_71441_e.func_175674_a(viewEntity, viewEntity.func_174813_aQ().func_72321_a(startVec.field_72450_a * dist, startVec.field_72448_b * dist, startVec.field_72449_c * dist).func_72314_b(1.0, 1.0, 1.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d, Predicates.notNull(), Entity::func_70067_L}));
            double entityDist = calcdist;
            for (Entity entity : list) {
                double d1;
                AxisAlignedBB entityAABB = entity.func_174813_aQ().func_186662_g((double)entity.func_70111_Y());
                RayTraceResult traceResult = entityAABB.func_72327_a(viewPos, endVec);
                if (entityAABB.func_72318_a(viewPos)) {
                    if (!(entityDist >= 0.0)) continue;
                    targetEntity = entity;
                    hitVec = traceResult == null ? viewPos : traceResult.field_72307_f;
                    entityDist = 0.0;
                    continue;
                }
                if (traceResult == null || !((d1 = viewPos.func_72438_d(traceResult.field_72307_f)) < entityDist) && entityDist != 0.0) continue;
                if (entity.func_184208_bv() == viewEntity.func_184208_bv() && !entity.canRiderInteract()) {
                    if (entityDist != 0.0) continue;
                    targetEntity = entity;
                    hitVec = traceResult.field_72307_f;
                    continue;
                }
                targetEntity = entity;
                hitVec = traceResult.field_72307_f;
                entityDist = d1;
            }
            if (targetEntity != null && (entityDist < calcdist || result == null)) {
                result = new RayTraceResult(targetEntity, hitVec);
            }
        }
        return result;
    }
}

