/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.projectiles;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import thebetweenlands.api.event.SplashPotionEvent;
import thebetweenlands.common.block.terrain.BlockDentrothyst;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.registries.ItemRegistry;

public class EntityElixir
extends EntityThrowable {
    private static final DataParameter<ItemStack> ITEM = EntityDataManager.func_187226_a(EntityElixir.class, (DataSerializer)DataSerializers.field_187196_f);

    public EntityElixir(World world) {
        super(world);
    }

    public EntityElixir(World world, EntityLivingBase thrower, ItemStack elixir) {
        super(world, thrower);
        this.setItem(elixir.func_77946_l());
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(ITEM, (Object)ItemStack.field_190927_a);
    }

    public ItemStack getElixirStack() {
        return (ItemStack)this.func_184212_Q().func_187225_a(ITEM);
    }

    public void setItem(ItemStack stack) {
        this.func_184212_Q().func_187227_b(ITEM, (Object)stack);
        this.func_184212_Q().func_187217_b(ITEM);
    }

    protected float func_70185_h() {
        return 0.05f;
    }

    protected void func_70184_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            AxisAlignedBB hitBB = this.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0);
            List hitEntities = this.field_70170_p.func_72872_a(EntityLivingBase.class, hitBB);
            if (!hitEntities.isEmpty()) {
                for (EntityLivingBase affectedEntity : hitEntities) {
                    double entityDst = this.func_70068_e((Entity)affectedEntity);
                    if (!(entityDst < 16.0)) continue;
                    double modifier = 1.0 - Math.sqrt(entityDst) / 4.0;
                    if (affectedEntity == result.field_72308_g) {
                        modifier = 1.0;
                    }
                    PotionEffect effect = ItemRegistry.ELIXIR.createPotionEffect(this.getElixirStack(), modifier);
                    SplashPotionEvent event = new SplashPotionEvent((Entity)this, affectedEntity, effect, effect.func_188419_a().func_76403_b());
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    if (event.isCanceled()) continue;
                    affectedEntity.func_70690_d(effect);
                }
            }
            this.field_70170_p.func_175718_b(2002, new BlockPos((Entity)this), ItemRegistry.ELIXIR.getColorMultiplier(this.getElixirStack(), 0));
            this.func_70099_a(new ItemStack(ItemRegistry.ELIXIR.getDentrothystType(this.getElixirStack()) == BlockDentrothyst.EnumDentrothyst.GREEN ? ItemRegistry.DENTROTHYST_SHARD_GREEN : ItemRegistry.DENTROTHYST_SHARD_ORANGE, this.field_70170_p.field_73012_v.nextInt(2) + 2), this.field_70131_O / 2.0f);
            if (this.field_70170_p.field_73012_v.nextInt(2) == 0) {
                this.func_70099_a(ItemMisc.EnumItemMisc.RUBBER_BALL.create(1), this.field_70131_O / 2.0f);
            }
            this.func_70106_y();
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        ItemStack itemstack = new ItemStack(nbt.func_74775_l("elixir"));
        if (itemstack.func_190926_b()) {
            this.func_70106_y();
        } else {
            this.setItem(itemstack);
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        ItemStack stack = this.getElixirStack();
        if (!stack.func_190926_b()) {
            nbt.func_74782_a("elixir", (NBTBase)stack.func_77955_b(new NBTTagCompound()));
        }
    }
}

