/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.projectiles;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IThrowableEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.BatchedParticleRenderer;
import thebetweenlands.client.render.particle.DefaultParticleBatches;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.entity.EntityShock;
import thebetweenlands.common.entity.mobs.EntityChiromawMatriarch;
import thebetweenlands.common.entity.mobs.EntityTinySludgeWormHelper;
import thebetweenlands.common.herblore.elixir.ElixirEffectRegistry;
import thebetweenlands.common.item.tools.bow.EnumArrowType;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityBLArrow
extends EntityArrow
implements IThrowableEntity {
    private static final Predicate<Entity> ARROW_TARGETS = Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d, EntitySelectors.field_94557_a, new Predicate<Entity>(){

        public boolean apply(@Nullable Entity entity) {
            return entity.func_70067_L();
        }
    }});
    private static final DataParameter<String> DW_TYPE = EntityDataManager.func_187226_a(EntityBLArrow.class, (DataSerializer)DataSerializers.field_187194_d);
    private int ticksSpentInAir = 0;
    private int ticksSpentInGround = 0;

    public EntityBLArrow(World worldIn) {
        super(worldIn);
    }

    public EntityBLArrow(World worldIn, EntityLivingBase shooter) {
        super(worldIn, shooter);
    }

    public Entity getThrower() {
        return this.field_70250_c;
    }

    public void setThrower(Entity entity) {
        this.field_70250_c = entity;
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DW_TYPE, (Object)"");
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74778_a("arrowType", this.getArrowType().func_176610_l());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setType(EnumArrowType.getEnumFromString(nbt.func_74779_i("arrowType")));
    }

    @Nullable
    protected Entity func_184551_a(Vec3d start, Vec3d end) {
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0), ARROW_TARGETS);
        Entity hit = null;
        double minDstSq = 0.0;
        for (Entity entity : list) {
            double dstSq;
            AxisAlignedBB checkBox;
            RayTraceResult rayTrace;
            if (!this.isNotShootingEntity(entity) && this.ticksSpentInAir < 5 || (rayTrace = (checkBox = entity.func_174813_aQ().func_186662_g(0.3)).func_72327_a(start, end)) == null || !((dstSq = start.func_72436_e(rayTrace.field_72307_f)) < minDstSq) && minDstSq != 0.0) continue;
            hit = entity;
            minDstSq = dstSq;
        }
        return hit;
    }

    private boolean isNotShootingEntity(Entity entity) {
        if (entity == this.field_70250_c) {
            return false;
        }
        if (!(this.field_70250_c instanceof EntityPlayer) && this.field_70250_c != null && this.field_70250_c.func_184187_bx() == entity) {
            return false;
        }
        return !(this.field_70250_c instanceof EntityPlayer) || this.field_70250_c == null || !(entity instanceof IEntityOwnable) || ((IEntityOwnable)entity).func_70902_q() != this.field_70250_c || !this.field_70250_c.func_184182_bu().contains(entity);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70254_i) {
            this.ticksSpentInAir = 0;
            ++this.ticksSpentInGround;
        } else {
            ++this.ticksSpentInAir;
            this.ticksSpentInGround = 0;
        }
        if (!(this.field_70170_p.field_72995_K || this.getArrowType() != EnumArrowType.CHIROMAW_BARB && this.getArrowType() != EnumArrowType.CHIROMAW_SHOCK_BARB || this.field_70251_a == EntityArrow.PickupStatus.ALLOWED || this.ticksSpentInGround <= 100)) {
            this.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K && (this.getArrowType() == EnumArrowType.SHOCK || this.getArrowType() == EnumArrowType.CHIROMAW_SHOCK_BARB)) {
            this.spawnLightningArcs();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnLightningArcs() {
        Entity view = Minecraft.func_71410_x().func_175606_aa();
        if (view != null && view.func_70032_d((Entity)this) < 16.0f && this.field_70170_p.field_73012_v.nextInt(!this.field_70254_i ? 2 : 20) == 0) {
            float ox = this.field_70170_p.field_73012_v.nextFloat() - 0.5f + (!this.field_70254_i ? (float)this.field_70159_w : 0.0f);
            float oy = this.field_70170_p.field_73012_v.nextFloat() - 0.5f + (!this.field_70254_i ? (float)this.field_70181_x : 0.0f);
            float oz = this.field_70170_p.field_73012_v.nextFloat() - 0.5f + (!this.field_70254_i ? (float)this.field_70179_y : 0.0f);
            Particle particle = BLParticles.LIGHTNING_ARC.create(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(!this.field_70254_i ? this.field_70159_w : 0.0, !this.field_70254_i ? this.field_70181_x : 0.0, !this.field_70254_i ? this.field_70179_y : 0.0)).withColor(0.3f, 0.5f, 1.0f, 0.9f)).withData(new Vec3d(this.field_70165_t + (double)ox, this.field_70163_u + (double)oy, this.field_70161_v + (double)oz)));
            BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.BEAM, particle);
        }
    }

    protected void func_184548_a(EntityLivingBase living) {
        switch (this.getArrowType()) {
            case ANGLER_POISON: {
                living.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 200, 2));
                break;
            }
            case OCTINE: {
                if (living.func_70027_ad()) {
                    living.func_70015_d(9);
                    break;
                }
                living.func_70015_d(5);
                break;
            }
            case BASILISK: {
                if (living.func_184222_aU() && !(living instanceof EntityChiromawMatriarch)) {
                    living.func_70690_d(ElixirEffectRegistry.EFFECT_PETRIFY.createEffect(100, 1));
                    break;
                }
                living.func_70690_d(ElixirEffectRegistry.EFFECT_PETRIFY.createEffect(40, 1));
                break;
            }
            case WORM: {
                if (this.func_130014_f_().field_72995_K) break;
                EntityTinySludgeWormHelper worm = new EntityTinySludgeWormHelper(this.func_130014_f_());
                worm.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
                worm.func_70624_b(living);
                if (this.field_70250_c instanceof EntityPlayer) {
                    worm.setOwnerId(this.field_70250_c.func_110124_au());
                }
                this.func_130014_f_().func_72838_d((Entity)worm);
                this.func_70106_y();
                break;
            }
            case SHOCK: {
                if (this.field_70170_p.field_72995_K) break;
                this.field_70170_p.func_72838_d((Entity)new EntityShock(this.field_70170_p, this, living, this.func_70026_G() || this.func_70090_H() || this.field_70170_p.func_175727_C(this.func_180425_c().func_177984_a())));
                break;
            }
            case CHIROMAW_BARB: {
                if (!living.func_184222_aU() || living instanceof EntityChiromawMatriarch) break;
                living.func_70690_d(ElixirEffectRegistry.EFFECT_PETRIFY.createEffect(40, 1));
                break;
            }
            case CHIROMAW_SHOCK_BARB: {
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)new EntityShock(this.field_70170_p, this, living, this.func_70026_G() || this.func_70090_H() || this.field_70170_p.func_175727_C(this.func_180425_c().func_177984_a())));
                }
                if (!living.func_184222_aU() || living instanceof EntityChiromawMatriarch) break;
                living.func_70690_d(ElixirEffectRegistry.EFFECT_PETRIFY.createEffect(40, 1));
                break;
            }
        }
    }

    protected void func_184549_a(RayTraceResult raytrace) {
        BlockPos pos;
        IBlockState state;
        super.func_184549_a(raytrace);
        if (raytrace.field_72308_g == null && raytrace.func_178782_a() != null && raytrace.field_178784_b != null && this.getArrowType() == EnumArrowType.OCTINE && ItemRegistry.OCTINE_INGOT.isTinder(new ItemStack((Item)ItemRegistry.OCTINE_INGOT), ItemStack.field_190927_a, state = this.field_70170_p.func_180495_p(pos = raytrace.func_178782_a().func_177972_a(raytrace.field_178784_b)))) {
            this.field_70170_p.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
        }
    }

    public void func_184185_a(SoundEvent soundIn, float volume, float pitch) {
        if (!(this.func_174814_R() || this.getArrowType() != EnumArrowType.CHIROMAW_BARB && this.getArrowType() != EnumArrowType.CHIROMAW_SHOCK_BARB || soundIn != SoundEvents.field_187731_t)) {
            soundIn = SoundRegistry.CHIROMAW_MATRIARCH_BARB_HIT;
        }
        super.func_184185_a(soundIn, volume, pitch);
    }

    public void setType(EnumArrowType type) {
        this.field_70180_af.func_187227_b(DW_TYPE, (Object)type.func_176610_l());
    }

    public EnumArrowType getArrowType() {
        return EnumArrowType.getEnumFromString((String)this.field_70180_af.func_187225_a(DW_TYPE));
    }

    protected ItemStack func_184550_j() {
        switch (this.getArrowType()) {
            case ANGLER_POISON: {
                return new ItemStack(ItemRegistry.POISONED_ANGLER_TOOTH_ARROW);
            }
            case OCTINE: {
                return new ItemStack(ItemRegistry.OCTINE_ARROW);
            }
            case BASILISK: {
                return new ItemStack(ItemRegistry.BASILISK_ARROW);
            }
            case WORM: {
                return new ItemStack(ItemRegistry.SLUDGE_WORM_ARROW);
            }
            case SHOCK: {
                return new ItemStack(ItemRegistry.SHOCK_ARROW);
            }
            case CHIROMAW_BARB: {
                return new ItemStack(ItemRegistry.CHIROMAW_BARB);
            }
            case DEFAULT: {
                return new ItemStack(ItemRegistry.ANGLER_TOOTH_ARROW);
            }
        }
        return ItemStack.field_190927_a;
    }
}

