/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.movement;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.common.entity.mobs.EntityClimberBase;
import thebetweenlands.common.entity.movement.ObstructionAwarePathNavigateGround;
import thebetweenlands.common.entity.movement.ObstructionAwareWalkNodeProcessor;

public class ObstructionAwarePathNavigateClimber<T extends EntityClimberBase>
extends ObstructionAwarePathNavigateGround<T> {
    protected final EntityClimberBase climber;
    protected EnumFacing verticalFacing = EnumFacing.DOWN;

    public ObstructionAwarePathNavigateClimber(T entity, World worldIn, boolean checkObstructions, boolean canPathWalls, boolean canPathCeiling) {
        super(entity, worldIn, checkObstructions);
        this.climber = entity;
        if (this.field_179695_a instanceof ObstructionAwareWalkNodeProcessor) {
            ObstructionAwareWalkNodeProcessor processor = (ObstructionAwareWalkNodeProcessor)this.field_179695_a;
            processor.setStartPathOnGround(false);
            processor.setCanPathWalls(canPathWalls);
            processor.setCanPathCeiling(canPathCeiling);
        }
    }

    protected boolean func_75485_k() {
        return !this.func_75506_l() || this.func_179684_h() && this.func_75506_l() || this.field_75515_a.func_184218_aH();
    }

    protected Vec3d func_75502_i() {
        return this.field_75515_a.func_174791_d().func_72441_c(0.0, (double)(this.field_75515_a.field_70131_O / 2.0f), 0.0);
    }

    @Nullable
    public Path func_179680_a(BlockPos pos) {
        if (!this.func_75485_k()) {
            return null;
        }
        if (this.field_75514_c != null && !this.field_75514_c.func_75879_b() && pos.equals((Object)this.field_188564_r)) {
            return this.field_75514_c;
        }
        this.field_188564_r = pos;
        float searchRange = this.func_111269_d();
        this.field_75513_b.field_72984_F.func_76320_a("pathfind");
        BlockPos cachePos = new BlockPos((Entity)this.field_75515_a);
        int cacheSize = (int)(searchRange + 8.0f);
        ChunkCache chunkCache = new ChunkCache(this.field_75513_b, cachePos.func_177982_a(-cacheSize, -cacheSize, -cacheSize), cachePos.func_177982_a(cacheSize, cacheSize, cacheSize), 0);
        Path path = this.field_179681_j.func_186336_a((IBlockAccess)chunkCache, this.field_75515_a, this.field_188564_r, searchRange);
        this.field_75513_b.field_72984_F.func_76319_b();
        return path;
    }

    @Nullable
    public Path func_75494_a(Entity entityIn) {
        if (!this.func_75485_k()) {
            return null;
        }
        BlockPos pos = new BlockPos(entityIn);
        if (this.field_75514_c != null && !this.field_75514_c.func_75879_b() && pos.equals((Object)this.field_188564_r)) {
            return this.field_75514_c;
        }
        this.field_188564_r = pos;
        float searchRange = this.func_111269_d();
        this.field_75513_b.field_72984_F.func_76320_a("pathfind");
        BlockPos cachePos = pos.func_177984_a();
        int cacheSize = (int)(searchRange + 16.0f);
        ChunkCache chunkCache = new ChunkCache(this.field_75513_b, cachePos.func_177982_a(-cacheSize, -cacheSize, -cacheSize), cachePos.func_177982_a(cacheSize, cacheSize, cacheSize), 0);
        Path path = this.field_179681_j.func_186333_a((IBlockAccess)chunkCache, this.field_75515_a, entityIn, searchRange);
        this.field_75513_b.field_72984_F.func_76319_b();
        return path;
    }

    protected void func_75508_h() {
        Vec3d pos = this.func_75502_i();
        EntityClimberBase.Orientation orientation = this.climber.getOrientation(1.0f);
        Vec3d upVector = orientation.getForward(this.climber.field_70177_z, -90.0f);
        this.verticalFacing = EnumFacing.func_176737_a((float)((float)upVector.field_72450_a), (float)((float)upVector.field_72448_b), (float)((float)upVector.field_72449_c));
        EnumFacing.Axis verticalAxis = this.verticalFacing.func_176740_k();
        int firstDifferentHeightPoint = this.field_75514_c.func_75874_d();
        block0 : switch (verticalAxis) {
            case X: {
                int i;
                for (i = this.field_75514_c.func_75873_e(); i < this.field_75514_c.func_75874_d(); ++i) {
                    if ((double)this.field_75514_c.func_75877_a((int)i).field_75839_a == Math.floor(pos.field_72450_a)) continue;
                    firstDifferentHeightPoint = i;
                    break block0;
                }
                break;
            }
            case Y: {
                int i;
                for (i = this.field_75514_c.func_75873_e(); i < this.field_75514_c.func_75874_d(); ++i) {
                    if ((double)this.field_75514_c.func_75877_a((int)i).field_75837_b == Math.floor(pos.field_72448_b)) continue;
                    firstDifferentHeightPoint = i;
                    break block0;
                }
                break;
            }
            case Z: {
                int i;
                for (i = this.field_75514_c.func_75873_e(); i < this.field_75514_c.func_75874_d(); ++i) {
                    if ((double)this.field_75514_c.func_75877_a((int)i).field_75838_c == Math.floor(pos.field_72449_c)) continue;
                    firstDifferentHeightPoint = i;
                    break block0;
                }
                break;
            }
        }
        this.field_188561_o = this.field_75515_a.field_70130_N > 0.75f ? this.field_75515_a.field_70130_N / 2.0f : 0.75f - this.field_75515_a.field_70130_N / 2.0f;
        float maxDistanceToWaypointY = this.field_75515_a.field_70131_O > 0.75f ? this.field_75515_a.field_70131_O / 2.0f : 0.75f - this.field_75515_a.field_70131_O / 2.0f;
        Vec3d currentTarget = this.field_75514_c.func_186310_f();
        if (MathHelper.func_76135_e((float)((float)(this.field_75515_a.field_70165_t - (currentTarget.field_72450_a + 0.5)))) < this.field_188561_o && MathHelper.func_76135_e((float)((float)(this.field_75515_a.field_70163_u + (double)(this.field_75515_a.field_70131_O / 2.0f) - (currentTarget.field_72448_b + 0.5)))) < maxDistanceToWaypointY && MathHelper.func_76135_e((float)((float)(this.field_75515_a.field_70161_v - (currentTarget.field_72449_c + 0.5)))) < this.field_188561_o) {
            this.field_75514_c.func_75872_c(this.field_75514_c.func_75873_e() + 1);
        }
        int sizeX = MathHelper.func_76123_f((float)this.field_75515_a.field_70130_N);
        int sizeY = MathHelper.func_76123_f((float)this.field_75515_a.field_70131_O);
        int sizeZ = sizeX;
        for (int i = firstDifferentHeightPoint - 1; i >= this.field_75514_c.func_75873_e(); --i) {
            if (!this.func_75493_a(pos, this.field_75514_c.func_75881_a((Entity)this.field_75515_a, i), sizeX, sizeY, sizeZ)) continue;
            this.field_75514_c.func_75872_c(i);
            break;
        }
        this.func_179677_a(pos);
    }

    protected static double swizzle(Vec3d vec, EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return vec.field_72450_a;
            }
            case Y: {
                return vec.field_72448_b;
            }
            case Z: {
                return vec.field_72449_c;
            }
        }
        return 0.0;
    }

    protected static int swizzle(int x, int y, int z, EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return x;
            }
            case Y: {
                return y;
            }
            case Z: {
                return z;
            }
        }
        return 0;
    }

    protected static int unswizzle(int x, int y, int z, EnumFacing.Axis ax, EnumFacing.Axis ay, EnumFacing.Axis az, EnumFacing.Axis axis) {
        EnumFacing.Axis unswizzle = axis == ax ? EnumFacing.Axis.X : (axis == ay ? EnumFacing.Axis.Y : EnumFacing.Axis.Z);
        return ObstructionAwarePathNavigateClimber.swizzle(x, y, z, unswizzle);
    }

    protected boolean func_75493_a(Vec3d start, Vec3d end, int sizeX, int sizeY, int sizeZ) {
        switch (this.verticalFacing.func_176740_k()) {
            case X: {
                return this.isDirectPathBetweenPoints(start, end, sizeX, sizeY, sizeZ, EnumFacing.Axis.Z, EnumFacing.Axis.X, EnumFacing.Axis.Y);
            }
            case Y: {
                return this.isDirectPathBetweenPoints(start, end, sizeX, sizeY, sizeZ, EnumFacing.Axis.X, EnumFacing.Axis.Y, EnumFacing.Axis.Z);
            }
            case Z: {
                return this.isDirectPathBetweenPoints(start, end, sizeX, sizeY, sizeZ, EnumFacing.Axis.Y, EnumFacing.Axis.Z, EnumFacing.Axis.X);
            }
        }
        return false;
    }

    protected boolean isDirectPathBetweenPoints(Vec3d start, Vec3d end, int sizeX, int sizeY, int sizeZ, EnumFacing.Axis ax, EnumFacing.Axis ay, EnumFacing.Axis az) {
        int bx = MathHelper.func_76128_c((double)ObstructionAwarePathNavigateClimber.swizzle(start, ax));
        int bz = MathHelper.func_76128_c((double)ObstructionAwarePathNavigateClimber.swizzle(start, az));
        double dx = ObstructionAwarePathNavigateClimber.swizzle(end, ax) - ObstructionAwarePathNavigateClimber.swizzle(start, ax);
        double dz = ObstructionAwarePathNavigateClimber.swizzle(end, az) - ObstructionAwarePathNavigateClimber.swizzle(start, az);
        double dSq = dx * dx + dz * dz;
        int by = (int)ObstructionAwarePathNavigateClimber.swizzle(start, ay);
        int sizeX2 = ObstructionAwarePathNavigateClimber.swizzle(sizeX, sizeY, sizeZ, ax);
        int sizeY2 = ObstructionAwarePathNavigateClimber.swizzle(sizeX, sizeY, sizeZ, ay);
        int sizeZ2 = ObstructionAwarePathNavigateClimber.swizzle(sizeX, sizeY, sizeZ, az);
        if (dSq < 1.0E-8) {
            return false;
        }
        double d3 = 1.0 / Math.sqrt(dSq);
        if (!this.isSafeToStandAt(ObstructionAwarePathNavigateClimber.unswizzle(bx, by, bz, ax, ay, az, EnumFacing.Axis.X), ObstructionAwarePathNavigateClimber.unswizzle(bx, by, bz, ax, ay, az, EnumFacing.Axis.Y), ObstructionAwarePathNavigateClimber.unswizzle(bx, by, bz, ax, ay, az, EnumFacing.Axis.Z), ObstructionAwarePathNavigateClimber.unswizzle(sizeX2 += 2, sizeY2, sizeZ2 += 2, ax, ay, az, EnumFacing.Axis.X), ObstructionAwarePathNavigateClimber.unswizzle(sizeX2, sizeY2, sizeZ2, ax, ay, az, EnumFacing.Axis.Y), ObstructionAwarePathNavigateClimber.unswizzle(sizeX2, sizeY2, sizeZ2, ax, ay, az, EnumFacing.Axis.Z), start, dx *= d3, dz *= d3, ax, ay, az)) {
            return false;
        }
        sizeX2 -= 2;
        sizeZ2 -= 2;
        double stepX = 1.0 / Math.abs(dx);
        double stepZ = 1.0 / Math.abs(dz);
        double relX = (double)bx - ObstructionAwarePathNavigateClimber.swizzle(start, ax);
        double relZ = (double)bz - ObstructionAwarePathNavigateClimber.swizzle(start, az);
        if (dx >= 0.0) {
            relX += 1.0;
        }
        if (dz >= 0.0) {
            relZ += 1.0;
        }
        relX /= dx;
        relZ /= dz;
        int dirX = dx < 0.0 ? -1 : 1;
        int dirZ = dz < 0.0 ? -1 : 1;
        int ex = MathHelper.func_76128_c((double)ObstructionAwarePathNavigateClimber.swizzle(end, ax));
        int ez = MathHelper.func_76128_c((double)ObstructionAwarePathNavigateClimber.swizzle(end, az));
        int offsetX = ex - bx;
        int offsetZ = ez - bz;
        while (offsetX * dirX > 0 || offsetZ * dirZ > 0) {
            if (relX < relZ) {
                relX += stepX;
                offsetX = ex - (bx += dirX);
            } else {
                relZ += stepZ;
                offsetZ = ez - (bz += dirZ);
            }
            if (this.isSafeToStandAt(ObstructionAwarePathNavigateClimber.unswizzle(bx, by, bz, ax, ay, az, EnumFacing.Axis.X), ObstructionAwarePathNavigateClimber.unswizzle(bx, by, bz, ax, ay, az, EnumFacing.Axis.Y), ObstructionAwarePathNavigateClimber.unswizzle(bx, by, bz, ax, ay, az, EnumFacing.Axis.Z), ObstructionAwarePathNavigateClimber.unswizzle(sizeX2, sizeY2, sizeZ2, ax, ay, az, EnumFacing.Axis.X), ObstructionAwarePathNavigateClimber.unswizzle(sizeX2, sizeY2, sizeZ2, ax, ay, az, EnumFacing.Axis.Y), ObstructionAwarePathNavigateClimber.unswizzle(sizeX2, sizeY2, sizeZ2, ax, ay, az, EnumFacing.Axis.Z), start, dx, dz, ax, ay, az)) continue;
            return false;
        }
        return true;
    }

    protected boolean isSafeToStandAt(int x, int y, int z, int sizeX, int sizeY, int sizeZ, Vec3d start, double dx, double dz, EnumFacing.Axis ax, EnumFacing.Axis ay, EnumFacing.Axis az) {
        int sizeX2 = ObstructionAwarePathNavigateClimber.swizzle(sizeX, sizeY, sizeZ, ax);
        int sizeZ2 = ObstructionAwarePathNavigateClimber.swizzle(sizeX, sizeY, sizeZ, az);
        int bx = ObstructionAwarePathNavigateClimber.swizzle(x, y, z, ax) - sizeX2 / 2;
        int bz = ObstructionAwarePathNavigateClimber.swizzle(x, y, z, az) - sizeZ2 / 2;
        int by = ObstructionAwarePathNavigateClimber.swizzle(x, y, z, ay);
        if (!this.isPositionClear(ObstructionAwarePathNavigateClimber.unswizzle(bx, y, bz, ax, ay, az, EnumFacing.Axis.X), ObstructionAwarePathNavigateClimber.unswizzle(bx, y, bz, ax, ay, az, EnumFacing.Axis.Y), ObstructionAwarePathNavigateClimber.unswizzle(bx, y, bz, ax, ay, az, EnumFacing.Axis.Z), sizeX, sizeY, sizeZ, start, dx, dz, ax, ay, az)) {
            return false;
        }
        for (int obx = bx; obx < bx + sizeX2; ++obx) {
            for (int obz = bz; obz < bz + sizeZ2; ++obz) {
                double offsetZ;
                double offsetX = (double)obx + 0.5 - ObstructionAwarePathNavigateClimber.swizzle(start, ax);
                if (!(offsetX * dx + (offsetZ = (double)obz + 0.5 - ObstructionAwarePathNavigateClimber.swizzle(start, az)) * dz >= 0.0)) continue;
                PathNodeType nodeType = this.field_179695_a.func_186319_a((IBlockAccess)this.field_75513_b, ObstructionAwarePathNavigateClimber.unswizzle(obx, by - 1, obz, ax, ay, az, EnumFacing.Axis.X), ObstructionAwarePathNavigateClimber.unswizzle(obx, by - 1, obz, ax, ay, az, EnumFacing.Axis.Y), ObstructionAwarePathNavigateClimber.unswizzle(obx, by - 1, obz, ax, ay, az, EnumFacing.Axis.Z), this.field_75515_a, sizeX, sizeY, sizeZ, true, true);
                if (nodeType == PathNodeType.WATER) {
                    return false;
                }
                if (nodeType == PathNodeType.LAVA) {
                    return false;
                }
                if (nodeType == PathNodeType.OPEN) {
                    return false;
                }
                nodeType = this.field_179695_a.func_186319_a((IBlockAccess)this.field_75513_b, ObstructionAwarePathNavigateClimber.unswizzle(obx, by, obz, ax, ay, az, EnumFacing.Axis.X), ObstructionAwarePathNavigateClimber.unswizzle(obx, by, obz, ax, ay, az, EnumFacing.Axis.Y), ObstructionAwarePathNavigateClimber.unswizzle(obx, by, obz, ax, ay, az, EnumFacing.Axis.Z), this.field_75515_a, sizeX, sizeY, sizeZ, true, true);
                float f = this.field_75515_a.func_184643_a(nodeType);
                if (f < 0.0f || f >= 8.0f) {
                    return false;
                }
                if (nodeType != PathNodeType.DAMAGE_FIRE && nodeType != PathNodeType.DANGER_FIRE && nodeType != PathNodeType.DAMAGE_OTHER) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean isPositionClear(int x, int y, int z, int sizeX, int sizeY, int sizeZ, Vec3d start, double dx, double dz, EnumFacing.Axis ax, EnumFacing.Axis ay, EnumFacing.Axis az) {
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)new BlockPos(x, y, z), (BlockPos)new BlockPos(x + sizeX - 1, y + sizeY - 1, z + sizeZ - 1))) {
            Block block;
            double pffsetZ;
            double offsetX = (double)ObstructionAwarePathNavigateClimber.swizzle(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), ax) + 0.5 - ObstructionAwarePathNavigateClimber.swizzle(start, ax);
            if (!(offsetX * dx + (pffsetZ = (double)ObstructionAwarePathNavigateClimber.swizzle(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), az) + 0.5 - ObstructionAwarePathNavigateClimber.swizzle(start, az)) * dz >= 0.0) || (block = this.field_75513_b.func_180495_p(pos).func_177230_c()).func_176205_b((IBlockAccess)this.field_75513_b, pos)) continue;
            return false;
        }
        return true;
    }
}

