/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.capability.ISwarmedCapability;
import thebetweenlands.client.audio.EntitySound;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.BatchedParticleRenderer;
import thebetweenlands.client.render.particle.DefaultParticleBatches;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.entity.mobs.EntityClimberBase;
import thebetweenlands.common.registries.CapabilityRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntitySwarm
extends EntityClimberBase
implements IMob {
    public static final DataParameter<Float> SWARM_SIZE = EntityDataManager.func_187226_a(EntitySwarm.class, (DataSerializer)DataSerializers.field_187193_c);
    @SideOnly(value=Side.CLIENT)
    private ISound idleSound;

    public EntitySwarm(World world) {
        this(world, 1.0f);
    }

    public EntitySwarm(World world, float swarmSize) {
        super(world);
        this.setSwarmSize(swarmSize);
        this.field_70728_aV = 5;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SWARM_SIZE, (Object)Float.valueOf(1.0f));
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIMerge(this, 50, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 1, false, false, null));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(24.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    public float getSwarmSize() {
        return ((Float)this.field_70180_af.func_187225_a(SWARM_SIZE)).floatValue();
    }

    public void setSwarmSize(float swarmSize) {
        this.field_70180_af.func_187227_b(SWARM_SIZE, (Object)Float.valueOf(swarmSize));
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setSwarmSize(compound.func_74760_g("SwarmSize"));
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74776_a("SwarmSize", this.getSwarmSize());
    }

    public boolean func_70652_k(Entity entityIn) {
        return false;
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && super.func_70601_bi();
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity entityIn) {
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
                this.func_70106_y();
            }
            if (this.func_70027_ad() || this.func_70090_H()) {
                if (this.getSwarmSize() > 0.1f) {
                    this.setSwarmSize(Math.max(0.1f, this.getSwarmSize() - 0.005f));
                }
                if (this.func_70027_ad() && this.field_70146_Z.nextInt(10) == 0) {
                    List swarms = this.field_70170_p.func_175647_a(EntitySwarm.class, this.func_174813_aQ().func_186662_g(1.0), s -> !s.func_70027_ad());
                    for (EntitySwarm swarm : swarms) {
                        swarm.func_70015_d(2);
                    }
                }
            }
            float range = 3.25f;
            List players = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_186662_g((double)range));
            for (EntityPlayer player : players) {
                ISwarmedCapability cap;
                double dst = player.func_70032_d((Entity)this);
                if (!(dst < (double)range) || !this.func_70685_l((Entity)player) || (cap = (ISwarmedCapability)player.getCapability(CapabilityRegistry.CAPABILITY_SWARMED, null)) == null) continue;
                cap.setSwarmedStrength(cap.getSwarmedStrength() + (1.0f - (float)dst / range) * 0.025f * MathHelper.func_76131_a((float)(this.getSwarmSize() * 1.75f), (float)0.0f, (float)1.0f));
                cap.setDamage((float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
            }
        } else {
            this.updateClient();
        }
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76347_k()) {
            amount *= 2.0f;
        }
        boolean attacked = super.func_70097_a(source, amount);
        if (this.func_70089_S() && attacked && amount > 2.0f && (this.field_70146_Z.nextFloat() * 16.0f < amount || this.func_110143_aJ() < this.func_110138_aP() * 0.25f)) {
            this.split();
        }
        return attacked;
    }

    protected boolean split() {
        float swarmSize = this.getSwarmSize();
        if (swarmSize > 0.3f) {
            float initialSwarmSize = swarmSize;
            float fraction = initialSwarmSize * 0.25f + initialSwarmSize * (this.field_70146_Z.nextFloat() - 0.5f) * 0.05f;
            this.setSwarmSize(fraction);
            swarmSize -= fraction;
            for (int i = 0; i < 3; ++i) {
                fraction = i == 2 ? swarmSize : initialSwarmSize * 0.25f + initialSwarmSize * (this.field_70146_Z.nextFloat() - 0.5f) * 0.05f;
                EntitySwarm swarm = new EntitySwarm(this.field_70170_p, fraction);
                swarmSize -= fraction;
                swarm.func_70606_j(this.func_110143_aJ() * 0.66f);
                swarm.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
                if (this.func_70027_ad()) {
                    swarm.func_70015_d(40);
                }
                float mx = this.field_70146_Z.nextFloat() - 0.5f;
                float mz = this.field_70146_Z.nextFloat() - 0.5f;
                float len = MathHelper.func_76129_c((float)(mx * mx + mz * mz));
                swarm.field_70159_w = (mx /= len) * 0.5f;
                swarm.field_70181_x = 0.3f;
                swarm.field_70179_y = (mz /= len) * 0.5f;
                this.field_70170_p.func_72838_d((Entity)swarm);
            }
            this.func_70606_j(this.func_110143_aJ() * 0.5f);
            return true;
        }
        return false;
    }

    protected void mergeInto(EntitySwarm swarm) {
        swarm.setSwarmSize(swarm.getSwarmSize() + this.getSwarmSize());
        if (this.func_110143_aJ() < swarm.func_110143_aJ()) {
            swarm.func_70606_j((this.func_110143_aJ() / 0.66f + swarm.func_110143_aJ()) * 0.5f);
        }
        if (this.func_70027_ad()) {
            swarm.func_70015_d(2);
        }
        this.func_70106_y();
    }

    @SideOnly(value=Side.CLIENT)
    protected void updateClient() {
        Entity view = Minecraft.func_71410_x().func_175606_aa();
        if (view != null && view.func_70032_d((Entity)this) < 16.0f && !this.func_70090_H()) {
            SoundHandler handler = Minecraft.func_71410_x().func_147118_V();
            if (this.idleSound == null || !handler.func_147692_c(this.idleSound)) {
                this.idleSound = new EntitySound<Entity>(SoundRegistry.SWARM_IDLE, SoundCategory.HOSTILE, (Entity)this, e -> e.func_70089_S(), 0.8f);
                handler.func_147682_a(this.idleSound);
            }
            ArrayList<AxisAlignedBB> collisionBoxes = new ArrayList<AxisAlignedBB>();
            for (BlockPos offsetPos : BlockPos.func_177975_b((BlockPos)new BlockPos(MathHelper.func_76128_c((double)(this.field_70165_t - (double)this.field_70130_N - 2.0)), MathHelper.func_76128_c((double)(this.field_70163_u - 2.0)), MathHelper.func_76128_c((double)(this.field_70161_v - (double)this.field_70130_N - 2.0))), (BlockPos)new BlockPos(MathHelper.func_76128_c((double)(this.field_70165_t + (double)this.field_70130_N + 2.0)), MathHelper.func_76128_c((double)(this.field_70163_u + (double)this.field_70131_O + 2.0)), MathHelper.func_76128_c((double)(this.field_70161_v + (double)this.field_70130_N + 2.0))))) {
                IBlockState state = this.field_70170_p.func_180495_p(offsetPos);
                if (!state.func_185917_h()) continue;
                collisionBoxes.add(new AxisAlignedBB(offsetPos));
            }
            float swarmSize = this.getSwarmSize();
            int i = 0;
            while ((float)i < (float)Math.max(2 - Minecraft.func_71410_x().field_71474_y.field_74362_aa, 1) * swarmSize + 1.0f) {
                float rx = (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * this.field_70130_N;
                float ry = (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * this.field_70131_O;
                float rz = (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * this.field_70130_N;
                float len = MathHelper.func_76129_c((float)(rx * rx + ry * ry + rz * rz));
                rx /= len;
                ry /= len;
                rz /= len;
                len = 0.333f + this.field_70170_p.field_73012_v.nextFloat() * 0.666f;
                double x = this.field_70165_t + this.field_70159_w * 5.0 + (double)(rx * len * (this.field_70130_N + 0.3f) * swarmSize * 0.5f);
                double y = this.field_70163_u + this.field_70181_x * 5.0 - (double)(0.15f * swarmSize) + (double)((this.field_70131_O + 0.3f) * swarmSize * 0.5f) + (double)(ry * len * (this.field_70131_O + 0.3f) * swarmSize);
                double z = this.field_70161_v + this.field_70179_y * 5.0 + (double)(rz * len * (this.field_70130_N + 0.3f) * swarmSize * 0.5f);
                if (this.func_70027_ad() && this.field_70146_Z.nextInt(3) == 0) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.LAVA, x, y, z, 0.0, 0.0, 0.0, new int[0]);
                }
                if (this.field_70146_Z.nextInt(8) == 0) {
                    if (this.field_70146_Z.nextInt(3) == 0) {
                        BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.TRANSLUCENT_NEAREST_NEIGHBOR, BLParticles.FLYING_SWARM_EMISSIVE.create(this.field_70170_p, x, y, z));
                    } else {
                        BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.TRANSLUCENT_NEAREST_NEIGHBOR, BLParticles.FLY.create(this.field_70170_p, x, y, z, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withScale(0.15f * this.field_70170_p.field_73012_v.nextFloat() + 0.25f)).withData(40, Float.valueOf(0.01f), Float.valueOf(0.0025f), false)));
                    }
                } else {
                    AxisAlignedBB particle = new AxisAlignedBB(x - (double)0.01f, y - (double)0.01f, z - (double)0.01f, x + (double)0.01f, y + (double)0.01f, z + (double)0.01f);
                    double closestDst = 1.0;
                    double closestDX = 0.0;
                    double closestDY = 0.0;
                    double closestDZ = 0.0;
                    for (AxisAlignedBB box : collisionBoxes) {
                        double dx1 = box.func_72316_a(particle, -1.0);
                        double dy1 = box.func_72323_b(particle, -1.0);
                        double dz1 = box.func_72322_c(particle, -1.0);
                        double dx2 = box.func_72316_a(particle, 1.0);
                        double dy2 = box.func_72323_b(particle, 1.0);
                        double dz2 = box.func_72322_c(particle, 1.0);
                        if (Math.abs(dx1) < closestDst) {
                            closestDst = Math.abs(dx1);
                            closestDX = dx1;
                            closestDY = 0.0;
                            closestDZ = 0.0;
                        }
                        if (Math.abs(dy1) < closestDst) {
                            closestDst = Math.abs(dy1);
                            closestDX = 0.0;
                            closestDY = dy1;
                            closestDZ = 0.0;
                        }
                        if (Math.abs(dz1) < closestDst) {
                            closestDst = Math.abs(dz1);
                            closestDX = 0.0;
                            closestDY = 0.0;
                            closestDZ = dz1;
                        }
                        if (Math.abs(dx2) < closestDst) {
                            closestDst = Math.abs(dx2);
                            closestDX = dx2;
                            closestDY = 0.0;
                            closestDZ = 0.0;
                        }
                        if (Math.abs(dy2) < closestDst) {
                            closestDst = Math.abs(dy2);
                            closestDX = 0.0;
                            closestDY = dy2;
                            closestDZ = 0.0;
                        }
                        if (!(Math.abs(dz2) < closestDst)) continue;
                        closestDst = Math.abs(dz2);
                        closestDX = 0.0;
                        closestDY = 0.0;
                        closestDZ = dz2;
                    }
                    if (closestDst < 1.0) {
                        x += closestDX - Math.signum(closestDX) * (double)0.01f;
                        double ox = 1.0 - Math.abs(Math.signum(closestDX));
                        double oy = 1.0 - Math.abs(Math.signum(closestDY));
                        double oz = 1.0 - Math.abs(Math.signum(closestDZ));
                        BLParticles variant = this.field_70146_Z.nextInt(6) == 0 ? BLParticles.SWARM_EMISSIVE : BLParticles.SWARM;
                        BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.TRANSLUCENT_NEAREST_NEIGHBOR, variant.create(this.field_70170_p, x, y += closestDY - Math.signum(closestDY) * (double)0.01f, z += closestDZ - Math.signum(closestDZ) * (double)0.01f, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion((double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.05f) * ox, (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.05f) * oy, (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.05f) * oz)).withScale(0.25f)).withData(EnumFacing.func_176737_a((float)((float)(-closestDX)), (float)((float)(-closestDY)), (float)((float)(-closestDZ))), 40, this.func_174791_d(), () -> this.func_174791_d())));
                    }
                }
                ++i;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }

    public static class AIMerge
    extends EntityAIBase {
        private final EntitySwarm entity;
        private int delay;
        private double speedTowardsTarget;
        private EntitySwarm leader;
        private int delayCounter;
        private int failedPathFindingPenalty = 0;

        public AIMerge(EntitySwarm entity, int delay, double speed) {
            this.entity = entity;
            this.delay = delay;
            this.speedTowardsTarget = speed;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            EntitySwarm leader;
            if (this.entity.getSwarmSize() < 0.9f && this.delay-- <= 0 && (leader = this.findLeader()) != null && leader != this.entity) {
                this.leader = leader;
                return true;
            }
            return false;
        }

        @Nullable
        private EntitySwarm findLeader() {
            List swarms = this.entity.field_70170_p.func_72872_a(EntitySwarm.class, this.entity.func_174813_aQ().func_186662_g(8.0));
            int minId = Integer.MAX_VALUE;
            EntitySwarm leader = null;
            for (EntitySwarm swarm : swarms) {
                if (swarm.func_145782_y() >= minId || !(swarm.getSwarmSize() + this.entity.getSwarmSize() <= 1.0f)) continue;
                minId = swarm.func_145782_y();
                leader = swarm;
            }
            return leader;
        }

        public boolean func_75253_b() {
            return this.leader != null && this.leader.func_70089_S() && this.leader.getSwarmSize() + this.entity.getSwarmSize() <= 1.0f;
        }

        public void func_75251_c() {
            this.leader = null;
            this.delayCounter = 0;
        }

        public void func_75246_d() {
            if (this.leader != null) {
                if (this.leader.func_70032_d((Entity)this.entity) < 1.0f) {
                    this.entity.mergeInto(this.leader);
                } else if (--this.delayCounter <= 0) {
                    this.delayCounter = 4 + this.entity.func_70681_au().nextInt(7);
                    double dstSq = this.entity.func_70092_e(this.leader.field_70165_t, this.leader.func_174813_aQ().field_72338_b, this.leader.field_70161_v);
                    if (dstSq > 1024.0) {
                        this.delayCounter += 10;
                    } else if (dstSq > 256.0) {
                        this.delayCounter += 5;
                    }
                    if (!this.entity.func_70661_as().func_75497_a((Entity)this.leader, this.speedTowardsTarget)) {
                        this.delayCounter += 15;
                    }
                }
            }
        }
    }
}

