/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import java.util.List;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.entity.WeedWoodBushUncollidableEntity;
import thebetweenlands.common.entity.ai.EntityAISeekRainShelter;
import thebetweenlands.common.entity.ai.gecko.EntityAIAvoidEntityGecko;
import thebetweenlands.common.entity.ai.gecko.EntityAIGeckoHideFromRain;
import thebetweenlands.common.network.clientbound.MessageWeedwoodBushRustle;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityGecko
extends EntityCreature
implements IEntityBL,
WeedWoodBushUncollidableEntity {
    private static final DataParameter<Boolean> HIDING = EntityDataManager.func_187226_a(EntityGecko.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final int MIN_HIDE_TIME = 2400;
    private static final float UNHIDE_CHANCE = 0.1f;
    private static final int PLAYER_MIN_DISTANCE = 7;
    private BlockPos hidingBush;
    private int timeHiding;

    public EntityGecko(World worldObj) {
        super(worldObj);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.func_70105_a(0.75f, 0.35f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAITempt((EntityCreature)this, 0.5, ItemRegistry.SAP_SPIT, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntityGecko(this, EntityPlayer.class, 7.0f, 0.65, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIGeckoHideFromRain(this, 0.65));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAISeekRainShelter(this, 0.65));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    public float func_180484_a(BlockPos pos) {
        return this.field_70170_p.func_175727_C(pos) ? -1.0f : 0.0f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HIDING, (Object)false);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(12.0);
    }

    public void setHidingBush(BlockPos pos) {
        this.hidingBush = pos;
    }

    public boolean func_82150_aj() {
        return this.isHiding() || super.func_82150_aj();
    }

    private void setHiding(boolean isHiding) {
        this.field_70180_af.func_187227_b(HIDING, (Object)isHiding);
    }

    public void startHiding() {
        this.setHiding(true);
        this.func_184185_a(SoundRegistry.GECKO_HIDE, 0.5f, this.field_70146_Z.nextFloat() * 0.3f + 0.9f);
        this.sendRustleEffect(1.0f);
        this.func_70107_b((double)this.hidingBush.func_177958_n() + 0.5, this.hidingBush.func_177956_o(), (double)this.hidingBush.func_177952_p() + 0.5);
        this.timeHiding = 0;
    }

    public void stopHiding() {
        this.setHiding(false);
        this.func_184185_a(SoundRegistry.GECKO_HIDE, 0.25f, this.field_70146_Z.nextFloat() * 0.3f + 0.9f);
        this.timeHiding = 0;
        float x = this.field_70146_Z.nextFloat() * 2.0f - 1.0f;
        float y = this.field_70146_Z.nextFloat() * 0.5f;
        float z = this.field_70146_Z.nextFloat() * 2.0f - 1.0f;
        float len = MathHelper.func_76129_c((float)(x * x + y * y + z * z));
        float mag = 0.6f;
        this.field_70159_w += (double)(x / len * mag);
        this.field_70181_x += (double)(y / len * mag);
        this.field_70179_y += (double)(z / len * mag);
    }

    private boolean hasValidHiding() {
        return this.field_70170_p.func_180495_p(this.hidingBush).func_177230_c() == BlockRegistry.WEEDWOOD_BUSH;
    }

    private void sendRustleEffect(float strength) {
        if (!this.hasValidHiding()) {
            return;
        }
        MessageWeedwoodBushRustle message = new MessageWeedwoodBushRustle(this.hidingBush, strength);
        NetworkRegistry.TargetPoint target = new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 16.0);
        TheBetweenlands.networkWrapper.sendToAllAround((IMessage)message, target);
    }

    public boolean isHiding() {
        return (Boolean)this.field_70180_af.func_187225_a(HIDING);
    }

    public void func_70091_d(MoverType moverType, double motionX, double motionY, double motionZ) {
        if (!this.isHiding()) {
            super.func_70091_d(moverType, motionX, motionY, motionZ);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.isHiding()) {
            if (this.hasValidHiding()) {
                List players;
                ++this.timeHiding;
                if (this.field_70146_Z.nextFloat() < 0.01f) {
                    this.func_184185_a(SoundRegistry.GECKO_HIDE, this.field_70146_Z.nextFloat() * 0.05f + 0.02f, this.field_70146_Z.nextFloat() * 0.2f + 0.8f);
                    if (this.field_70146_Z.nextFloat() < 0.3f) {
                        this.sendRustleEffect((this.field_70146_Z.nextFloat() + 0.2f) * 0.06f);
                    }
                }
                if (this.timeHiding > 2400 && (players = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(7.0, 7.0, 7.0))).size() < 1 && this.field_70146_Z.nextFloat() < 0.1f) {
                    this.stopHiding();
                }
            } else {
                this.stopHiding();
            }
        }
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && stack.func_77973_b() == ItemRegistry.SAP_SPIT && this.func_110143_aJ() < this.func_110138_aP()) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70691_i(this.func_110138_aP());
            } else {
                this.spawnHeartParticles();
            }
            player.func_184609_a(hand);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    protected void spawnHeartParticles() {
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(EnumParticleTypes.HEART, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    protected float func_70599_aP() {
        return this.isHiding() ? super.func_70599_aP() * 0.1f : super.func_70599_aP();
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.GECKO_LIVING;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundRegistry.GECKO_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.GECKO_DEATH;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("isHiding", this.isHiding());
        if (this.isHiding()) {
            compound.func_74768_a("hidingBushX", this.hidingBush.func_177958_n());
            compound.func_74768_a("hidingBushY", this.hidingBush.func_177956_o());
            compound.func_74768_a("hidingBushZ", this.hidingBush.func_177952_p());
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("isHiding")) {
            this.setHiding(compound.func_74767_n("isHiding"));
            if (this.isHiding()) {
                this.setHidingBush(new BlockPos(compound.func_74762_e("hidingBushX"), compound.func_74762_e("hidingBushY"), compound.func_74762_e("hidingBushZ")));
            }
        }
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.isHiding();
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.GECKO;
    }

    protected int func_70693_a(EntityPlayer player) {
        return 1 + this.field_70146_Z.nextInt(3);
    }
}

