/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.api.entity.IPullerEntityProvider;
import thebetweenlands.common.entity.ai.EntityAIFlyingWander;
import thebetweenlands.common.entity.ai.EntityAISeekRainShelter;
import thebetweenlands.common.entity.draeton.DraetonPhysicsPart;
import thebetweenlands.common.entity.draeton.EntityDraeton;
import thebetweenlands.common.entity.draeton.EntityPullerFirefly;
import thebetweenlands.common.entity.mobs.EntityFlyingCreature;
import thebetweenlands.common.entity.movement.FlightMoveHelper;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;

public class EntityFirefly
extends EntityFlyingCreature
implements IEntityBL,
IPullerEntityProvider<EntityPullerFirefly> {
    public static final IAttribute GLOW_STRENGTH_ATTRIB = new RangedAttribute(null, "bl.fireflyGlowStrength", 1.0, 0.0, 8.0).func_111117_a("Firefly glow strength").func_111112_a(true);
    public static final IAttribute GLOW_START_CHANCE = new RangedAttribute(null, "bl.fireflyGlowStartChance", 0.0025, 0.0, 1.0).func_111117_a("Firefly glow start chance per tick");
    public static final IAttribute GLOW_STOP_CHANCE = new RangedAttribute(null, "bl.fireflyGlowStopChance", 8.3E-4, 0.0, 1.0).func_111117_a("Firefly glow stop chance per tick");
    private static final DataParameter<Float> GLOW_STRENGTH = EntityDataManager.func_187226_a(EntityFirefly.class, (DataSerializer)DataSerializers.field_187193_c);
    protected int glowTicks = 0;
    protected int prevGlowTicks = 0;

    public EntityFirefly(World world) {
        super(world);
        this.func_70105_a(0.6f, 0.6f);
        this.field_70158_ak = true;
        this.field_70765_h = new FlightMoveHelper((EntityLiving)this);
        this.func_184644_a(PathNodeType.WATER, -8.0f);
        this.func_184644_a(PathNodeType.BLOCKED, -8.0f);
        this.func_184644_a(PathNodeType.OPEN, 8.0f);
    }

    public float func_180484_a(BlockPos pos) {
        return this.field_70170_p.func_175727_C(pos) ? -1.0f : 0.0f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISeekRainShelter(this, 0.8));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFlyingWander(this, 0.5));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.035);
        this.func_110140_aT().func_111150_b(GLOW_STRENGTH_ATTRIB);
        this.func_110140_aT().func_111150_b(GLOW_START_CHANCE);
        this.func_110140_aT().func_111150_b(GLOW_STOP_CHANCE);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(GLOW_STRENGTH, (Object)Float.valueOf((float)GLOW_STRENGTH_ATTRIB.func_111110_b()));
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.FIREFLY;
    }

    public int func_70641_bl() {
        return 1;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_130014_f_().func_180495_p(this.func_180425_c().func_177977_b()).isSideSolid((IBlockAccess)this.func_130014_f_(), this.func_180425_c().func_177977_b(), EnumFacing.UP)) {
            this.func_70605_aq().func_75642_a(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 0.32);
        }
        this.prevGlowTicks = this.glowTicks;
        if (this.func_70089_S()) {
            if (!this.field_70170_p.field_72995_K) {
                if (!this.isGlowActive() && this.field_70146_Z.nextDouble() < this.func_110148_a(GLOW_START_CHANCE).func_111126_e()) {
                    this.setGlowStrength(this.func_110148_a(GLOW_STRENGTH_ATTRIB).func_111126_e());
                } else if (this.isGlowActive() && this.field_70146_Z.nextDouble() < this.func_110148_a(GLOW_STOP_CHANCE).func_111126_e()) {
                    this.setGlowStrength(0.0);
                }
            }
            if (this.isGlowActive() && this.glowTicks < 20) {
                ++this.glowTicks;
            } else if (!this.isGlowActive() && this.glowTicks > 0) {
                --this.glowTicks;
            }
        } else {
            this.setGlowStrength(0.0);
            this.glowTicks = 0;
        }
    }

    protected boolean func_70692_ba() {
        return true;
    }

    public boolean func_70601_bi() {
        float brightness = this.field_70170_p.field_73011_w.getSunBrightnessFactor(1.0f);
        return (brightness <= 0.3f || BetweenlandsWorldStorage.forWorld((World)this.field_70170_p).getEnvironmentEventRegistry().bloodSky.isActive()) && super.func_70601_bi();
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74780_a("glowStrength", this.getGlowStrength());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setGlowStrength(nbt.func_74769_h("glowStrength"));
    }

    public boolean isGlowActive() {
        return this.getGlowStrength() > 0.0;
    }

    public double getGlowStrength() {
        return ((Float)this.func_184212_Q().func_187225_a(GLOW_STRENGTH)).floatValue();
    }

    public void setGlowStrength(double strength) {
        this.func_184212_Q().func_187227_b(GLOW_STRENGTH, (Object)Float.valueOf((float)strength));
    }

    public float getGlowTicks(float partialTicks) {
        return (float)this.prevGlowTicks + (float)(this.glowTicks - this.prevGlowTicks) * partialTicks;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    @Override
    public EntityPullerFirefly createPuller(EntityDraeton draeton, DraetonPhysicsPart puller) {
        return new EntityPullerFirefly(draeton.field_70170_p, draeton, puller);
    }
}

