/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import com.google.common.base.Optional;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.common.entity.movement.ClimberMoveHelper;
import thebetweenlands.common.entity.movement.IPathObstructionAwareEntity;
import thebetweenlands.common.entity.movement.ObstructionAwarePathNavigateClimber;
import thebetweenlands.util.BoxSmoothingUtil;
import thebetweenlands.util.Matrix;

public abstract class EntityClimberBase
extends EntityCreature
implements IEntityBL,
IPathObstructionAwareEntity {
    public static final DataParameter<Optional<BlockPos>> PATHING_TARGET = EntityDataManager.func_187226_a(EntityClimberBase.class, (DataSerializer)DataSerializers.field_187201_k);
    public double prevStickingOffsetX;
    public double prevStickingOffsetY;
    public double prevStickingOffsetZ;
    public double stickingOffsetX;
    public double stickingOffsetY;
    public double stickingOffsetZ;
    public Vec3d orientationNormal = new Vec3d(0.0, 1.0, 0.0);
    public Vec3d prevOrientationNormal = new Vec3d(0.0, 1.0, 0.0);
    protected float collisionsInclusionRange = 2.0f;
    protected float collisionsSmoothingRange = 1.25f;
    protected Vec3d attachedSides = new Vec3d(0.0, 0.0, 0.0);
    protected Vec3d prevAttachedSides = new Vec3d(0.0, 0.0, 0.0);

    public EntityClimberBase(World world) {
        super(world);
        this.func_70105_a(0.85f, 0.85f);
        this.field_70765_h = new ClimberMoveHelper(this);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PATHING_TARGET, (Object)Optional.absent());
    }

    protected PathNavigate func_175447_b(World worldIn) {
        ObstructionAwarePathNavigateClimber<EntityClimberBase> navigate = new ObstructionAwarePathNavigateClimber<EntityClimberBase>(this, worldIn, false, true, true);
        navigate.func_179693_d(true);
        return navigate;
    }

    @Override
    public float getBridgePathingMalus(EntityLiving entity, BlockPos pos, PathPoint fallPathPoint) {
        return -1.0f;
    }

    @Override
    public void onPathingObstructed(EnumFacing facing) {
    }

    public int func_82143_as() {
        return 0;
    }

    public float getMovementSpeed() {
        IAttributeInstance attribute = this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d);
        return attribute != null ? (float)attribute.func_111126_e() : 1.0f;
    }

    public Pair<EnumFacing, Vec3d> getWalkingSide() {
        int index;
        EnumFacing avoidPathingFacing = null;
        Path path = this.func_70661_as().func_75505_d();
        if (path != null && (index = path.func_75873_e()) < path.func_75874_d()) {
            PathPoint point = path.func_75877_a(index);
            double maxDist = 0.0;
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                double dist;
                double posEntity = (double)Math.abs(facing.func_82601_c()) * this.field_70165_t + (double)Math.abs(facing.func_96559_d()) * this.field_70163_u + (double)Math.abs(facing.func_82599_e()) * this.field_70161_v;
                double posPath = Math.abs(facing.func_82601_c()) * point.field_75839_a + Math.abs(facing.func_96559_d()) * point.field_75837_b + Math.abs(facing.func_82599_e()) * point.field_75838_c;
                double distSigned = posPath + 0.5 - posEntity;
                if (!(distSigned * (double)(facing.func_82601_c() + facing.func_96559_d() + facing.func_82599_e()) > 0.0) || !((dist = Math.abs(distSigned) - (double)(facing.func_176740_k().func_176722_c() ? this.field_70130_N / 2.0f : (facing == EnumFacing.DOWN ? 0.0f : this.field_70131_O))) > maxDist)) continue;
                maxDist = dist;
                avoidPathingFacing = dist < (double)1.732f ? facing.func_176734_d() : null;
            }
        }
        AxisAlignedBB entityBox = this.func_174813_aQ();
        double closestFacingDst = Double.MAX_VALUE;
        EnumFacing closestFacing = null;
        Vec3d weighting = new Vec3d(0.0, 0.0, 0.0);
        float stickingDistance = this.field_191988_bg != 0.0f ? 1.5f : 0.1f;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (avoidPathingFacing == facing) continue;
            List collisionBoxes = this.field_70170_p.func_184144_a((Entity)this, entityBox.func_186662_g((double)0.2f).func_72321_a((double)((float)facing.func_82601_c() * stickingDistance), (double)((float)facing.func_96559_d() * stickingDistance), (double)((float)facing.func_82599_e() * stickingDistance)));
            double closestDst = Double.MAX_VALUE;
            for (AxisAlignedBB collisionBox : collisionBoxes) {
                switch (facing) {
                    case EAST: 
                    case WEST: {
                        closestDst = Math.min(closestDst, Math.abs(entityBox.func_72316_a(collisionBox, (double)((float)(-facing.func_82601_c()) * stickingDistance))));
                        break;
                    }
                    case UP: 
                    case DOWN: {
                        closestDst = Math.min(closestDst, Math.abs(entityBox.func_72323_b(collisionBox, (double)((float)(-facing.func_96559_d()) * stickingDistance))));
                        break;
                    }
                    case NORTH: 
                    case SOUTH: {
                        closestDst = Math.min(closestDst, Math.abs(entityBox.func_72322_c(collisionBox, (double)((float)(-facing.func_82599_e()) * stickingDistance))));
                    }
                }
            }
            if (closestDst < closestFacingDst) {
                closestFacingDst = closestDst;
                closestFacing = facing;
            }
            if (!(closestDst < Double.MAX_VALUE)) continue;
            weighting = weighting.func_178787_e(new Vec3d((double)facing.func_82601_c(), (double)facing.func_96559_d(), (double)facing.func_82599_e()).func_186678_a(1.0 - Math.min(closestDst, (double)stickingDistance) / (double)stickingDistance));
        }
        if (closestFacing == null) {
            return Pair.of((Object)EnumFacing.DOWN, (Object)new Vec3d(0.0, -1.0, 0.0));
        }
        return Pair.of(closestFacing, (Object)weighting.func_72432_b().func_72441_c(0.0, (double)-0.001f, 0.0).func_72432_b());
    }

    public Orientation getOrientation(float partialTicks) {
        Vec3d orientationNormal = this.prevOrientationNormal.func_178787_e(this.orientationNormal.func_178788_d(this.prevOrientationNormal).func_186678_a((double)partialTicks));
        Vec3d fwdAxis = new Vec3d(0.0, 0.0, 1.0);
        Vec3d upAxis = new Vec3d(0.0, 1.0, 0.0);
        Vec3d rightAxis = new Vec3d(1.0, 0.0, 0.0);
        float fwd = (float)fwdAxis.func_72430_b(orientationNormal);
        float up = (float)upAxis.func_72430_b(orientationNormal);
        float right = (float)rightAxis.func_72430_b(orientationNormal);
        float yaw = (float)Math.toDegrees(Math.atan2(right, fwd));
        fwdAxis = new Vec3d(Math.sin(Math.toRadians(yaw)), 0.0, Math.cos(Math.toRadians(yaw)));
        upAxis = new Vec3d(0.0, 1.0, 0.0);
        rightAxis = new Vec3d(Math.sin(Math.toRadians(yaw - 90.0f)), 0.0, Math.cos(Math.toRadians(yaw - 90.0f)));
        fwd = (float)fwdAxis.func_72430_b(orientationNormal);
        up = (float)upAxis.func_72430_b(orientationNormal);
        right = (float)rightAxis.func_72430_b(orientationNormal);
        float pitch = (float)Math.toDegrees(Math.atan2(fwd, up)) * Math.signum(fwd);
        Matrix m = new Matrix();
        m.rotate(Math.toRadians(yaw), 0.0, 1.0, 0.0);
        m.rotate(Math.toRadians(pitch), 1.0, 0.0, 0.0);
        m.rotate(Math.toRadians(Math.signum(0.1f - up) * yaw), 0.0, 1.0, 0.0);
        Vec3d localFwd = m.transform(new Vec3d(0.0, 0.0, -1.0));
        Vec3d localUp = m.transform(new Vec3d(0.0, 1.0, 0.0));
        Vec3d localRight = m.transform(new Vec3d(1.0, 0.0, 0.0));
        return new Orientation(orientationNormal, localFwd, localUp, localRight, fwd, up, right, yaw, pitch);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            Path path = this.func_70661_as().func_75505_d();
            if (path != null && path.func_75873_e() < path.func_75874_d()) {
                PathPoint point = path.func_75877_a(path.func_75873_e());
                this.field_70180_af.func_187227_b(PATHING_TARGET, (Object)Optional.of((Object)new BlockPos(point.field_75839_a, point.field_75837_b, point.field_75838_c)));
            } else {
                this.field_70180_af.func_187227_b(PATHING_TARGET, (Object)Optional.absent());
            }
        }
    }

    @Nullable
    public BlockPos getPathingTarget() {
        return (BlockPos)((Optional)this.field_70180_af.func_187225_a(PATHING_TARGET)).orNull();
    }

    protected boolean canAttachToWalls() {
        return !this.func_70090_H();
    }

    protected void updateOffsetsAndOrientation() {
        Vec3d p = this.func_174791_d();
        Vec3d s = p.func_72441_c(0.0, (double)(this.field_70131_O / 2.0f), 0.0);
        AxisAlignedBB inclusionBox = new AxisAlignedBB(s.field_72450_a, s.field_72448_b, s.field_72449_c, s.field_72450_a, s.field_72448_b, s.field_72449_c).func_186662_g((double)this.collisionsInclusionRange);
        List boxes = this.field_70170_p.func_184144_a((Entity)this, inclusionBox);
        this.prevOrientationNormal = this.orientationNormal;
        this.prevStickingOffsetX = this.stickingOffsetX;
        this.prevStickingOffsetY = this.stickingOffsetY;
        this.prevStickingOffsetZ = this.stickingOffsetZ;
        Pair<Vec3d, Vec3d> closestSmoothPoint = null;
        if (this.canAttachToWalls()) {
            closestSmoothPoint = BoxSmoothingUtil.findClosestSmoothPoint(boxes, this.collisionsSmoothingRange, 1.0f, 0.005f, 20, 0.05f, s);
        }
        if (closestSmoothPoint != null) {
            this.stickingOffsetX = MathHelper.func_151237_a((double)(((Vec3d)closestSmoothPoint.getLeft()).field_72450_a - p.field_72450_a), (double)(-this.field_70130_N / 2.0f), (double)(this.field_70130_N / 2.0f));
            this.stickingOffsetY = MathHelper.func_151237_a((double)(((Vec3d)closestSmoothPoint.getLeft()).field_72448_b - p.field_72448_b), (double)0.0, (double)this.field_70131_O);
            this.stickingOffsetZ = MathHelper.func_151237_a((double)(((Vec3d)closestSmoothPoint.getLeft()).field_72449_c - p.field_72449_c), (double)(-this.field_70130_N / 2.0f), (double)(this.field_70130_N / 2.0f));
            this.orientationNormal = (Vec3d)closestSmoothPoint.getRight();
        } else {
            this.stickingOffsetX *= (double)0.6f;
            this.stickingOffsetY += ((double)0.4f - this.stickingOffsetY) * (double)0.6f;
            this.stickingOffsetZ *= (double)0.6f;
            this.orientationNormal = new Vec3d(this.orientationNormal.field_72450_a * (double)0.6f, this.orientationNormal.field_72448_b + (1.0 - this.orientationNormal.field_72448_b) * (double)0.4f, this.orientationNormal.field_72449_c * (double)0.6f).func_72432_b();
        }
    }

    public Vec3d getStickingForce(Pair<EnumFacing, Vec3d> walkingSide) {
        if (!this.func_189652_ae()) {
            return ((Vec3d)walkingSide.getRight()).func_186678_a((double)0.08f);
        }
        return new Vec3d(0.0, 0.0, 0.0);
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        Orientation orientation = this.getOrientation(1.0f);
        Vec3d forwardVector = orientation.getForward(this.field_70177_z, 0.0f);
        Vec3d upVector = orientation.getForward(this.field_70177_z, -90.0f);
        if (this.func_70090_H()) {
            super.func_191986_a(strafe, vertical, forward);
        } else if (this.func_70613_aW() || this.func_184186_bw()) {
            boolean detachedZ;
            Pair<EnumFacing, Vec3d> walkingSide = this.getWalkingSide();
            Vec3d stickingForce = this.getStickingForce(walkingSide);
            if (forward != 0.0f) {
                float slipperiness = 0.91f;
                if (this.field_70122_E) {
                    BlockPos offsetPos = new BlockPos((Entity)this).func_177972_a((EnumFacing)walkingSide.getLeft());
                    IBlockState offsetState = this.field_70170_p.func_180495_p(offsetPos);
                    slipperiness = offsetState.func_177230_c().getSlipperiness(offsetState, (IBlockAccess)this.field_70170_p, offsetPos, (Entity)this) * 0.91f;
                }
                float friction = forward * 0.16277136f / (slipperiness * slipperiness * slipperiness);
                float f = forward * forward;
                if (f >= 1.0E-4f) {
                    boolean isInnerCorner;
                    f = Math.max(MathHelper.func_76129_c((float)f), 1.0f);
                    f = friction / f;
                    Vec3d forwardOffset = new Vec3d(forwardVector.field_72450_a * (double)forward * (double)f, forwardVector.field_72448_b * (double)forward * (double)f, forwardVector.field_72449_c * (double)forward * (double)f);
                    double px = this.field_70165_t;
                    double py = this.field_70163_u;
                    double pz = this.field_70161_v;
                    double mx = this.field_70159_w;
                    double my = this.field_70181_x;
                    double mz = this.field_70179_y;
                    AxisAlignedBB aabb = this.func_174813_aQ();
                    this.func_70091_d(MoverType.SELF, forwardOffset.field_72450_a, forwardOffset.field_72448_b, forwardOffset.field_72449_c);
                    Vec3d movementDir = new Vec3d(this.field_70165_t - px, this.field_70163_u - py, this.field_70161_v - pz).func_72432_b();
                    this.func_174826_a(aabb);
                    this.func_174829_m();
                    this.field_70159_w = mx;
                    this.field_70181_x = my;
                    this.field_70179_y = mz;
                    Vec3d probeVector = new Vec3d(Math.abs(movementDir.field_72450_a) < 0.001 ? -Math.signum(upVector.field_72450_a) : 0.0, Math.abs(movementDir.field_72448_b) < 0.001 ? -Math.signum(upVector.field_72448_b) : 0.0, Math.abs(movementDir.field_72449_c) < 0.001 ? -Math.signum(upVector.field_72449_c) : 0.0).func_72432_b().func_186678_a(1.0E-4);
                    this.func_70091_d(MoverType.SELF, probeVector.field_72450_a, probeVector.field_72448_b, probeVector.field_72449_c);
                    Vec3d collisionNormal = new Vec3d(Math.abs(this.field_70165_t - px - probeVector.field_72450_a) > 1.0E-6 ? Math.signum(-probeVector.field_72450_a) : 0.0, Math.abs(this.field_70163_u - py - probeVector.field_72448_b) > 1.0E-6 ? Math.signum(-probeVector.field_72448_b) : 0.0, Math.abs(this.field_70161_v - pz - probeVector.field_72449_c) > 1.0E-6 ? Math.signum(-probeVector.field_72449_c) : 0.0).func_72432_b();
                    this.func_174826_a(aabb);
                    this.func_174829_m();
                    this.field_70159_w = mx;
                    this.field_70181_x = my;
                    this.field_70179_y = mz;
                    Vec3d surfaceMovementDir = movementDir.func_178788_d(collisionNormal.func_186678_a(collisionNormal.func_72430_b(movementDir))).func_72432_b();
                    boolean bl = isInnerCorner = Math.abs(collisionNormal.field_72450_a) + Math.abs(collisionNormal.field_72448_b) + Math.abs(collisionNormal.field_72449_c) > (double)1.0001f;
                    if (!isInnerCorner) {
                        movementDir = surfaceMovementDir;
                    }
                    stickingForce = stickingForce.func_178788_d(surfaceMovementDir.func_186678_a(surfaceMovementDir.func_72432_b().func_72430_b(stickingForce)));
                    float moveSpeed = forward * f;
                    this.field_70159_w += movementDir.field_72450_a * (double)moveSpeed;
                    this.field_70181_x += movementDir.field_72448_b * (double)moveSpeed;
                    this.field_70179_y += movementDir.field_72449_c * (double)moveSpeed;
                }
            }
            this.field_70159_w += stickingForce.field_72450_a;
            this.field_70181_x += stickingForce.field_72448_b;
            this.field_70179_y += stickingForce.field_72449_c;
            double px = this.field_70165_t;
            double py = this.field_70163_u;
            double pz = this.field_70161_v;
            double mx = this.field_70159_w;
            double my = this.field_70181_x;
            double mz = this.field_70179_y;
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.prevAttachedSides = this.attachedSides;
            this.attachedSides = new Vec3d(this.field_70165_t == px ? -Math.signum(mx) : 0.0, this.field_70163_u == py ? -Math.signum(my) : 0.0, this.field_70161_v == pz ? -Math.signum(mz) : 0.0);
            boolean detachedX = this.attachedSides.field_72450_a != this.prevAttachedSides.field_72450_a;
            boolean detachedY = this.attachedSides.field_72448_b != this.prevAttachedSides.field_72448_b;
            boolean bl = detachedZ = this.attachedSides.field_72449_c != this.prevAttachedSides.field_72449_c;
            if (detachedX || detachedY || detachedZ) {
                this.func_70091_d(MoverType.SELF, detachedX ? -this.prevAttachedSides.field_72450_a * 0.25 : 0.0, detachedY ? -this.prevAttachedSides.field_72448_b * 0.25 : 0.0, detachedZ ? -this.prevAttachedSides.field_72449_c * 0.25 : 0.0);
                Vec3d axis = this.prevAttachedSides.func_72432_b();
                Vec3d attachVector = upVector.func_186678_a(-1.0);
                attachVector = attachVector.func_178788_d(axis.func_186678_a(axis.func_72430_b(attachVector))).func_72432_b();
                double attachDst = MathHelper.func_76133_a((double)(mx * mx + my * my + mz * mz)) + 0.1f;
                AxisAlignedBB aabb = this.func_174813_aQ();
                mx = this.field_70159_w;
                my = this.field_70181_x;
                mz = this.field_70179_y;
                for (int i = 0; i < 10 && !this.field_70122_E; ++i) {
                    this.func_70091_d(MoverType.SELF, attachVector.field_72450_a * attachDst, attachVector.field_72448_b * attachDst, attachVector.field_72449_c * attachDst);
                }
                if (!this.field_70122_E) {
                    this.func_174826_a(aabb);
                    this.func_174829_m();
                    this.field_70159_w = mx;
                    this.field_70181_x = my;
                    this.field_70179_y = mz;
                }
                this.field_70179_y = 0.0;
                this.field_70181_x = 0.0;
                this.field_70159_w = 0.0;
            }
            float slipperiness = 0.91f;
            if (this.field_70122_E) {
                this.field_70143_R = 0.0f;
                BlockPos offsetPos = new BlockPos((Entity)this).func_177972_a((EnumFacing)walkingSide.getLeft());
                IBlockState offsetState = this.field_70170_p.func_180495_p(offsetPos);
                slipperiness = offsetState.func_177230_c().getSlipperiness(offsetState, (IBlockAccess)this.field_70170_p, offsetPos, (Entity)this) * 0.91f;
            }
            Vec3d motion = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            Vec3d orthogonalMotion = upVector.func_186678_a(upVector.func_72430_b(motion));
            Vec3d tangentialMotion = motion.func_178788_d(orthogonalMotion);
            this.field_70159_w = tangentialMotion.field_72450_a * (double)slipperiness + orthogonalMotion.field_72450_a * (double)0.98f;
            this.field_70181_x = tangentialMotion.field_72448_b * (double)slipperiness + orthogonalMotion.field_72448_b * (double)0.98f;
            this.field_70179_y = tangentialMotion.field_72449_c * (double)slipperiness + orthogonalMotion.field_72449_c * (double)0.98f;
        }
        this.updateOffsetsAndOrientation();
        orientation = this.getOrientation(1.0f);
        float rx = (float)orientation.forward.func_72430_b(forwardVector);
        float ry = (float)orientation.right.func_72430_b(forwardVector);
        this.field_70177_z = MathHelper.func_76142_g((float)(270.0f - (float)Math.toDegrees(Math.atan2(rx, ry))));
        this.field_184618_aE = this.field_70721_aZ;
        double traveledX = this.field_70165_t - this.field_70169_q;
        double traveledY = this.field_70163_u - this.field_70167_r;
        double traveledZ = this.field_70161_v - this.field_70166_s;
        float traveled = Math.min(MathHelper.func_76133_a((double)(traveledX * traveledX + traveledY * traveledY + traveledZ * traveledZ)) * 4.0f, 1.0f);
        this.field_70721_aZ += (traveled - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        double py = this.field_70163_u;
        super.func_70091_d(type, x, y, z);
        if (Math.abs(this.field_70163_u - py - y) > 1.0E-6) {
            this.field_70181_x = 0.0;
        }
        this.field_70122_E = this.field_70132_H;
    }

    public static class Orientation {
        public final Vec3d normal;
        public final Vec3d forward;
        public final Vec3d up;
        public final Vec3d right;
        public final float forwardComponent;
        public final float upComponent;
        public final float rightComponent;
        public final float yaw;
        public final float pitch;

        private Orientation(Vec3d normal, Vec3d forward, Vec3d up, Vec3d right, float forwardComponent, float upComponent, float rightComponent, float yaw, float pitch) {
            this.normal = normal;
            this.forward = forward;
            this.up = up;
            this.right = right;
            this.forwardComponent = forwardComponent;
            this.upComponent = upComponent;
            this.rightComponent = rightComponent;
            this.yaw = yaw;
            this.pitch = pitch;
        }

        public Vec3d getForward(float yaw, float pitch) {
            float cosYaw = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180)));
            float sinYaw = MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180)));
            float cosPitch = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
            float sinPitch = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
            return this.right.func_186678_a((double)(sinYaw * cosPitch)).func_178787_e(this.up.func_186678_a((double)sinPitch)).func_178787_e(this.forward.func_186678_a((double)(cosYaw * cosPitch)));
        }
    }
}

