/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketSetPassengers;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.IPullerEntity;
import thebetweenlands.api.entity.IPullerEntityProvider;
import thebetweenlands.api.entity.IRingOfGatheringMinion;
import thebetweenlands.api.item.IEquippable;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.entity.EntityTameableBL;
import thebetweenlands.common.entity.ai.EntityAIFlyingWander;
import thebetweenlands.common.entity.ai.EntityAISitBL;
import thebetweenlands.common.entity.draeton.DraetonPhysicsPart;
import thebetweenlands.common.entity.draeton.EntityDraeton;
import thebetweenlands.common.entity.draeton.EntityPullerChiromaw;
import thebetweenlands.common.entity.movement.FlightMoveHelper;
import thebetweenlands.common.entity.movement.PathNavigateFlyingBL;
import thebetweenlands.common.entity.projectiles.EntityBLArrow;
import thebetweenlands.common.item.tools.bow.EnumArrowType;
import thebetweenlands.common.network.serverbound.MessageChiromawDoubleJump;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityChiromawTame
extends EntityTameableBL
implements IRingOfGatheringMinion,
IPullerEntityProvider<EntityPullerChiromaw> {
    private static final byte EVENT_DOUBLE_JUMP = 80;
    private static final DataParameter<Boolean> ATTACKING = EntityDataManager.func_187226_a(EntityChiromawTame.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ELECTRIC = EntityDataManager.func_187226_a(EntityChiromawTame.class, (DataSerializer)DataSerializers.field_187198_h);
    public int doubleJumpTicks;
    public int prevWingFlapTicks;
    public int wingFlapTicks;
    public int prevRaiseWingTicks;
    public int raiseWingsTicks;

    public EntityChiromawTame(World world) {
        super(world);
        this.func_70105_a(0.7f, 0.9f);
        this.field_70765_h = new FlightMoveHelper((EntityLiving)this);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70911_d = new EntityAISitBL(this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIBarbAttack(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityMob.class, 4.0f, 0.75, 0.75));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.5, true));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIFlyingWander((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new AIChiromawOwnerHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new AIChiromawOwnerHurtTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityMob.class, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACKING, (Object)false);
        this.field_70180_af.func_187214_a(ELECTRIC, (Object)false);
    }

    public String func_70005_c_() {
        if (this.getElectricBoogaloo()) {
            return I18n.func_74838_a((String)"entity.thebetweenlands.chiromaw_tame_lightning.name");
        }
        return super.func_70005_c_();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.field_70180_af.func_187227_b(ATTACKING, (Object)attacking);
    }

    public void setElectricBoogaloo(boolean electric) {
        this.field_70180_af.func_187227_b(ELECTRIC, (Object)electric);
    }

    public boolean getElectricBoogaloo() {
        return (Boolean)this.field_70180_af.func_187225_a(ELECTRIC);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("Electric", this.getElectricBoogaloo());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setElectricBoogaloo(nbt.func_74767_n("Electric"));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.FLYING_FIEND_LIVING;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundRegistry.FLYING_FIEND_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.FLYING_FIEND_DEATH;
    }

    public void func_70071_h_() {
        if (this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(this.func_70906_o());
        }
        super.func_70071_h_();
        Entity riding = this.func_184187_bx();
        if (this.doubleJumpTicks > 1) {
            --this.doubleJumpTicks;
        }
        this.prevWingFlapTicks = this.wingFlapTicks;
        if (this.wingFlapTicks > 1) {
            --this.wingFlapTicks;
        }
        if (riding == null || riding.field_70122_E) {
            this.doubleJumpTicks = 0;
        }
        if (riding == null) {
            if (this.field_70703_bu && this.func_70090_H()) {
                this.func_70605_aq().func_75642_a(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 1.0);
                this.func_70904_g(false);
            }
            if (this.func_70906_o()) {
                IBlockState state;
                BlockFaceShape shape;
                this.field_70179_y = 0.0;
                this.field_70181_x = 0.0;
                this.field_70159_w = 0.0;
                if (!this.func_130014_f_().field_72995_K && (shape = (state = this.field_70170_p.func_180495_p(this.func_180425_c().func_177984_a())).func_193401_d((IBlockAccess)this.field_70170_p, this.func_180425_c().func_177984_a(), EnumFacing.DOWN)) != BlockFaceShape.SOLID && shape != BlockFaceShape.MIDDLE_POLE_THICK) {
                    this.func_70904_g(false);
                }
            } else if (this.func_130014_f_().func_180495_p(this.func_180425_c().func_177977_b()).isSideSolid((IBlockAccess)this.func_130014_f_(), this.func_180425_c().func_177977_b(), EnumFacing.UP)) {
                this.func_70605_aq().func_75642_a(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 1.0);
            }
            if (this.field_70181_x < 0.0 && this.func_70638_az() == null) {
                this.field_70181_x *= 0.25;
            }
            this.prevRaiseWingTicks = this.raiseWingsTicks;
            if (this.raiseWingsTicks > 0) {
                --this.raiseWingsTicks;
            }
        } else {
            this.prevRaiseWingTicks = this.raiseWingsTicks;
            if (!riding.field_70122_E && this.raiseWingsTicks < 3) {
                ++this.raiseWingsTicks;
            } else if (riding.field_70122_E && this.raiseWingsTicks > 0) {
                --this.raiseWingsTicks;
                if (this.raiseWingsTicks == 0) {
                    this.wingFlapTicks = 0;
                }
            }
        }
    }

    public boolean func_142018_a(EntityLivingBase entityTarget, EntityLivingBase entityTarget2) {
        if (this.func_70906_o()) {
            return false;
        }
        if (!(entityTarget instanceof EntityCreeper) && !(entityTarget instanceof EntityGhast)) {
            if ((entityTarget instanceof EntityChiromawTame || entityTarget instanceof EntityPullerChiromaw) && ((EntityTameableBL)entityTarget).func_70902_q() != null && this.func_70902_q() != null && ((EntityTameableBL)entityTarget).func_70902_q() == this.func_70902_q()) {
                return false;
            }
            return entityTarget instanceof EntityPlayer && entityTarget2 instanceof EntityPlayer && !((EntityPlayer)entityTarget2).func_96122_a((EntityPlayer)entityTarget) ? false : !(entityTarget instanceof EntityHorse) || !((EntityHorse)entityTarget).func_110248_bS();
        }
        return false;
    }

    public void func_70604_c(@Nullable EntityLivingBase entity) {
        super.func_70604_c(entity);
        if ((entity instanceof EntityChiromawTame || entity instanceof EntityPullerChiromaw) && ((EntityTameableBL)entity).func_70902_q() != null && this.func_70902_q() != null && ((EntityTameableBL)entity).func_70902_q() == this.func_70902_q()) {
            this.func_70604_c(null);
        }
    }

    public boolean func_70652_k(Entity entity) {
        boolean hasHit = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (hasHit) {
            this.func_174815_a((EntityLivingBase)this, entity);
        }
        return hasHit;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.func_184218_aH() && (source.equals(DamageSource.field_76368_d) || source.equals(DamageSource.field_76369_e))) {
            return false;
        }
        if (source.func_76346_g() == this) {
            return false;
        }
        if (source.func_76364_f() instanceof EntityBLArrow && ((EntityBLArrow)source.func_76364_f()).getArrowType() == EnumArrowType.CHIROMAW_BARB) {
            return false;
        }
        if (this.func_184187_bx() != null && source.func_76346_g() == this.func_184187_bx() && !this.canRiderInteract()) {
            return false;
        }
        if (super.func_70097_a(source, damage)) {
            if (this.func_70906_o()) {
                this.func_70904_g(false);
            }
            return true;
        }
        return false;
    }

    protected PathNavigate func_175447_b(World world) {
        return new PathNavigateFlyingBL((EntityLiving)this, world, 2);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.func_70906_o() && !this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.func_70090_H()) {
            this.func_191958_b(strafe, vertical, forward, 0.02f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.8f;
            this.field_70181_x *= (double)0.8f;
            this.field_70179_y *= (double)0.8f;
        } else if (this.func_180799_ab()) {
            this.func_191958_b(strafe, vertical, forward, 0.02f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.5;
            this.field_70181_x *= 0.5;
            this.field_70179_y *= 0.5;
        } else {
            float f = 0.91f;
            if (this.field_70122_E) {
                BlockPos underPos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
                IBlockState underState = this.field_70170_p.func_180495_p(underPos);
                f = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, underPos, (Entity)this) * 0.91f;
            }
            float f1 = 0.16277136f / (f * f * f);
            this.func_191958_b(strafe, vertical, forward, this.field_70122_E ? 0.1f * f1 : 0.02f);
            f = 0.91f;
            if (this.field_70122_E) {
                BlockPos underPos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
                IBlockState underState = this.field_70170_p.func_180495_p(underPos);
                f = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, underPos, (Entity)this) * 0.91f;
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)f;
            this.field_70181_x *= (double)f;
            this.field_70179_y *= (double)f;
        }
        this.field_184618_aE = this.field_70721_aZ;
        double d1 = this.field_70165_t - this.field_70169_q;
        double d0 = this.field_70161_v - this.field_70166_s;
        float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public boolean func_70617_f_() {
        return false;
    }

    public void func_70904_g(boolean sitting) {
        super.func_70904_g(sitting);
        if (this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(sitting);
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        boolean holdsEquipment;
        ItemStack stack = player.func_184586_b(hand);
        boolean bl = holdsEquipment = hand == EnumHand.MAIN_HAND && !stack.func_190926_b() && (stack.func_77973_b() instanceof IEquippable || stack.func_77973_b() == ItemRegistry.AMULET_SLOT);
        if (holdsEquipment) {
            return true;
        }
        if (!stack.func_190926_b()) {
            if (stack.func_77973_b() == ItemRegistry.SNAIL_FLESH_RAW && this.func_110143_aJ() < this.func_110138_aP()) {
                if (!this.func_130014_f_().field_72995_K) {
                    this.func_70691_i(5.0f);
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                        if (stack.func_190916_E() <= 0) {
                            player.func_184611_a(hand, ItemStack.field_190927_a);
                        }
                    }
                } else {
                    this.func_70908_e(true);
                }
                return true;
            }
            if (stack.func_77973_b() == ItemRegistry.NET) {
                return stack.func_77973_b().func_111207_a(stack, player, (EntityLivingBase)this, EnumHand.MAIN_HAND);
            }
        }
        if (this.func_152114_e((EntityLivingBase)player) && hand == EnumHand.MAIN_HAND && !(this instanceof IPullerEntity)) {
            this.field_70177_z = player.field_70177_z;
            if (!this.func_130014_f_().field_72995_K) {
                this.func_70624_b(null);
                Entity riding = this.func_184187_bx();
                if (riding == null) {
                    if (!player.func_184207_aI()) {
                        if (this.func_70906_o()) {
                            this.func_70904_g(false);
                        }
                        this.func_130014_f_().func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.CHIROMAW_MATRIARCH_LAND, SoundCategory.NEUTRAL, 0.25f, 1.5f);
                        this.func_184205_a((Entity)player, true);
                    }
                } else {
                    boolean canUnmount = this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty();
                    if (canUnmount) {
                        this.func_130014_f_().func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.CHIROMAW_MATRIARCH_RELEASE, SoundCategory.NEUTRAL, 0.5f, 1.0f);
                        this.func_184210_p();
                    } else if (player instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)player).func_146105_b((ITextComponent)new TextComponentTranslation("chat.chiromaw_tame.obstructed", new Object[0]), true);
                    }
                    if (!this.func_70906_o()) {
                        if (canUnmount) {
                            ArrayList<BlockPos> sitPositions = new ArrayList<BlockPos>();
                            for (int yo = 2; yo <= 4; ++yo) {
                                for (int xo = -1; xo <= 1; ++xo) {
                                    for (int zo = -1; zo <= 1; ++zo) {
                                        IBlockState state;
                                        BlockFaceShape shape;
                                        BlockPos pos2 = new BlockPos((Vec3i)riding.func_180425_c().func_177982_a(xo, yo, zo));
                                        if (!this.field_70170_p.func_175623_d(pos2) || (shape = (state = this.field_70170_p.func_180495_p(pos2.func_177984_a())).func_193401_d((IBlockAccess)this.field_70170_p, pos2.func_177984_a(), EnumFacing.DOWN)) != BlockFaceShape.SOLID && shape != BlockFaceShape.MIDDLE_POLE_THICK) continue;
                                        sitPositions.add(pos2);
                                    }
                                }
                            }
                            if (!sitPositions.isEmpty()) {
                                this.func_70904_g(true);
                                this.field_70703_bu = false;
                                Collections.sort(sitPositions, Comparator.comparingDouble(pos -> this.func_70092_e((float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f)));
                                BlockPos sitPosition = (BlockPos)sitPositions.get(0);
                                this.func_70107_b((float)sitPosition.func_177958_n() + 0.5f, (float)(sitPosition.func_177956_o() + 1) - this.field_70131_O, (float)sitPosition.func_177952_p() + 0.5f);
                                this.field_70699_by.func_75499_g();
                                this.field_70179_y = 0.0;
                                this.field_70181_x = 0.0;
                                this.field_70159_w = 0.0;
                                this.field_70133_I = true;
                                this.func_191989_p(0.0f);
                                this.func_184646_p(0.0f);
                                this.func_70657_f(0.0f);
                            }
                        }
                    } else {
                        this.func_70904_g(false);
                    }
                }
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean func_184205_a(Entity entity, boolean force) {
        boolean result = super.func_184205_a(entity, force);
        if (entity instanceof EntityPlayer && this.field_70170_p instanceof WorldServer) {
            ((WorldServer)this.field_70170_p).func_73039_n().func_151247_a((Entity)this, (Packet)new SPacketSetPassengers(entity));
        }
        return result;
    }

    public void func_110145_l(Entity entity) {
        super.func_110145_l(entity);
        if (entity instanceof EntityPlayer && this.field_70170_p instanceof WorldServer) {
            ((WorldServer)this.field_70170_p).func_73039_n().func_151247_a((Entity)this, (Packet)new SPacketSetPassengers(entity));
        }
    }

    public void func_70098_U() {
        super.func_70098_U();
    }

    public double func_70033_W() {
        if (this.func_184187_bx() != null && this.func_184187_bx() instanceof EntityPlayer) {
            return (double)this.field_70131_O * 0.5;
        }
        return 0.0;
    }

    public boolean canRiderInteract() {
        return this.func_184187_bx() != null && this.func_184187_bx().func_70093_af();
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 80) {
            this.doubleJumpTicks = 20;
            this.wingFlapTicks = 20;
            this.prevWingFlapTicks = 20;
        }
    }

    public void performDoubleJump(EntityPlayer player) {
        if (!(this.doubleJumpTicks != 0 || this.field_70170_p.field_72995_K && player.field_70122_E)) {
            player.func_70664_aZ();
            player.field_70143_R = -2.0f;
            this.doubleJumpTicks = 20;
            this.wingFlapTicks = 20;
            this.prevWingFlapTicks = 20;
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)80);
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, (SoundEvent)SoundRegistry.CHIROMAW_MATRIARCH_FLAP, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            } else {
                TheBetweenlands.networkWrapper.sendToServer((IMessage)new MessageChiromawDoubleJump(this));
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onInputUpdate(InputUpdateEvent event) {
        if (event.getMovementInput().field_78901_c && !event.getEntityPlayer().field_70703_bu) {
            List passengers = event.getEntityPlayer().func_184188_bt();
            for (Entity entity : passengers) {
                if (!(entity instanceof EntityChiromawTame)) continue;
                ((EntityChiromawTame)entity).performDoubleJump(event.getEntityPlayer());
                return;
            }
        }
    }

    @Override
    public NBTTagCompound returnToRing(UUID userId) {
        return this.func_189511_e(new NBTTagCompound());
    }

    @Override
    public boolean returnFromRing(Entity user, NBTTagCompound nbt) {
        double prevX = this.field_70165_t;
        double prevY = this.field_70163_u;
        double prevZ = this.field_70161_v;
        float prevYaw = this.field_70177_z;
        float prevPitch = this.field_70125_A;
        this.func_70020_e(nbt);
        this.func_70012_b(prevX, prevY, prevZ, prevYaw, prevPitch);
        if (!this.func_70089_S()) {
            this.func_70606_j(this.func_110138_aP());
        }
        this.field_70170_p.func_72838_d((Entity)this);
        return true;
    }

    @Override
    public boolean shouldReturnOnUnload(boolean isOwnerLoggedIn) {
        return IRingOfGatheringMinion.super.shouldReturnOnUnload(isOwnerLoggedIn) && !this.func_70906_o();
    }

    @Override
    public UUID getRingOwnerId() {
        return this.func_184753_b();
    }

    @Override
    public EntityPullerChiromaw createPuller(EntityDraeton draeton, DraetonPhysicsPart puller) {
        return new EntityPullerChiromaw(draeton.field_70170_p, draeton, puller);
    }

    class AIBarbAttack
    extends EntityAIBase {
        EntityChiromawTame chiromaw;
        public int attackTimer;

        public AIBarbAttack(EntityChiromawTame chirowmawIn) {
            this.chiromaw = chirowmawIn;
        }

        public boolean func_75250_a() {
            return this.chiromaw.func_70638_az() != null && !this.chiromaw.func_70906_o();
        }

        public void func_75249_e() {
            this.attackTimer = 0;
        }

        public void func_75251_c() {
            this.chiromaw.setAttacking(false);
        }

        public void func_75246_d() {
            EntityLivingBase target = this.chiromaw.func_70638_az();
            if (!this.chiromaw.func_130014_f_().field_72995_K && target != null) {
                World world = this.chiromaw.func_130014_f_();
                if (target.func_70068_e((Entity)this.chiromaw) < 576.0 && target.func_70068_e((Entity)this.chiromaw) > 25.0 && this.chiromaw.func_70685_l((Entity)target)) {
                    ++this.attackTimer;
                    if (this.attackTimer == 20) {
                        EntityBLArrow arrow = new EntityBLArrow(world, (EntityLivingBase)this.chiromaw);
                        arrow.setType(this.chiromaw.getElectricBoogaloo() ? EnumArrowType.CHIROMAW_SHOCK_BARB : EnumArrowType.CHIROMAW_BARB);
                        double targetX = target.field_70165_t + target.field_70159_w - this.chiromaw.field_70165_t;
                        double targetY = target.field_70163_u + (double)target.func_70047_e() - this.chiromaw.field_70163_u + (double)this.chiromaw.func_70047_e();
                        double targetZ = target.field_70161_v + target.field_70179_y - this.chiromaw.field_70161_v;
                        arrow.func_70186_c(targetX, targetY, targetZ, 1.2f, 0.0f);
                        float g = -0.03f;
                        float vy0 = 0.35f;
                        float tmax = -vy0 / g;
                        float s = vy0 * tmax + 0.5f * g * tmax * tmax;
                        float h = (float)(target.field_70163_u + 0.5 - this.chiromaw.field_70163_u);
                        float fall = h - s;
                        if (fall < 0.0f) {
                            float tmin = MathHelper.func_76129_c((float)(fall * 2.0f / g));
                            float t = tmax + tmin;
                            float dx = (float)(target.field_70165_t + (double)((this.chiromaw.field_70146_Z.nextFloat() - 0.5f) * 2.2f) - this.chiromaw.field_70165_t) + (float)target.field_70159_w * t * 0.75f;
                            float dz = (float)(target.field_70161_v + (double)((this.chiromaw.field_70146_Z.nextFloat() - 0.5f) * 2.2f) - this.chiromaw.field_70161_v) + (float)target.field_70179_y * t * 0.75f;
                            float len = MathHelper.func_76129_c((float)(dx * dx + dz * dz));
                            float speed = len / t * 1.5f;
                            arrow.field_70159_w = (dx /= len) * speed;
                            arrow.field_70181_x = vy0;
                            arrow.field_70179_y = (dz /= len) * speed;
                        }
                        world.func_72838_d((Entity)arrow);
                        this.chiromaw.func_130014_f_().func_184133_a(null, this.chiromaw.func_180425_c(), (SoundEvent)SoundRegistry.CHIROMAW_MATRIARCH_BARB_FIRE, SoundCategory.NEUTRAL, 0.5f, 1.0f + (this.chiromaw.func_130014_f_().field_73012_v.nextFloat() - this.chiromaw.func_130014_f_().field_73012_v.nextFloat()) * 0.8f);
                        this.attackTimer = -20;
                    }
                } else if (this.attackTimer > 0) {
                    --this.attackTimer;
                }
                this.chiromaw.setAttacking(this.attackTimer > 10);
            }
        }
    }

    class AIChiromawOwnerHurtTarget
    extends EntityAITarget {
        EntityChiromawTame chiromaw;
        EntityLivingBase field_188509_g;
        private int timestamp;

        public AIChiromawOwnerHurtTarget(EntityChiromawTame chirowmawIn) {
            super((EntityCreature)chirowmawIn, false);
            this.chiromaw = chirowmawIn;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.chiromaw.func_70902_q();
            if (entitylivingbase == null) {
                return false;
            }
            this.field_188509_g = entitylivingbase.func_70643_av();
            int i = entitylivingbase.func_142015_aE();
            return i != this.timestamp && this.func_75296_a(this.field_188509_g, false) && this.chiromaw.func_142018_a(this.field_188509_g, entitylivingbase);
        }

        public void func_75249_e() {
            this.field_75299_d.func_70624_b(this.field_188509_g);
            EntityLivingBase entitylivingbase = this.chiromaw.func_70902_q();
            if (entitylivingbase != null) {
                this.timestamp = entitylivingbase.func_142015_aE();
            }
            super.func_75249_e();
        }
    }

    class AIChiromawOwnerHurtByTarget
    extends EntityAITarget {
        EntityChiromawTame chiromaw;
        EntityLivingBase attacker;
        private int timestamp;

        public AIChiromawOwnerHurtByTarget(EntityChiromawTame theDefendingChiromaw) {
            super((EntityCreature)theDefendingChiromaw, false);
            this.chiromaw = theDefendingChiromaw;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            EntityLivingBase entity = this.chiromaw.func_70902_q();
            if (entity == null) {
                return false;
            }
            this.attacker = entity.func_70643_av();
            int i = entity.func_142015_aE();
            return i != this.timestamp && this.func_75296_a(this.attacker, false) && this.chiromaw.func_142018_a(this.attacker, entity);
        }

        public void func_75249_e() {
            this.field_75299_d.func_70624_b(this.attacker);
            EntityLivingBase entity = this.chiromaw.func_70902_q();
            if (entity != null) {
                this.timestamp = entity.func_142015_aE();
            }
            super.func_75249_e();
        }
    }

    class AIFollowOwner
    extends EntityAIBase {
        private final EntityChiromawTame chiromaw;
        private EntityLivingBase owner;
        World world;
        private final double followSpeed;
        private final PathNavigate petPathfinder;
        private int timeToRecalcPath;
        float maxDist;
        float minDist;
        private float oldWaterCost;

        public AIFollowOwner(EntityChiromawTame chiromawIn, double followSpeedIn, float minDistIn, float maxDistIn) {
            this.chiromaw = chiromawIn;
            this.world = chiromawIn.func_130014_f_();
            this.followSpeed = followSpeedIn;
            this.petPathfinder = chiromawIn.func_70661_as();
            this.minDist = minDistIn;
            this.maxDist = maxDistIn;
            this.func_75248_a(3);
            if (!(chiromawIn.func_70661_as() instanceof PathNavigateFlyingBL)) {
                throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
            }
        }

        public boolean func_75250_a() {
            if (this.chiromaw.func_70906_o()) {
                return false;
            }
            EntityLivingBase entitylivingbase = this.chiromaw.func_70902_q();
            if (entitylivingbase == null) {
                return false;
            }
            if (entitylivingbase instanceof EntityPlayer && ((EntityPlayer)entitylivingbase).func_175149_v()) {
                return false;
            }
            if (this.chiromaw.func_70068_e((Entity)entitylivingbase) < (double)(this.minDist * this.minDist)) {
                return false;
            }
            this.owner = entitylivingbase;
            return true;
        }

        public boolean func_75253_b() {
            return !this.petPathfinder.func_75500_f() && this.chiromaw.func_70068_e((Entity)this.owner) > (double)(this.maxDist * this.maxDist);
        }

        public void func_75249_e() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = this.chiromaw.func_184643_a(PathNodeType.WATER);
            this.chiromaw.func_184644_a(PathNodeType.WATER, 0.0f);
        }

        public void func_75251_c() {
            this.owner = null;
            this.petPathfinder.func_75499_g();
            this.chiromaw.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
        }

        private boolean isEmptyBlock(BlockPos pos) {
            IBlockState iblockstate = this.world.func_180495_p(pos);
            return iblockstate.func_185904_a() == Material.field_151579_a ? true : !iblockstate.func_185917_h();
        }

        public void func_75246_d() {
            this.chiromaw.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.chiromaw.func_70646_bf());
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = 10;
                if (!this.petPathfinder.func_75497_a((Entity)this.owner, this.followSpeed) && !this.chiromaw.func_110167_bD() && this.chiromaw.func_70068_e((Entity)this.owner) >= 144.0) {
                    int i = MathHelper.func_76128_c((double)this.owner.field_70165_t) - 2;
                    int j = MathHelper.func_76128_c((double)this.owner.field_70161_v) - 2;
                    int k = MathHelper.func_76128_c((double)this.owner.func_174813_aQ().field_72338_b);
                    for (int l = 0; l <= 4; ++l) {
                        for (int i1 = 0; i1 <= 4; ++i1) {
                            if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !this.isTeleportFriendlyBlock(i, j, k, l, i1)) continue;
                            this.chiromaw.func_70012_b((float)(i + l) + 0.5f, k, (float)(j + i1) + 0.5f, this.chiromaw.field_70177_z, this.chiromaw.field_70125_A);
                            this.petPathfinder.func_75499_g();
                            return;
                        }
                    }
                }
            }
        }

        protected boolean isTeleportFriendlyBlock(int x, int z, int y, int xOffset, int zOffset) {
            BlockPos blockpos = new BlockPos(x + xOffset, y - 1, z + zOffset);
            IBlockState iblockstate = this.world.func_180495_p(blockpos);
            return iblockstate.func_193401_d((IBlockAccess)this.world, blockpos, EnumFacing.DOWN) == BlockFaceShape.SOLID && iblockstate.func_189884_a((Entity)this.chiromaw) && this.world.func_175623_d(blockpos.func_177984_a()) && this.world.func_175623_d(blockpos.func_177981_b(2));
        }
    }
}

