/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import com.google.common.base.Optional;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.BatchedParticleRenderer;
import thebetweenlands.client.render.particle.DefaultParticleBatches;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.render.particle.entity.ParticleEntitySwirl;
import thebetweenlands.client.render.particle.entity.ParticleLightningArc;
import thebetweenlands.common.block.misc.BlockOctine;
import thebetweenlands.common.entity.EntityProximitySpawner;
import thebetweenlands.common.entity.mobs.EntityChiromaw;
import thebetweenlands.common.entity.mobs.EntityChiromawTame;
import thebetweenlands.common.item.misc.ItemMob;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityChiromawHatchling
extends EntityProximitySpawner
implements IEntityAdditionalSpawnData {
    private static final byte EVENT_HATCH_PARTICLES = 100;
    private static final byte EVENT_FLOAT_UP_PARTICLES = 101;
    private static final byte EVENT_NEW_SPAWN = 102;
    public static final int MAX_EATING_COOLDOWN = 3000;
    public static final int MIN_EATING_COOLDOWN = 0;
    public static final int MAX_RISE = 40;
    public static final int MIN_RISE = 0;
    public static final int MAX_FOOD_NEEDED = 8;
    NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    public float feederRotation;
    public float prevFeederRotation;
    public float headPitch;
    public float prevHeadPitch;
    public int prevHatchAnimation;
    public int hatchAnimation;
    public int riseCount;
    public int prevRise;
    public int prevTransformTick;
    public int flapArmsCount;
    public int blinkCount;
    public boolean flapArms = false;
    private EnumFacing facing = EnumFacing.NORTH;
    protected static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(EntityChiromawHatchling.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Boolean> HATCHED = EntityDataManager.func_187226_a(EntityChiromawHatchling.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_RISING = EntityDataManager.func_187226_a(EntityChiromawHatchling.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_HUNGRY = EntityDataManager.func_187226_a(EntityChiromawHatchling.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> EATING_COOLDOWN = EntityDataManager.func_187226_a(EntityChiromawHatchling.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> FOOD_COUNT = EntityDataManager.func_187226_a(EntityChiromawHatchling.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IS_CHEWING = EntityDataManager.func_187226_a(EntityChiromawHatchling.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> TRANSFORM = EntityDataManager.func_187226_a(EntityChiromawHatchling.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> TRANSFORM_COUNT = EntityDataManager.func_187226_a(EntityChiromawHatchling.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> HATCH_COUNT = EntityDataManager.func_187226_a(EntityChiromawHatchling.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<ItemStack> FOOD_CRAVED = EntityDataManager.func_187226_a(EntityChiromawHatchling.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Boolean> ELECTRIC = EntityDataManager.func_187226_a(EntityChiromawHatchling.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_WILD = EntityDataManager.func_187226_a(EntityChiromawHatchling.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityChiromawHatchling(World world) {
        super(world);
        this.func_70105_a(0.75f, 1.0f);
        this.facing = EnumFacing.field_176754_o[world.field_73012_v.nextInt(4)];
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(HATCHED, (Object)false);
        this.field_70180_af.func_187214_a(IS_RISING, (Object)false);
        this.field_70180_af.func_187214_a(IS_HUNGRY, (Object)false);
        this.field_70180_af.func_187214_a(EATING_COOLDOWN, (Object)0);
        this.field_70180_af.func_187214_a(FOOD_COUNT, (Object)0);
        this.field_70180_af.func_187214_a(IS_CHEWING, (Object)false);
        this.field_70180_af.func_187214_a(TRANSFORM, (Object)false);
        this.field_70180_af.func_187214_a(TRANSFORM_COUNT, (Object)0);
        this.field_70180_af.func_187214_a(HATCH_COUNT, (Object)0);
        this.field_70180_af.func_187214_a(FOOD_CRAVED, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(ELECTRIC, (Object)false);
        this.field_70180_af.func_187214_a(IS_WILD, (Object)false);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_130014_f_().field_72995_K && this.getIsWild()) {
            this.setHasHatched(true);
            this.setEatingCooldown(0);
            this.setAmountEaten(8);
        }
        if (!this.getHasHatched()) {
            if (!this.func_130014_f_().field_72995_K) {
                if (this.field_70173_aa % 200 == 0 && this.func_130014_f_().func_180495_p(this.func_180425_c().func_177977_b()).func_177230_c() instanceof BlockOctine) {
                    this.setHatchTick(this.getHatchTick() + 1);
                }
                if (this.getHatchTick() >= 60) {
                    this.func_130014_f_().func_72960_a((Entity)this, (byte)100);
                    this.setIsHungry(true);
                    this.setHasHatched(true);
                    this.func_130014_f_().func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.CHIROMAW_HATCH, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
            }
            if (this.func_130014_f_().field_72995_K) {
                if (this.getHatchTick() >= 1) {
                    this.prevHatchAnimation = this.hatchAnimation++;
                }
                if (this.getElectricBoogaloo()) {
                    this.spawnLightningArcs();
                }
            }
        }
        if (this.getHasHatched()) {
            this.prevFeederRotation = this.feederRotation;
            this.prevHeadPitch = this.headPitch;
            this.prevTransformTick = this.getTransformCount();
            if (this.func_130014_f_().field_72995_K) {
                if (!this.getIsTransforming()) {
                    this.checkFeeder();
                } else if (this.getOwner() != null) {
                    this.lookAtFeeder((Entity)this.getOwner(), 30.0f);
                }
                if (this.getRising() && this.getRiseCount() >= 40) {
                    if (!this.getIsHungry() && this.headPitch < 40.0f) {
                        this.headPitch += 8.0f;
                    }
                    if (this.getIsHungry() && this.headPitch > 0.0f) {
                        this.headPitch -= 8.0f;
                    }
                }
                if (!this.getRising() && this.getRiseCount() < 40) {
                    this.headPitch = this.getRiseCount();
                }
                if (this.getAmountEaten() < 8 || !this.getIsChewing()) {
                    // empty if block
                }
                if (this.getElectricBoogaloo()) {
                    this.spawnLightningArcs();
                }
                if (this.getIsChewing() && this.getTransformCount() < 60) {
                    this.spawnEatingParticles();
                }
                if (!this.getIsHungry() && this.getRiseCount() >= 40 && !this.getIsChewing()) {
                    if (!this.flapArms && this.flapArmsCount <= 0 && this.field_70146_Z.nextInt(200) == 0) {
                        this.flapArms = true;
                        this.flapArmsCount = 30;
                    }
                    if (this.blinkCount <= 0 && this.field_70146_Z.nextInt(200) == 0) {
                        int n = this.blinkCount = this.field_70146_Z.nextBoolean() ? 10 : 5;
                    }
                }
                if (this.flapArmsCount >= 0) {
                    --this.flapArmsCount;
                }
                if (this.flapArms && this.flapArmsCount <= 0) {
                    this.flapArms = false;
                }
                if (this.blinkCount >= 0) {
                    --this.blinkCount;
                }
            }
            this.prevRise = this.getRiseCount();
            if (!this.getRising() && this.getRiseCount() > 0) {
                this.setRiseCount(this.getRiseCount() - 4);
            } else if (this.getRising() && this.getRiseCount() < 40) {
                this.setRiseCount(this.getRiseCount() + 4);
            }
            if (!this.func_130014_f_().field_72995_K) {
                this.checkArea();
                if (!this.getIsHungry()) {
                    this.setEatingCooldown(this.getEatingCooldown() - 1);
                    if (this.getEatingCooldown() <= 3000 && this.getEatingCooldown() > 2940 && !this.getIsChewing()) {
                        this.setIsChewing(true);
                    }
                    if (this.getEatingCooldown() < 2940 && this.getIsChewing()) {
                        this.setIsChewing(false);
                    }
                    if (this.getEatingCooldown() <= 0 && this.getAmountEaten() < 8) {
                        this.setIsHungry(true);
                        this.setFoodCraved(this.chooseNewFoodFromLootTable());
                    }
                }
                if (this.getIsTransforming()) {
                    if (this.getTransformCount() == 1) {
                        this.func_130014_f_().func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.CHIROMAW_HATCHLING_TRANSFORM, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                    }
                    if (this.getTransformCount() <= 60) {
                        this.setTransformCount(this.getTransformCount() + 1);
                        this.func_130014_f_().func_72960_a((Entity)this, (byte)101);
                    }
                    if (this.getOwner() != null) {
                        this.lookAtFeeder((Entity)this.getOwner(), 30.0f);
                    }
                }
                if (!this.field_70128_L && this.getRiseCount() >= 40) {
                    if (this.getIsHungry() && this.field_70173_aa % 20 == 0) {
                        this.func_130014_f_().func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.CHIROMAW_HATCHLING_HUNGRY_LONG, SoundCategory.NEUTRAL, 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.125f - this.field_70146_Z.nextFloat() * 0.125f);
                    }
                    if (this.getAmountEaten() >= 8 && this.getEatingCooldown() <= 0) {
                        Entity spawn;
                        if (!this.getIsTransforming()) {
                            this.setIsTransforming(true);
                        }
                        if (!this.field_70128_L && this.getTransformCount() >= 60 && (spawn = this.getEntitySpawned()) != null) {
                            if (!spawn.field_70128_L) {
                                this.func_130014_f_().func_72960_a((Entity)this, (byte)102);
                                this.func_130014_f_().func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.CHIROMAW_MATRIARCH_BARB_FIRE, SoundCategory.NEUTRAL, 1.0f, 1.0f + (this.func_130014_f_().field_73012_v.nextFloat() - this.func_130014_f_().field_73012_v.nextFloat()) * 0.8f);
                                this.func_130014_f_().func_72838_d(spawn);
                            }
                            this.func_70106_y();
                        }
                    }
                }
            }
        }
        this.field_70177_z = this.facing.func_185119_l();
    }

    protected SoundEvent func_184639_G() {
        if (this.getIsHungry() && this.getRiseCount() < 40) {
            return SoundRegistry.CHIROMAW_HATCHLING_HUNGRY_SHORT;
        }
        if (!this.getHasHatched()) {
            return SoundRegistry.CHIROMAW_HATCHLING_INSIDE_EGG;
        }
        return SoundRegistry.CHIROMAW_HATCHLING_LIVING;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 100) {
            for (int count = 0; count <= 100; ++count) {
                BLParticles.ITEM_BREAKING.spawn(this.field_70170_p, this.field_70165_t + (this.field_70170_p.field_73012_v.nextDouble() - 0.5), this.field_70163_u + 2.0 + this.field_70170_p.field_73012_v.nextDouble(), this.field_70161_v + (this.field_70170_p.field_73012_v.nextDouble() - 0.5), (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withData(new ItemStack((Item)ItemRegistry.CHIROMAW_EGG)));
            }
        }
        if (id == 101) {
            Object args = ParticleFactory.ParticleArgs.get().withDataBuilder().setData(2, this).buildData();
            if (this.getElectricBoogaloo()) {
                ((ParticleFactory.ParticleArgs)args).withColor(0.42f, 0.565f, 0.553f, 1.0f);
            } else {
                ((ParticleFactory.ParticleArgs)args).withColor(0.227f, 0.317f, 0.294f, 1.0f);
            }
            ((ParticleFactory.ParticleArgs)args).withScale(0.5f + this.field_70146_Z.nextFloat() * 0.5f);
            ParticleEntitySwirl particle = (ParticleEntitySwirl)BLParticles.CHIROMAW_TRANSFORM_SWIRL.create(this.field_70170_p, this.field_70165_t, this.field_70163_u + 2.6, this.field_70161_v, (ParticleFactory.ParticleArgs<?>)args);
            particle.setOffset(0.0, -1.3, 0.0);
            particle.setTargetOffset(0.0, 1.3, 0.0);
            particle.updateTarget();
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
        }
        if (id == 102) {
            int leafCount = 40;
            float x = (float)this.field_70165_t;
            float y = (float)(this.field_70163_u + (double)1.1f);
            float z = (float)this.field_70161_v;
            while (leafCount-- > 0) {
                float dx = this.func_130014_f_().field_73012_v.nextFloat() * 1.0f - 0.5f;
                float dy = this.func_130014_f_().field_73012_v.nextFloat() * 1.0f - 0.1f;
                float dz = this.func_130014_f_().field_73012_v.nextFloat() * 1.0f - 0.5f;
                float mag = 0.08f + this.func_130014_f_().field_73012_v.nextFloat() * 0.07f;
                if (this.getElectricBoogaloo()) {
                    BLParticles.CHIROMAW_TRANSFORM_LIGHTNING.spawn(this.func_130014_f_(), x, y, z, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion(dx * mag, dy * mag, dz * mag));
                    continue;
                }
                BLParticles.CHIROMAW_TRANSFORM.spawn(this.func_130014_f_(), x, y, z, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion(dx * mag, dy * mag, dz * mag));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnEatingParticles() {
        double angle = Math.toRadians(this.feederRotation + this.field_70177_z);
        double offSetX = -Math.sin(angle) * 0.35;
        double offSetZ = Math.cos(angle) * 0.35;
        BLParticles.ITEM_BREAKING.spawn(this.field_70170_p, this.field_70165_t + (double)((float)offSetX) + (this.field_70170_p.field_73012_v.nextDouble() * 0.25 - 0.125), this.field_70163_u + 0.75, this.field_70161_v + (double)((float)offSetZ) + (this.field_70170_p.field_73012_v.nextDouble() * 0.25 - 0.125), (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withData(this.getFoodCraved()));
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnLightningArcs() {
        if (this.func_130014_f_().field_73012_v.nextInt(2) == 0) {
            float ox = (this.func_130014_f_().field_73012_v.nextFloat() - 0.5f) * 2.0f;
            float oy = (this.func_130014_f_().field_73012_v.nextFloat() - 0.5f) * 2.0f;
            float oz = (this.func_130014_f_().field_73012_v.nextFloat() - 0.5f) * 2.0f;
            ParticleLightningArc particle = (ParticleLightningArc)BLParticles.LIGHTNING_ARC.create(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.5 + (double)((float)this.getTransformCount() * 0.02f), this.field_70161_v, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(this.field_70159_w, this.field_70181_x, this.field_70179_y)).withColor(0.3f, 0.5f, 1.0f, 0.9f)).withData(new Vec3d(this.field_70165_t + (double)ox, this.field_70163_u + (double)oy, this.field_70161_v + (double)oz)));
            particle.setLighting(false);
            BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.BEAM, particle);
        }
    }

    protected Entity checkFeeder() {
        Entity entity = null;
        List list = this.func_130014_f_().func_72872_a(EntityPlayer.class, this.proximityBox());
        for (int entityCount = 0; entityCount < list.size(); ++entityCount) {
            entity = (Entity)list.get(entityCount);
            if (entity == null || !(entity instanceof EntityPlayer) || this.field_70128_L || this.getRiseCount() < 40) continue;
            this.lookAtFeeder(entity, 30.0f);
        }
        if (entity == null && this.getRiseCount() > 0) {
            this.feederRotation = this.updateFeederRotation(this.feederRotation, 0.0f, 30.0f);
        }
        return entity;
    }

    @Override
    protected Entity checkArea() {
        Entity entity = null;
        if (!this.func_130014_f_().field_72995_K) {
            List list = this.func_130014_f_().func_72872_a(EntityPlayer.class, this.proximityBox());
            for (int entityCount = 0; entityCount < list.size(); ++entityCount) {
                entity = (Entity)list.get(entityCount);
                if (entity == null || !(entity instanceof EntityPlayer)) continue;
                if (this.canSneakPast() && entity.func_70093_af()) {
                    return null;
                }
                if (this.checkSight() && !this.func_70685_l(entity)) {
                    return null;
                }
                if (this.getRising()) continue;
                this.setRising(true);
            }
            if (entity == null && this.getRiseCount() > 0 && !this.getIsTransforming() && this.getRising()) {
                this.setRising(false);
            }
        }
        return entity;
    }

    @Override
    protected void performPreSpawnaction(@Nullable Entity targetEntity, Entity entitySpawned) {
    }

    public void lookAtFeeder(Entity entity, float maxYawIncrease) {
        double distanceX = entity.field_70165_t - this.field_70165_t;
        double distanceZ = entity.field_70161_v - this.field_70161_v;
        float angle = (float)(MathHelper.func_181159_b((double)distanceZ, (double)distanceX) * 57.29577951308232) - 90.0f;
        this.feederRotation = this.updateFeederRotation(this.feederRotation, angle - this.field_70177_z, maxYawIncrease);
    }

    private float updateFeederRotation(float angle, float targetAngle, float maxIncrease) {
        float f = MathHelper.func_76142_g((float)(targetAngle - angle));
        if (f > maxIncrease) {
            f = maxIncrease;
        }
        if (f < -maxIncrease) {
            f = -maxIncrease;
        }
        return angle + f;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        player.func_184609_a(hand);
        if (!this.getIsTransforming() && this.getHasHatched()) {
            if (!stack.func_190926_b() && !this.checkFoodEqual(stack, this.getFoodCraved())) {
                this.func_130014_f_().func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.CHIROMAW_HATCHLING_NO, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                return false;
            }
            if (!stack.func_190926_b() && this.getIsHungry() && this.checkFoodEqual(stack, this.getFoodCraved())) {
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                    if (stack.func_190916_E() <= 0) {
                        player.func_184611_a(hand, ItemStack.field_190927_a);
                    }
                }
                this.setEatingCooldown(3000);
                this.setAmountEaten(this.getAmountEaten() + 1);
                this.func_130014_f_().func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.CHIROMAW_HATCHLING_EAT, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                this.setIsHungry(false);
                return true;
            }
        }
        return super.func_184645_a(player, hand);
    }

    private boolean checkFoodEqual(ItemStack stack, ItemStack foodCraved) {
        if (stack.func_77973_b() == foodCraved.func_77973_b() && stack.func_77952_i() == foodCraved.func_77952_i()) {
            ResourceLocation stackEntity;
            ResourceLocation cravedEntity;
            return !(stack.func_77973_b() instanceof ItemMob) || Objects.equals(cravedEntity = ((ItemMob)foodCraved.func_77973_b()).getCapturedEntityId(foodCraved), stackEntity = ((ItemMob)stack.func_77973_b()).getCapturedEntityId(stack));
        }
        return false;
    }

    protected ResourceLocation getFoodCravingLootTable() {
        return LootTableRegistry.CHIROMAW_HATCHLING;
    }

    public ItemStack chooseNewFoodFromLootTable() {
        LootContext.Builder lootBuilder;
        List loot;
        LootTable lootTable = this.func_130014_f_().func_184146_ak().func_186521_a(this.getFoodCravingLootTable());
        if (lootTable != null && !(loot = lootTable.func_186462_a(this.field_70170_p.field_73012_v, (lootBuilder = new LootContext.Builder((WorldServer)this.field_70170_p).func_186472_a((Entity)this)).func_186471_a())).isEmpty()) {
            Collections.shuffle(loot);
            return (ItemStack)loot.get(0);
        }
        return new ItemStack(ItemRegistry.SNAIL_FLESH_RAW);
    }

    public String func_70005_c_() {
        if (this.getElectricBoogaloo()) {
            return I18n.func_74838_a((String)"entity.thebetweenlands.chiromaw_hatchling_lightning.name");
        }
        return super.func_70005_c_();
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        if (!this.func_130014_f_().field_72995_K) {
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
        }
        return livingdata;
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        if (!this.getHasHatched() && this.getHatchTick() < 1) {
            this.setElectricBoogaloo(true);
        } else {
            super.func_70077_a(lightningBolt);
        }
    }

    public void setElectricBoogaloo(boolean electric) {
        this.field_70180_af.func_187227_b(ELECTRIC, (Object)electric);
    }

    public boolean getElectricBoogaloo() {
        return (Boolean)this.field_70180_af.func_187225_a(ELECTRIC);
    }

    private void setHasHatched(boolean hatched) {
        this.field_70180_af.func_187227_b(HATCHED, (Object)hatched);
    }

    public boolean getHasHatched() {
        return (Boolean)this.field_70180_af.func_187225_a(HATCHED);
    }

    private void setRising(boolean rise) {
        this.field_70180_af.func_187227_b(IS_RISING, (Object)rise);
    }

    public boolean getRising() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_RISING);
    }

    private void setRiseCount(int riseCountIn) {
        this.riseCount = riseCountIn;
    }

    public int getRiseCount() {
        return this.riseCount;
    }

    private void setAmountEaten(int foodIn) {
        this.field_70180_af.func_187227_b(FOOD_COUNT, (Object)foodIn);
    }

    private int getAmountEaten() {
        return (Integer)this.field_70180_af.func_187225_a(FOOD_COUNT);
    }

    private void setEatingCooldown(int cooldown) {
        this.field_70180_af.func_187227_b(EATING_COOLDOWN, (Object)cooldown);
    }

    public int getEatingCooldown() {
        return (Integer)this.field_70180_af.func_187225_a(EATING_COOLDOWN);
    }

    private void setIsHungry(boolean hungry) {
        this.field_70180_af.func_187227_b(IS_HUNGRY, (Object)hungry);
    }

    public boolean getIsHungry() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_HUNGRY);
    }

    private void setIsChewing(boolean chewing) {
        this.field_70180_af.func_187227_b(IS_CHEWING, (Object)chewing);
    }

    public boolean getIsChewing() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_CHEWING);
    }

    private void setIsTransforming(boolean transform) {
        this.field_70180_af.func_187227_b(TRANSFORM, (Object)transform);
    }

    public boolean getIsTransforming() {
        return (Boolean)this.field_70180_af.func_187225_a(TRANSFORM);
    }

    private void setTransformCount(int transformCountIn) {
        this.field_70180_af.func_187227_b(TRANSFORM_COUNT, (Object)transformCountIn);
    }

    public int getTransformCount() {
        return (Integer)this.field_70180_af.func_187225_a(TRANSFORM_COUNT);
    }

    private void setHatchTick(int hatchCount) {
        this.field_70180_af.func_187227_b(HATCH_COUNT, (Object)hatchCount);
    }

    public int getHatchTick() {
        return (Integer)this.field_70180_af.func_187225_a(HATCH_COUNT);
    }

    public void setFoodCraved(ItemStack itemStack) {
        this.field_70180_af.func_187227_b(FOOD_CRAVED, (Object)itemStack);
    }

    public ItemStack getFoodCraved() {
        return (ItemStack)this.field_70180_af.func_187225_a(FOOD_CRAVED);
    }

    public void setIsWild(boolean wild) {
        this.field_70180_af.func_187227_b(IS_WILD, (Object)wild);
    }

    public boolean getIsWild() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_WILD);
    }

    public void func_174812_G() {
        this.func_70106_y();
    }

    @Override
    protected boolean func_70692_ba() {
        return false;
    }

    protected boolean func_70610_aX() {
        return true;
    }

    public boolean func_70104_M() {
        return true;
    }

    public boolean func_70067_L() {
        return !this.getIsTransforming();
    }

    public boolean func_190530_aW() {
        return false;
    }

    @Override
    protected float getProximityHorizontal() {
        return 5.0f;
    }

    @Override
    protected float getProximityVertical() {
        return 1.0f;
    }

    @Override
    protected AxisAlignedBB proximityBox() {
        return new AxisAlignedBB(this.func_180425_c()).func_72314_b((double)this.getProximityHorizontal(), (double)this.getProximityVertical(), (double)this.getProximityHorizontal());
    }

    @Override
    protected boolean canSneakPast() {
        return true;
    }

    @Override
    protected boolean checkSight() {
        return true;
    }

    @Override
    protected Entity getEntitySpawned() {
        IEntityBL entity = null;
        if (this.getIsWild()) {
            entity = new EntityChiromaw(this.func_130014_f_());
        } else {
            entity = new EntityChiromawTame(this.func_130014_f_());
            ((EntityChiromawTame)entity).func_184754_b(this.getOwnerId());
            if (this.func_145818_k_()) {
                entity.func_96094_a(this.func_95999_t());
            }
            if (this.getElectricBoogaloo()) {
                ((EntityChiromawTame)entity).setElectricBoogaloo(true);
            }
        }
        if (entity != null) {
            entity.func_70012_b(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, this.feederRotation + this.field_70177_z, 0.0f);
            ((EntityLiving)entity).field_70759_as = ((EntityLiving)entity).field_70177_z;
            ((EntityLiving)entity).field_70761_aq = ((EntityLiving)entity).field_70177_z;
            entity.func_191989_p(0.1f);
        }
        return entity;
    }

    @Override
    protected int getEntitySpawnCount() {
        return 1;
    }

    @Override
    protected boolean isSingleUse() {
        return true;
    }

    @Override
    protected int maxUseCount() {
        return 1;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.getOwnerId() == null) {
            nbt.func_74778_a("OwnerUUID", "");
        } else {
            nbt.func_74778_a("OwnerUUID", this.getOwnerId().toString());
        }
        nbt.func_74757_a("Hatched", this.getHasHatched());
        nbt.func_74768_a("HatchTick", this.getHatchTick());
        nbt.func_74757_a("Rising", this.getRising());
        nbt.func_74768_a("RisingCount", this.getRiseCount());
        nbt.func_74757_a("Hungry", this.getIsHungry());
        nbt.func_74768_a("FoodEaten", this.getAmountEaten());
        nbt.func_74768_a("EatingCooldown", this.getEatingCooldown());
        nbt.func_74757_a("Transforming", this.getIsTransforming());
        nbt.func_74768_a("TransformCount", this.getTransformCount());
        nbt.func_74768_a("Facing", this.facing.ordinal());
        nbt.func_74757_a("Electric", this.getElectricBoogaloo());
        nbt.func_74757_a("Wild", this.getIsWild());
        NBTTagCompound nbtFood = new NBTTagCompound();
        this.getFoodCraved().func_77955_b(nbtFood);
        nbt.func_74782_a("Items", (NBTBase)nbtFood);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        String s;
        super.func_70037_a(nbt);
        if (nbt.func_150297_b("OwnerUUID", 8)) {
            s = nbt.func_74779_i("OwnerUUID");
        } else {
            String s1 = nbt.func_74779_i("Owner");
            s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        if (!s.isEmpty()) {
            try {
                this.setOwnerId(UUID.fromString(s));
            }
            catch (Throwable s1) {
                // empty catch block
            }
        }
        this.setHasHatched(nbt.func_74767_n("Hatched"));
        this.setHatchTick(nbt.func_74762_e("HatchTick"));
        this.setRising(nbt.func_74767_n("Rising"));
        this.setRiseCount(nbt.func_74762_e("RisingCount"));
        this.setIsHungry(nbt.func_74767_n("Hungry"));
        this.setAmountEaten(nbt.func_74762_e("FoodEaten"));
        this.setEatingCooldown(nbt.func_74762_e("EatingCooldown"));
        this.setIsTransforming(nbt.func_74767_n("Transforming"));
        this.setTransformCount(nbt.func_74762_e("TransformCount"));
        this.facing = EnumFacing.field_82609_l[nbt.func_74762_e("Facing")];
        this.setElectricBoogaloo(nbt.func_74767_n("Electric"));
        this.setIsWild(nbt.func_74767_n("Wild"));
        NBTTagCompound nbtFood = (NBTTagCompound)nbt.func_74781_a("Items");
        ItemStack stack = new ItemStack(ItemRegistry.SNAIL_FLESH_RAW);
        if (nbtFood != null) {
            stack = new ItemStack(nbtFood);
        }
        this.setFoodCraved(stack);
    }

    @Nullable
    public UUID getOwnerId() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orNull();
    }

    public void setOwnerId(@Nullable UUID uuid) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, (Object)Optional.fromNullable((Object)uuid));
    }

    @Nullable
    public EntityLivingBase getOwner() {
        try {
            UUID uuid = this.getOwnerId();
            return uuid == null ? null : this.func_130014_f_().func_152378_a(uuid);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public boolean isOwner(EntityLivingBase entityIn) {
        return entityIn == this.getOwner();
    }

    public void writeSpawnData(ByteBuf buf) {
        buf.writeInt(this.facing.ordinal());
    }

    public void readSpawnData(ByteBuf buf) {
        this.facing = EnumFacing.field_82609_l[buf.readInt()];
    }
}

