/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class EntityDecayPitChain
extends Entity {
    public int animationTicks = 0;
    public int animationTicksPrev = 0;
    private static final DataParameter<Boolean> IS_RAISING = EntityDataManager.func_187226_a(EntityDecayPitChain.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_MOVING = EntityDataManager.func_187226_a(EntityDecayPitChain.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_SLOW = EntityDataManager.func_187226_a(EntityDecayPitChain.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> FACING = EntityDataManager.func_187226_a(EntityDecayPitChain.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LENGTH = EntityDataManager.func_187226_a(EntityDecayPitChain.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityDecayPitChain(World world) {
        super(world);
        this.func_70105_a(0.625f, 1.0f);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(IS_RAISING, (Object)false);
        this.field_70180_af.func_187214_a(IS_MOVING, (Object)false);
        this.field_70180_af.func_187214_a(IS_SLOW, (Object)true);
        this.field_70180_af.func_187214_a(FACING, (Object)0);
        this.field_70180_af.func_187214_a(LENGTH, (Object)1);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.animationTicksPrev = this.animationTicks++;
        if (this.isMoving() && !this.isSlow()) {
            this.animationTicks += 8;
        }
        if (this.animationTicksPrev >= 128) {
            this.animationTicksPrev = 0;
            this.animationTicks = 0;
            this.setMoving(false);
        }
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        return false;
    }

    public void func_184206_a(DataParameter<?> key) {
        if (LENGTH.equals(key)) {
            this.setNewLength(this.getLength());
        }
        super.func_184206_a(key);
    }

    protected void setNewLength(float height) {
        if (this.field_70131_O != height) {
            this.field_70131_O = height;
            AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_70165_t - (double)this.field_70130_N * 0.5, this.field_70163_u, this.field_70161_v - (double)this.field_70130_N * 0.5, this.field_70165_t + (double)this.field_70130_N * 0.5, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v + (double)this.field_70130_N * 0.5);
            this.func_174826_a(axisalignedbb);
        }
    }

    public void setRaising(boolean raising) {
        this.field_70180_af.func_187227_b(IS_RAISING, (Object)raising);
    }

    public boolean isRaising() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_RAISING);
    }

    public void setMoving(boolean moving) {
        this.field_70180_af.func_187227_b(IS_MOVING, (Object)moving);
    }

    public boolean isMoving() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_MOVING);
    }

    public void setSlow(boolean slow) {
        this.field_70180_af.func_187227_b(IS_SLOW, (Object)slow);
    }

    public boolean isSlow() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_SLOW);
    }

    public void setFacing(int direction) {
        this.field_70180_af.func_187227_b(FACING, (Object)direction);
    }

    public int getFacingRender() {
        return (Integer)this.field_70180_af.func_187225_a(FACING);
    }

    public void setLength(int length) {
        this.field_70180_af.func_187227_b(LENGTH, (Object)length);
    }

    public int getLength() {
        return (Integer)this.field_70180_af.func_187225_a(LENGTH);
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    public void func_70024_g(double x, double y, double z) {
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
    }

    public boolean func_190530_aW() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source instanceof EntityDamageSourceIndirect) {
            this.func_130014_f_().func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187689_f, SoundCategory.BLOCKS, 0.5f, 3.0f);
        }
        return false;
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.setLength(nbt.func_74762_e("length"));
        this.setFacing(nbt.func_74762_e("facing"));
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("length", this.getLength());
        nbt.func_74768_a("facing", this.getFacingRender());
    }
}

