/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.capability.blessing;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import thebetweenlands.api.capability.IBlessingCapability;
import thebetweenlands.api.capability.ISerializableCapability;
import thebetweenlands.common.capability.base.EntityCapability;
import thebetweenlands.common.herblore.elixir.ElixirEffectRegistry;
import thebetweenlands.common.registries.CapabilityRegistry;

public class BlessingEntityCapability
extends EntityCapability<BlessingEntityCapability, IBlessingCapability, EntityPlayer>
implements IBlessingCapability,
ISerializableCapability {
    private BlockPos location;
    private int dimension;

    @Override
    public ResourceLocation getID() {
        return new ResourceLocation("thebetweenlands", "blessing");
    }

    @Override
    protected Capability<IBlessingCapability> getCapability() {
        return CapabilityRegistry.CAPABILITY_BLESSING;
    }

    @Override
    protected Class<IBlessingCapability> getCapabilityClass() {
        return IBlessingCapability.class;
    }

    @Override
    protected BlessingEntityCapability getDefaultCapabilityImplementation() {
        return new BlessingEntityCapability();
    }

    @Override
    public boolean isApplicable(Entity entity) {
        return entity instanceof EntityPlayer;
    }

    @Override
    public boolean isBlessed() {
        return this.location != null;
    }

    @Override
    public BlockPos getBlessingLocation() {
        return this.location;
    }

    @Override
    public int getBlessingDimension() {
        return this.dimension;
    }

    @Override
    public void setBlessed(int dimension, BlockPos location) {
        this.location = location;
        this.dimension = dimension;
        this.markDirty();
    }

    @Override
    public void clearBlessed() {
        this.location = null;
        this.markDirty();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        if (this.location != null) {
            nbt.func_74768_a("x", this.location.func_177958_n());
            nbt.func_74768_a("y", this.location.func_177956_o());
            nbt.func_74768_a("z", this.location.func_177952_p());
        }
        nbt.func_74768_a("dimension", this.dimension);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.location = nbt.func_150297_b("x", 3) && nbt.func_150297_b("y", 3) && nbt.func_150297_b("z", 3) ? new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z")) : null;
        this.dimension = nbt.func_74762_e("dimension");
    }

    @Override
    public void writeTrackingDataToNBT(NBTTagCompound nbt) {
        this.writeToNBT(nbt);
    }

    @Override
    public void readTrackingDataFromNBT(NBTTagCompound nbt) {
        this.readFromNBT(nbt);
    }

    @Override
    public int getTrackingTime() {
        return 10;
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        IBlessingCapability cap;
        if (event.phase == TickEvent.Phase.START && !event.player.field_70170_p.field_72995_K && (cap = (IBlessingCapability)event.player.getCapability(CapabilityRegistry.CAPABILITY_BLESSING, null)) != null && cap.isBlessed() && cap.getBlessingLocation() != null && event.player.field_71093_bK == cap.getBlessingDimension()) {
            event.player.func_70690_d(ElixirEffectRegistry.EFFECT_BLESSED.createEffect(205, 0));
        }
    }
}

