/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.misc;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.tab.BLCreativeTabs;

public class BlockLantern
extends Block {
    private static final AxisAlignedBB AABB_LARGE = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
    private static final AxisAlignedBB AABB_SMALL = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.6, 0.75);
    public static final PropertyInteger ROTATION = PropertyInteger.func_177719_a((String)"rotation", (int)0, (int)7);
    public static final PropertyBool HANGING = PropertyBool.func_177716_a((String)"hanging");

    public BlockLantern() {
        this(Material.field_151580_n, SoundType.field_185854_g);
    }

    protected BlockLantern(Material material, SoundType soundType) {
        super(material);
        this.func_149711_c(0.1f);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
        this.func_149672_a(soundType);
        this.func_149715_a(1.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)ROTATION, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)HANGING, (Comparable)Boolean.valueOf(false)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)ROTATION, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)ROTATION);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)ROTATION, (Comparable)Integer.valueOf(rot.func_185833_a(((Integer)state.func_177229_b((IProperty)ROTATION)).intValue(), 8)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_177226_a((IProperty)ROTATION, (Comparable)Integer.valueOf(mirrorIn.func_185802_a(((Integer)state.func_177229_b((IProperty)ROTATION)).intValue(), 8)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ROTATION, HANGING});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)HANGING, (Comparable)Boolean.valueOf(worldIn.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN, false) || worldIn.func_180495_p(pos.func_177984_a()).func_193401_d(worldIn, pos.func_177984_a(), EnumFacing.DOWN) != BlockFaceShape.UNDEFINED));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return (Boolean)this.func_176221_a(state, source, pos).func_177229_b((IProperty)HANGING) != false ? AABB_LARGE : AABB_SMALL;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        int rotation = MathHelper.func_76128_c((double)((double)((placer.field_70177_z + 180.0f) * 8.0f / 360.0f) + 0.5)) & 7;
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)ROTATION, (Comparable)Integer.valueOf(rotation)), 11);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.checkAndDropBlock(worldIn, pos, state);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && (worldIn.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN) || worldIn.func_180495_p(pos.func_177984_a()).func_193401_d((IBlockAccess)worldIn, pos.func_177984_a(), EnumFacing.DOWN) != BlockFaceShape.UNDEFINED || worldIn.isSideSolid(pos.func_177977_b(), EnumFacing.UP) || worldIn.func_180495_p(pos.func_177977_b()).func_193401_d((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) != BlockFaceShape.UNDEFINED);
    }

    protected void checkAndDropBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN) && worldIn.func_180495_p(pos.func_177984_a()).func_193401_d((IBlockAccess)worldIn, pos.func_177984_a(), EnumFacing.DOWN) == BlockFaceShape.UNDEFINED && !worldIn.isSideSolid(pos.func_177977_b(), EnumFacing.UP) && worldIn.func_180495_p(pos.func_177977_b()).func_193401_d((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) == BlockFaceShape.UNDEFINED) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        double px = (double)pos.func_177958_n() + 0.5;
        double py = (double)pos.func_177956_o() + 0.3;
        double pz = (double)pos.func_177952_p() + 0.5;
        if (worldIn.field_73012_v.nextInt(20) == 0 && worldIn.func_175710_j(pos)) {
            int particle = rand.nextInt(2);
            switch (particle) {
                default: {
                    BLParticles.FLY.spawn(worldIn, px, py, pz);
                    break;
                }
                case 1: {
                    BLParticles.MOTH.spawn(worldIn, px, py, pz);
                }
            }
        }
    }
}

