/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.advancments;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.critereon.AbstractCriterionInstance;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import thebetweenlands.common.advancments.BLTrigger;

public class AnimateTrigger
extends BLTrigger<Instance, Listener> {
    public static final ResourceLocation ID = new ResourceLocation("thebetweenlands", "animate");

    public ResourceLocation func_192163_a() {
        return ID;
    }

    @Override
    public Listener createListener(PlayerAdvancements playerAdvancements) {
        return new Listener(playerAdvancements);
    }

    public Instance deserializeInstance(JsonObject json, JsonDeserializationContext context) {
        ItemPredicate[] inputs = ItemPredicate.func_192494_b((JsonElement)json.get("inputs"));
        ItemPredicate[] outputs = ItemPredicate.func_192494_b((JsonElement)json.get("outputs"));
        return new Instance(inputs, outputs);
    }

    public void trigger(ItemStack input, ItemStack output, EntityPlayerMP player) {
        Listener listeners = (Listener)this.listeners.get(player.func_192039_O());
        if (listeners != null) {
            listeners.trigger(input, output);
        }
    }

    static class Listener
    extends BLTrigger.Listener<Instance> {
        public Listener(PlayerAdvancements playerAdvancementsIn) {
            super(playerAdvancementsIn);
        }

        public void trigger(ItemStack inpout, ItemStack output) {
            ArrayList<ICriterionTrigger.Listener> list = new ArrayList<ICriterionTrigger.Listener>();
            for (ICriterionTrigger.Listener listener : this.listeners) {
                if (!((Instance)listener.func_192158_a()).test(inpout, output)) continue;
                list.add(listener);
                break;
            }
            for (ICriterionTrigger.Listener listener : list) {
                listener.func_192159_a(this.playerAdvancements);
            }
        }
    }

    public static class Instance
    extends AbstractCriterionInstance {
        private final ItemPredicate[] inputs;
        private final ItemPredicate[] outputs;

        public Instance(ItemPredicate[] inputs, ItemPredicate[] outputs) {
            super(ID);
            this.inputs = inputs;
            this.outputs = outputs;
        }

        public boolean test(ItemStack input, ItemStack output) {
            ArrayList itemList = Lists.newArrayList((Object[])this.inputs);
            int itemAmount = itemList.size();
            itemList.removeIf(predicate -> predicate.func_192493_a(input));
            ArrayList outputList = Lists.newArrayList((Object[])this.outputs);
            int outputAmount = outputList.size();
            outputList.removeIf(predicate -> predicate.func_192493_a(output));
            return !(itemAmount != 0 && itemAmount <= itemList.size() || outputAmount != 0 && outputAmount <= outputList.size());
        }
    }
}

