/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.sky;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL14;
import thebetweenlands.api.sky.IBetweenlandsSky;
import thebetweenlands.api.sky.IRiftRenderer;
import thebetweenlands.client.handler.FogHandler;
import thebetweenlands.client.render.shader.GeometryBuffer;
import thebetweenlands.client.render.shader.ShaderHelper;
import thebetweenlands.client.render.shader.postprocessing.WorldShader;
import thebetweenlands.client.render.sky.AuroraRenderer;
import thebetweenlands.client.render.sky.RiftRenderer;
import thebetweenlands.common.world.WorldProviderBetweenlands;
import thebetweenlands.common.world.event.BLEnvironmentEventRegistry;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.util.FramebufferStack;
import thebetweenlands.util.Mesh;

@SideOnly(value=Side.CLIENT)
public class BLSkyRenderer
extends IRenderHandler
implements IBetweenlandsSky {
    public static final ResourceLocation SKY_TEXTURE = new ResourceLocation("thebetweenlands:textures/sky/sky_texture.png");
    public static final ResourceLocation SKY_SPOOPY_TEXTURE = new ResourceLocation("thebetweenlands:textures/sky/spoopy.png");
    public static final ResourceLocation FOG_TEXTURE = new ResourceLocation("thebetweenlands:textures/sky/fog_texture.png");
    protected List<AuroraRenderer> auroras = new ArrayList<AuroraRenderer>();
    private static int skyDomeDispList = -1;
    private static Mesh starMesh;
    public static GeometryBuffer clipPlaneBuffer;
    protected int ticks;
    protected boolean spoopy;
    private IRiftRenderer riftRenderer;
    private static RiftRenderer blRiftRenderer;

    public BLSkyRenderer() {
        if (clipPlaneBuffer == null) {
            clipPlaneBuffer = new GeometryBuffer(Minecraft.func_71410_x().func_110434_K(), WorldShader.CLIP_PLANE_DIFFUSE_TEXTURE, WorldShader.CLIP_PLANE_DEPTH_TEXTURE, true);
        }
        if (starMesh == null && ShaderHelper.INSTANCE.canUseShaders()) {
            starMesh = this.createStarMesh();
        }
        if (skyDomeDispList == -1) {
            skyDomeDispList = GLAllocation.func_74526_a((int)1);
            GlStateManager.func_187423_f((int)skyDomeDispList, (int)4864);
            this.renderSkyDome();
            GlStateManager.func_187415_K();
        }
        if (blRiftRenderer == null) {
            blRiftRenderer = new RiftRenderer(skyDomeDispList);
        }
        this.setRiftRenderer(blRiftRenderer);
    }

    @Override
    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        this.renderSky(partialTicks, world, mc);
        this.riftRenderer.render(partialTicks, world, mc);
        this.renderFog(partialTicks, world, mc);
        this.renderAuroras(partialTicks, world, mc);
        this.resetRenderingStates();
    }

    protected Mesh createStarMesh() {
        ArrayList<Mesh.Triangle> triangles = new ArrayList<Mesh.Triangle>();
        Random random = new Random(10842L);
        for (int i = 0; i < 1500; ++i) {
            double rz;
            double ry;
            double rx = random.nextFloat() * 2.0f - 1.0f;
            double centerDistance = rx * rx + (ry = (double)(random.nextFloat() * 0.5f - 1.0f)) * ry + (rz = (double)(random.nextFloat() * 2.0f - 1.0f)) * rz;
            if (!(centerDistance < 1.0) || !(centerDistance > 0.01)) continue;
            centerDistance = 1.0 / Math.sqrt(centerDistance);
            double farX = (rx *= centerDistance) * 100.0;
            double farY = (ry *= centerDistance) * 100.0;
            double farZ = (rz *= centerDistance) * 100.0;
            double xzAngle = Math.atan2(rx, rz);
            double xzRotX = Math.sin(xzAngle);
            double xzRotY = Math.cos(xzAngle);
            double distYAngle = Math.atan2(Math.sqrt(rx * rx + rz * rz), ry);
            double distYRotX = Math.sin(distYAngle);
            double distYRotZ = Math.cos(distYAngle);
            double randAngle = random.nextDouble() * Math.PI * 2.0;
            double randRotX = Math.sin(randAngle);
            double randRotY = Math.cos(randAngle);
            int color = -1;
            if (random.nextInt(2) == 1) {
                color = -16738048;
            }
            double randSize = 0.15f + random.nextFloat() * 0.1f;
            Mesh.Triangle.Vertex v1 = this.getQuadPoint(0, randSize, randRotX, randRotY, distYRotX, distYRotZ, xzRotX, xzRotY, farX, farY, farZ, color);
            Mesh.Triangle.Vertex v2 = this.getQuadPoint(1, randSize, randRotX, randRotY, distYRotX, distYRotZ, xzRotX, xzRotY, farX, farY, farZ, color);
            Mesh.Triangle.Vertex v3 = this.getQuadPoint(2, randSize, randRotX, randRotY, distYRotX, distYRotZ, xzRotX, xzRotY, farX, farY, farZ, color);
            Mesh.Triangle.Vertex v4 = this.getQuadPoint(3, randSize, randRotX, randRotY, distYRotX, distYRotZ, xzRotX, xzRotY, farX, farY, farZ, color);
            Mesh.Triangle t1 = new Mesh.Triangle(v1, v2, v3);
            Mesh.Triangle t2 = new Mesh.Triangle(v3, v4, v1);
            triangles.add(t1);
            triangles.add(t2);
        }
        return new Mesh(triangles);
    }

    protected Mesh.Triangle.Vertex getQuadPoint(int vertex, double randSize, double randRotX, double randRotY, double distYRotX, double distYRotZ, double xzRotX, double xzRotY, double farX, double farY, double farZ, int color) {
        double randRotYMultiplier = 0.0;
        double vertX = (double)((vertex & 2) - 1) * randSize;
        double vertZ = (double)((vertex + 1 & 2) - 1) * randSize;
        double rotVertX = vertX * randRotY - vertZ * randRotX;
        double rotVertZ = vertZ * randRotY + vertX * randRotX;
        double rotVertX2 = rotVertX * distYRotX + randRotYMultiplier * distYRotZ;
        double rotVertZ2 = randRotYMultiplier * distYRotX - rotVertX * distYRotZ;
        vertX = rotVertZ2 * xzRotX - rotVertZ * xzRotY;
        vertZ = rotVertZ * xzRotX + rotVertZ2 * xzRotY;
        return new Mesh.Triangle.Vertex(farX + vertX, farY + rotVertX2, farZ + vertZ, new Mesh.Triangle.Vertex.Vector3D(0.0, -1.0, 0.0), color);
    }

    protected void renderSky(float partialTicks, WorldClient world, Minecraft mc) {
        Vec3d skyColor = world.func_72833_a(mc.func_175606_aa(), partialTicks);
        float skyR = (float)skyColor.field_72450_a;
        float skyG = (float)skyColor.field_72448_b;
        float skyB = (float)skyColor.field_72449_c;
        float anaglyphR = 0.0f;
        float anaglyphG = 0.0f;
        float anaglyphB = 0.0f;
        if (mc.field_71474_y.field_74337_g) {
            anaglyphR = (skyR * 30.0f + skyG * 59.0f + skyB * 11.0f) / 100.0f;
            anaglyphG = (skyR * 30.0f + skyG * 70.0f) / 100.0f;
            anaglyphB = (skyR * 30.0f + skyB * 70.0f) / 100.0f;
            skyR = anaglyphR;
            skyG = anaglyphG;
            skyB = anaglyphB;
        }
        float invRainStrength = 1.0f - world.func_72867_j(partialTicks);
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        boolean useShaderSky = ShaderHelper.INSTANCE.isWorldShaderActive() && ShaderHelper.INSTANCE.getWorldShader() != null && ShaderHelper.INSTANCE.getWorldShader().getStarfieldTexture() >= 0;
        float starBrightness = (world.func_72880_h(partialTicks) + 0.5f) * invRainStrength * invRainStrength * invRainStrength;
        float fade = 1.0f;
        WorldProviderBetweenlands provider = WorldProviderBetweenlands.getProvider((World)mc.field_71441_e);
        if (provider != null) {
            fade = provider.getEnvironmentEventRegistry().denseFog.getFade(partialTicks) * 0.95f + 0.05f;
        }
        if ((starBrightness *= fade) > 0.0f && !useShaderSky && starMesh != null) {
            GL14.glBlendColor((float)0.0f, (float)0.0f, (float)0.0f, (float)((starBrightness - 0.22f) * 3.5f));
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.CONSTANT_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_CONSTANT_ALPHA);
            GlStateManager.func_179094_E();
            starMesh.render();
            GlStateManager.func_179121_F();
            GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GlStateManager.func_179121_F();
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        if (world.field_73011_w.func_76561_g()) {
            GlStateManager.func_179131_c((float)(skyR * 0.2f + 0.04f), (float)(skyG * 0.2f + 0.04f), (float)(skyB * 0.6f + 0.1f), (float)(starBrightness / (!useShaderSky ? 1.5f : 1.0f)));
        } else {
            GlStateManager.func_179131_c((float)skyR, (float)skyG, (float)skyB, (float)(starBrightness / (!useShaderSky ? 1.5f : 1.0f)));
        }
        GlStateManager.func_179098_w();
        if (useShaderSky) {
            GlStateManager.func_179144_i((int)ShaderHelper.INSTANCE.getWorldShader().getStarfieldTexture());
            GlStateManager.func_179118_c();
            GlStateManager.func_179147_l();
            GlStateManager.func_179098_w();
            RenderHelper.func_74518_a();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_187421_b((int)3553, (int)10241, (int)9729);
            GlStateManager.func_187421_b((int)3553, (int)10240, (int)9729);
            GlStateManager.func_179092_a((int)516, (float)0.0f);
            GlStateManager.func_179148_o((int)skyDomeDispList);
            GlStateManager.func_187421_b((int)3553, (int)10241, (int)9728);
            GlStateManager.func_187421_b((int)3553, (int)10240, (int)9728);
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179084_k();
            GlStateManager.func_179141_d();
            this.renderFlatSky(partialTicks, world, mc, true, false);
        } else if (Minecraft.func_71410_x().field_71474_y.field_74347_j) {
            mc.field_71446_o.func_110577_a(SKY_TEXTURE);
            GlStateManager.func_179118_c();
            GlStateManager.func_179147_l();
            GlStateManager.func_179098_w();
            RenderHelper.func_74518_a();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_187421_b((int)3553, (int)10241, (int)9729);
            GlStateManager.func_187421_b((int)3553, (int)10240, (int)9729);
            GlStateManager.func_179092_a((int)516, (float)0.0f);
            GlStateManager.func_179148_o((int)skyDomeDispList);
            GlStateManager.func_187421_b((int)3553, (int)10241, (int)9728);
            GlStateManager.func_187421_b((int)3553, (int)10240, (int)9728);
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179084_k();
            GlStateManager.func_179141_d();
        } else {
            this.renderFlatSky(partialTicks, world, mc, false, false);
        }
        if (this.spoopy) {
            if (Minecraft.func_71410_x().field_71474_y.field_74347_j) {
                mc.field_71446_o.func_110577_a(SKY_SPOOPY_TEXTURE);
                GlStateManager.func_187421_b((int)3553, (int)10242, (int)10496);
                GlStateManager.func_187421_b((int)3553, (int)10243, (int)10496);
                GlStateManager.func_179128_n((int)5890);
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)1.0);
                GlStateManager.func_179139_a((double)2.0, (double)2.0, (double)0.0);
                GlStateManager.func_179128_n((int)5888);
                GlStateManager.func_179118_c();
                GlStateManager.func_179147_l();
                GlStateManager.func_179098_w();
                RenderHelper.func_74518_a();
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179092_a((int)516, (float)0.0f);
                GlStateManager.func_179148_o((int)skyDomeDispList);
                GlStateManager.func_179092_a((int)516, (float)0.1f);
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179084_k();
                GlStateManager.func_179141_d();
                GlStateManager.func_179128_n((int)5890);
                GlStateManager.func_179121_F();
                GlStateManager.func_179128_n((int)5888);
            } else {
                GlStateManager.func_179094_E();
                mc.field_71446_o.func_110577_a(SKY_SPOOPY_TEXTURE);
                GlStateManager.func_187421_b((int)3553, (int)10242, (int)10496);
                GlStateManager.func_187421_b((int)3553, (int)10243, (int)10496);
                GlStateManager.func_179128_n((int)5890);
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)1.0);
                GlStateManager.func_179139_a((double)2.0, (double)2.0, (double)0.0);
                GlStateManager.func_179128_n((int)5888);
                this.renderFlatSky(partialTicks, world, mc, false, true);
                GlStateManager.func_179128_n((int)5890);
                GlStateManager.func_179121_F();
                GlStateManager.func_179128_n((int)5888);
                GlStateManager.func_179121_F();
            }
        }
    }

    protected void renderFlatSky(float partialTicks, WorldClient world, Minecraft mc, boolean renderClipPlane, boolean spoopy) {
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179132_a((boolean)false);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        if (!renderClipPlane) {
            if (spoopy) {
                mc.field_71446_o.func_110577_a(SKY_SPOOPY_TEXTURE);
            } else {
                WorldShader shader;
                boolean shaderTexture = false;
                if (ShaderHelper.INSTANCE.isWorldShaderActive() && (shader = ShaderHelper.INSTANCE.getWorldShader()) != null && shader.getStarfieldTexture() >= 0) {
                    GlStateManager.func_179144_i((int)shader.getStarfieldTexture());
                    shaderTexture = true;
                }
                if (!shaderTexture) {
                    mc.field_71446_o.func_110577_a(SKY_TEXTURE);
                }
            }
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vertexBuffer.func_181662_b(-90.0, -50.0, -90.0).func_187315_a(0.0, 0.0).func_181675_d();
            vertexBuffer.func_181662_b(-90.0, -50.0, 90.0).func_187315_a(0.0, 1.0).func_181675_d();
            vertexBuffer.func_181662_b(90.0, -50.0, 90.0).func_187315_a(1.0, 1.0).func_181675_d();
            vertexBuffer.func_181662_b(90.0, -50.0, -90.0).func_187315_a(1.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
        } else {
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179090_x();
            GlStateManager.func_179106_n();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            try (FramebufferStack.State state = FramebufferStack.push();){
                Framebuffer mcFbo = mc.func_147110_a();
                clipPlaneBuffer.updateGeometryBuffer(mcFbo.field_147621_c, mcFbo.field_147618_d);
                clipPlaneBuffer.bind();
                clipPlaneBuffer.clear(0.0f, 0.0f, 0.0f, 0.0f);
                vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                vertexBuffer.func_181662_b(-9000.0, -90.0, -9000.0).func_181669_b(255, 255, 255, 255).func_181675_d();
                vertexBuffer.func_181662_b(-9000.0, -90.0, 9000.0).func_181669_b(255, 255, 255, 255).func_181675_d();
                vertexBuffer.func_181662_b(9000.0, -90.0, 9000.0).func_181669_b(255, 255, 255, 255).func_181675_d();
                vertexBuffer.func_181662_b(9000.0, -90.0, -9000.0).func_181669_b(255, 255, 255, 255).func_181675_d();
                tessellator.func_78381_a();
                clipPlaneBuffer.updateDepthBuffer();
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179098_w();
        }
        GlStateManager.func_179121_F();
    }

    protected void renderFog(float partialTicks, WorldClient world, Minecraft mc) {
        if (Minecraft.func_71410_x().field_71474_y.field_74347_j) {
            GlStateManager.func_179094_E();
            float renderRadius = 80.0f;
            GlStateManager.func_179127_m();
            GlStateManager.func_179102_b((float)(renderRadius / 2.0f));
            GlStateManager.func_179153_c((float)(renderRadius * 2.0f));
            GlStateManager.func_179152_a((float)(0.02f * renderRadius), (float)(0.02f * renderRadius), (float)(0.02f * renderRadius));
            GlStateManager.func_179109_b((float)0.0f, (float)10.0f, (float)0.0f);
            mc.field_71446_o.func_110577_a(FOG_TEXTURE);
            GlStateManager.func_179118_c();
            GlStateManager.func_179147_l();
            GlStateManager.func_179098_w();
            RenderHelper.func_74518_a();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_187421_b((int)3553, (int)10241, (int)9729);
            GlStateManager.func_187421_b((int)3553, (int)10240, (int)9729);
            GlStateManager.func_179092_a((int)516, (float)0.0f);
            float renderTicks = (float)this.ticks + partialTicks;
            float domeRotation = renderTicks * 0.1f;
            GlStateManager.func_179152_a((float)1.0f, (float)0.8f, (float)1.0f);
            GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.25f);
            GlStateManager.func_179148_o((int)skyDomeDispList);
            GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.15f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)domeRotation, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)0.0, (double)(Math.cos(renderTicks / 150.0f) * 6.0 + 4.0), (double)0.0);
            GlStateManager.func_179148_o((int)skyDomeDispList);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)(-domeRotation / 1.8f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)0.0, (double)(-Math.sin(renderTicks / 170.0f) * 6.0 + 4.0), (double)0.0);
            GlStateManager.func_179148_o((int)skyDomeDispList);
            GlStateManager.func_179121_F();
            GlStateManager.func_187421_b((int)3553, (int)10241, (int)9728);
            GlStateManager.func_187421_b((int)3553, (int)10240, (int)9728);
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179084_k();
            GlStateManager.func_179141_d();
            GlStateManager.func_179121_F();
            GlStateManager.func_179102_b((float)FogHandler.getCurrentFogStart());
            GlStateManager.func_179153_c((float)FogHandler.getCurrentFogEnd());
        }
    }

    protected void renderSkyDome() {
        double tileSize = 5.0;
        Vec3d yOffset = new Vec3d(0.0, 2.0, 0.0);
        Vec3d cp = new Vec3d(0.0, -20.0, 0.0);
        double radius = 55.0;
        int tiles = 12;
        GlStateManager.func_179094_E();
        GlStateManager.func_187447_r((int)4);
        for (int tx = -tiles; tx < tiles; ++tx) {
            for (int tz = -tiles; tz < tiles; ++tz) {
                Vec3d tp1 = new Vec3d((double)tx * tileSize, 0.0, (double)tz * tileSize);
                tp1 = cp.func_178787_e(tp1.func_178788_d(cp).func_72432_b().func_186678_a(radius)).func_178787_e(yOffset);
                Vec3d tp2 = new Vec3d((double)tx * tileSize, 0.0, (double)(tz + 1) * tileSize);
                tp2 = cp.func_178787_e(tp2.func_178788_d(cp).func_72432_b().func_186678_a(radius)).func_178787_e(yOffset);
                Vec3d tp3 = new Vec3d((double)(tx + 1) * tileSize, 0.0, (double)(tz + 1) * tileSize);
                tp3 = cp.func_178787_e(tp3.func_178788_d(cp).func_72432_b().func_186678_a(radius)).func_178787_e(yOffset);
                Vec3d tp4 = new Vec3d((double)(tx + 1) * tileSize, 0.0, (double)tz * tileSize);
                tp4 = cp.func_178787_e(tp4.func_178788_d(cp).func_72432_b().func_186678_a(radius)).func_178787_e(yOffset);
                float u00 = (float)(tp1.field_72450_a / (radius * 2.0) + 0.5);
                float u10 = (float)(tp4.field_72450_a / (radius * 2.0) + 0.5);
                float u11 = (float)(tp3.field_72450_a / (radius * 2.0) + 0.5);
                float u01 = (float)(tp2.field_72450_a / (radius * 2.0) + 0.5);
                float v00 = (float)(1.0 - (tp1.field_72449_c / (radius * 2.0) + 0.5));
                float v10 = (float)(1.0 - (tp4.field_72449_c / (radius * 2.0) + 0.5));
                float v11 = (float)(1.0 - (tp3.field_72449_c / (radius * 2.0) + 0.5));
                float v01 = (float)(1.0 - (tp2.field_72449_c / (radius * 2.0) + 0.5));
                GlStateManager.func_187426_b((float)u00, (float)v00);
                GlStateManager.func_187435_e((float)((float)tp1.field_72450_a), (float)((float)tp1.field_72448_b), (float)((float)tp1.field_72449_c));
                GlStateManager.func_187426_b((float)u11, (float)v11);
                GlStateManager.func_187435_e((float)((float)tp3.field_72450_a), (float)((float)tp3.field_72448_b), (float)((float)tp3.field_72449_c));
                GlStateManager.func_187426_b((float)u01, (float)v01);
                GlStateManager.func_187435_e((float)((float)tp2.field_72450_a), (float)((float)tp2.field_72448_b), (float)((float)tp2.field_72449_c));
                GlStateManager.func_187426_b((float)u11, (float)v11);
                GlStateManager.func_187435_e((float)((float)tp3.field_72450_a), (float)((float)tp3.field_72448_b), (float)((float)tp3.field_72449_c));
                GlStateManager.func_187426_b((float)u00, (float)v00);
                GlStateManager.func_187435_e((float)((float)tp1.field_72450_a), (float)((float)tp1.field_72448_b), (float)((float)tp1.field_72449_c));
                GlStateManager.func_187426_b((float)u10, (float)v10);
                GlStateManager.func_187435_e((float)((float)tp4.field_72450_a), (float)((float)tp4.field_72448_b), (float)((float)tp4.field_72449_c));
            }
        }
        GlStateManager.func_187437_J();
        GlStateManager.func_179121_F();
    }

    protected void resetRenderingStates() {
        GlStateManager.func_179092_a((int)516, (float)0.5f);
        GlStateManager.func_179102_b((float)FogHandler.getCurrentFogStart());
        GlStateManager.func_179153_c((float)FogHandler.getCurrentFogEnd());
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)true);
    }

    protected void renderAuroras(float partialTicks, WorldClient world, Minecraft mc) {
        if (!this.auroras.isEmpty()) {
            GlStateManager.func_179106_n();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179118_c();
            GlStateManager.func_179147_l();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(-mc.func_175598_ae().field_78730_l), (double)(-mc.func_175598_ae().field_78731_m), (double)(-mc.func_175598_ae().field_78728_n));
            for (AuroraRenderer aurora : this.auroras) {
                aurora.render(partialTicks, 1.0f);
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179141_d();
            GlStateManager.func_179132_a((boolean)true);
        }
    }

    public void update(WorldClient world, Minecraft mc) {
        ++this.ticks;
        BetweenlandsWorldStorage storage = BetweenlandsWorldStorage.forWorld((World)world);
        if (storage != null) {
            BLEnvironmentEventRegistry reg = storage.getEnvironmentEventRegistry();
            this.spoopy = reg.spoopy.isActive();
            if (reg.auroras.isActive()) {
                Random rand = world.field_73012_v;
                double newAuroraPosX = mc.field_71439_g.field_70165_t + (double)rand.nextInt(160) - 80.0;
                double newAuroraPosZ = mc.field_71439_g.field_70161_v + (double)rand.nextInt(160) - 80.0;
                double newAuroraPosY = 260.0;
                double minDist = 0.0;
                for (AuroraRenderer aurora : this.auroras) {
                    double dist;
                    if (aurora.getDistance(mc.field_71439_g.field_70165_t, aurora.getY(), mc.field_71439_g.field_70161_v) > 180.0) {
                        aurora.setActive(false);
                    }
                    if (!((dist = aurora.getDistance(newAuroraPosX, newAuroraPosY, newAuroraPosZ)) < minDist) && minDist != 0.0) continue;
                    minDist = dist;
                }
                if (minDist > 150.0 || this.auroras.isEmpty()) {
                    ArrayList<Vector4f> gradients = new ArrayList<Vector4f>();
                    switch (reg.auroras.getAuroraType()) {
                        default: {
                            gradients.add(new Vector4f(0.0f, 1.0f, 0.0f, 0.01f));
                            gradients.add(new Vector4f(0.0f, 1.0f, 0.0f, 0.15f));
                            gradients.add(new Vector4f(0.0f, 1.0f, 0.8f, 0.8f));
                            gradients.add(new Vector4f(0.0f, 0.7f, 1.0f, 0.15f));
                            gradients.add(new Vector4f(0.0f, 0.4f, 1.0f, 0.01f));
                            break;
                        }
                        case 1: {
                            gradients.add(new Vector4f(1.0f, 0.0f, 0.0f, 0.05f));
                            gradients.add(new Vector4f(1.0f, 0.0f, 0.0f, 0.2f));
                            gradients.add(new Vector4f(1.0f, 0.0f, 0.5f, 0.5f));
                            gradients.add(new Vector4f(1.0f, 0.2f, 0.5f, 0.8f));
                            gradients.add(new Vector4f(1.0f, 0.0f, 0.5f, 0.5f));
                            gradients.add(new Vector4f(0.8f, 0.0f, 0.5f, 0.25f));
                            break;
                        }
                        case 2: {
                            gradients.add(new Vector4f(0.0f, 1.0f, 0.0f, 0.05f));
                            gradients.add(new Vector4f(0.5f, 1.0f, 0.0f, 0.15f));
                            gradients.add(new Vector4f(1.0f, 0.8f, 0.0f, 0.7f));
                            gradients.add(new Vector4f(0.5f, 0.4f, 0.0f, 0.15f));
                            gradients.add(new Vector4f(1.0f, 0.2f, 0.0f, 0.05f));
                        }
                    }
                    this.auroras.add(new AuroraRenderer(newAuroraPosX, newAuroraPosY + (double)rand.nextInt(100), newAuroraPosZ, new Vector2d((double)(rand.nextFloat() * 2.0f - 1.0f), (double)(rand.nextFloat() * 2.0f - 1.0f)), rand.nextInt(40) + 15, gradients));
                }
            } else {
                for (AuroraRenderer aurora : this.auroras) {
                    aurora.setActive(false);
                }
            }
            Iterator<AuroraRenderer> auroraIT = this.auroras.iterator();
            while (auroraIT.hasNext()) {
                AuroraRenderer aurora = auroraIT.next();
                if (aurora.isRemoved()) {
                    auroraIT.remove();
                    continue;
                }
                aurora.update();
            }
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            BLSkyRenderer skyRenderer = WorldProviderBetweenlands.getBLSkyRenderer();
            if (world != null && skyRenderer != null) {
                skyRenderer.update(world, Minecraft.func_71410_x());
            }
        }
    }

    @Override
    public void setRiftRenderer(IRiftRenderer renderer) {
        this.riftRenderer = renderer;
    }

    @Override
    public IRiftRenderer getRiftRenderer() {
        return this.riftRenderer;
    }
}

