/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.sky;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.IRenderHandler;

public class BLRainRenderer
extends IRenderHandler {
    public static final BLRainRenderer INSTANCE = new BLRainRenderer();
    private static final ResourceLocation RAIN_TEXTURES = new ResourceLocation("thebetweenlands:textures/environment/rain.png");
    private final float[] rainXCoords = new float[1024];
    private final float[] rainYCoords = new float[1024];
    private final Random random = new Random();
    private long prevRenderUpdateTicks;
    private long renderUpdateTicks;

    public BLRainRenderer() {
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                float f = j - 16;
                float f1 = i - 16;
                float f2 = MathHelper.func_76129_c((float)(f * f + f1 * f1));
                this.rainXCoords[i << 5 | j] = -f1 / f2;
                this.rainYCoords[i << 5 | j] = f / f2;
            }
        }
    }

    public void update(World world) {
        this.prevRenderUpdateTicks = this.renderUpdateTicks++;
    }

    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        EntityRenderer renderer = mc.field_71460_t;
        float rainStrength = world.func_72867_j(partialTicks);
        if (rainStrength > 0.0f) {
            renderer.func_180436_i();
            Entity entity = mc.func_175606_aa();
            int px = MathHelper.func_76128_c((double)entity.field_70165_t);
            int py = MathHelper.func_76128_c((double)entity.field_70163_u);
            int pz = MathHelper.func_76128_c((double)entity.field_70161_v);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder builder = tessellator.func_178180_c();
            GlStateManager.func_179129_p();
            GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            double interpX = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
            double interpY = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
            double interpZ = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
            int interpYFloor = MathHelper.func_76128_c((double)interpY);
            int layers = 5;
            if (mc.field_71474_y.field_74347_j) {
                layers = 10;
            }
            builder.func_178969_c(-interpX, -interpY, -interpZ);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
            mc.func_110434_K().func_110577_a(RAIN_TEXTURES);
            builder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
            for (int layerZ = pz - layers; layerZ <= pz + layers; ++layerZ) {
                for (int layerX = px - layers; layerX <= px + layers; ++layerX) {
                    int coordsIndex = (layerZ - pz + 16) * 32 + layerX - px + 16;
                    double rainXCoord = (double)this.rainXCoords[coordsIndex] * 0.5;
                    double rainYCoord = (double)this.rainYCoords[coordsIndex] * 0.5;
                    checkPos.func_181079_c(layerX, 0, layerZ);
                    int precipationHeight = world.func_175725_q((BlockPos)checkPos).func_177956_o();
                    int layerY = py - layers;
                    int maxLayerY = py + layers;
                    if (layerY < precipationHeight) {
                        layerY = precipationHeight;
                    }
                    if (maxLayerY < precipationHeight) {
                        maxLayerY = precipationHeight;
                    }
                    int maxHeight = precipationHeight;
                    if (precipationHeight < interpYFloor) {
                        maxHeight = interpYFloor;
                    }
                    if (layerY == maxLayerY) continue;
                    int waterColor = BiomeColorHelper.func_180288_c((IBlockAccess)world, (BlockPos)checkPos);
                    float r = (float)(waterColor >> 16 & 0xFF) / 255.0f * 1.5f;
                    float g = (float)(waterColor >> 8 & 0xFF) / 255.0f * 1.5f;
                    float b = (float)(waterColor & 0xFF) / 255.0f * 1.5f + 0.1f;
                    this.random.setSeed(layerX * layerX * 3121 + layerX * 45238971 ^ layerZ * layerZ * 418711 + layerZ * 13761);
                    double uvShiftY = -((double)(this.renderUpdateTicks + (long)(layerX * layerX * 3121) + (long)(layerX * 45238971) + (long)(layerZ * layerZ * 418711) + (long)(layerZ * 13761) & 0x1FL) + (double)partialTicks) / 64.0 * (3.0 + this.random.nextDouble());
                    double dx = (double)((float)layerX + 0.5f) - entity.field_70165_t;
                    double dz = (double)((float)layerZ + 0.5f) - entity.field_70161_v;
                    float distance = MathHelper.func_76133_a((double)(dx * dx + dz * dz)) / (float)layers;
                    float visibility = ((1.0f - distance * distance) * 0.5f + 0.5f) * rainStrength;
                    checkPos.func_181079_c(layerX, maxHeight, layerZ);
                    int lightmap = world.func_175626_b((BlockPos)checkPos, 0);
                    int lightmapX = lightmap >> 16 & 0xFFFF;
                    int lightmapY = lightmap & 0xFFFF;
                    builder.func_181662_b((double)layerX - rainXCoord + 0.5, (double)maxLayerY, (double)layerZ - rainYCoord + 0.5).func_187315_a(0.0, (double)layerY * 0.25 + uvShiftY + uvShiftY).func_181666_a(r, g, b, visibility).func_187314_a(lightmapX, lightmapY).func_181675_d();
                    builder.func_181662_b((double)layerX + rainXCoord + 0.5, (double)maxLayerY, (double)layerZ + rainYCoord + 0.5).func_187315_a(1.0, (double)layerY * 0.25 + uvShiftY + uvShiftY).func_181666_a(r, g, b, visibility).func_187314_a(lightmapX, lightmapY).func_181675_d();
                    builder.func_181662_b((double)layerX + rainXCoord + 0.5, (double)layerY, (double)layerZ + rainYCoord + 0.5).func_187315_a(1.0, (double)maxLayerY * 0.25 + uvShiftY + uvShiftY).func_181666_a(r, g, b, visibility).func_187314_a(lightmapX, lightmapY).func_181675_d();
                    builder.func_181662_b((double)layerX - rainXCoord + 0.5, (double)layerY, (double)layerZ - rainYCoord + 0.5).func_187315_a(0.0, (double)maxLayerY * 0.25 + uvShiftY + uvShiftY).func_181666_a(r, g, b, visibility).func_187314_a(lightmapX, lightmapY).func_181675_d();
                }
            }
            tessellator.func_78381_a();
            builder.func_178969_c(0.0, 0.0, 0.0);
            GlStateManager.func_179089_o();
            GlStateManager.func_179084_k();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            renderer.func_175072_h();
        }
    }
}

