/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.particle.entity;

import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import thebetweenlands.client.handler.TextureStitchHandler;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.render.particle.ParticleTextureStitcher;
import thebetweenlands.client.render.sprite.TextureAnimation;

public class ParticleWaterRipple
extends Particle
implements ParticleTextureStitcher.IParticleSpriteReceiver {
    protected TextureAnimation animation;

    protected ParticleWaterRipple(World worldIn, double posXIn, double posYIn, double posZIn, float scale) {
        super(worldIn, posXIn, posYIn, posZIn);
        this.field_70544_f = scale;
        this.field_70545_g = 0.0f;
        this.animation = new TextureAnimation();
    }

    public int func_70537_b() {
        return 1;
    }

    @Override
    public void setStitchedSprites(TextureStitchHandler.Frame[][] frames) {
        if (this.animation != null) {
            this.animation.setFrames(frames[0]);
            if (this.field_187119_C == null) {
                this.func_187117_a(frames[0][0].getSprite());
            }
            this.field_70547_e = this.animation.getTotalDuration() - 1;
        }
    }

    public void func_189213_a() {
        if (this.animation != null) {
            this.animation.update();
            this.func_187117_a(this.animation.getCurrentSprite());
        }
        super.func_189213_a();
    }

    public void func_180434_a(BufferBuilder buff, Entity entityIn, float partialTicks, float rx, float rz, float ryz, float rxy, float rxz) {
        float minU = (float)this.field_94054_b / 16.0f;
        float maxU = minU + 0.0624375f;
        float minV = (float)this.field_94055_c / 16.0f;
        float maxV = minV + 0.0624375f;
        float scale = 0.1f * this.field_70544_f;
        if (this.field_187119_C != null) {
            minU = this.field_187119_C.func_94209_e();
            maxU = this.field_187119_C.func_94212_f();
            minV = this.field_187119_C.func_94206_g();
            maxV = this.field_187119_C.func_94210_h();
        }
        float rpx = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float rpy = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
        float rpz = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        int brightness = this.func_189214_a(partialTicks);
        int lightmapX = brightness >> 16 & 0xFFFF;
        int lightmapY = brightness & 0xFFFF;
        buff.func_181662_b((double)(rpx - scale), (double)rpy, (double)(rpz - scale)).func_187315_a((double)maxU, (double)maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(lightmapX, lightmapY).func_181675_d();
        buff.func_181662_b((double)(rpx - scale), (double)rpy, (double)(rpz + scale)).func_187315_a((double)maxU, (double)minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(lightmapX, lightmapY).func_181675_d();
        buff.func_181662_b((double)(rpx + scale), (double)rpy, (double)(rpz + scale)).func_187315_a((double)minU, (double)minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(lightmapX, lightmapY).func_181675_d();
        buff.func_181662_b((double)(rpx + scale), (double)rpy, (double)(rpz - scale)).func_187315_a((double)minU, (double)maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(lightmapX, lightmapY).func_181675_d();
    }

    public static final class Factory
    extends ParticleFactory<Factory, ParticleWaterRipple> {
        public Factory() {
            super(ParticleWaterRipple.class, ParticleTextureStitcher.create(ParticleWaterRipple.class, new ResourceLocation("thebetweenlands:particle/water_ripple")).setSplitAnimations(true));
        }

        @Override
        public ParticleWaterRipple createParticle(ParticleFactory.ImmutableParticleArgs args) {
            return new ParticleWaterRipple(args.world, args.x, args.y, args.z, args.scale);
        }
    }
}

