/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.model.baked;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.IModelState;
import org.apache.commons.lang3.tuple.Pair;
import thebetweenlands.client.render.model.loader.IBakedModelDependant;

public class BakedModelItemWrapper
implements IBakedModel,
IBakedModelDependant {
    private final Collection<ResourceLocation> dependencies;
    private final IBakedModel transformsModel;
    private final IBakedModel bakedQuadModel;
    private boolean shouldInheritOverrides = true;
    private boolean shouldCacheOverrideModels = true;
    private ItemOverrideList wrappedOverrideList;

    public BakedModelItemWrapper(IBakedModel transformsModel, IBakedModel bakedQuadModel, Collection<ResourceLocation> dependencies) {
        this.transformsModel = transformsModel;
        this.bakedQuadModel = bakedQuadModel;
        this.dependencies = dependencies;
    }

    public BakedModelItemWrapper setInheritOverrides(boolean inherit) {
        this.shouldInheritOverrides = inherit;
        return this;
    }

    public BakedModelItemWrapper setCacheOverrideModels(boolean cached) {
        this.shouldCacheOverrideModels = cached;
        return this;
    }

    @Override
    public Collection<ModelResourceLocation> getDependencies(ResourceLocation modelLocation) {
        ArrayList<ModelResourceLocation> dependencies = new ArrayList<ModelResourceLocation>();
        for (ResourceLocation location : this.dependencies) {
            dependencies.add(ModelLoader.getInventoryVariant((String)location.toString()));
        }
        if (this.bakedQuadModel instanceof IBakedModelDependant) {
            dependencies.addAll(((IBakedModelDependant)this.bakedQuadModel).getDependencies(modelLocation));
        }
        return dependencies;
    }

    @Override
    public void setDependencies(ResourceLocation modelLocation, Map<ModelResourceLocation, IBakedModel> dependencies) {
        if (this.bakedQuadModel instanceof IBakedModelDependant) {
            ((IBakedModelDependant)this.bakedQuadModel).setDependencies(modelLocation, dependencies);
        }
    }

    @Override
    public IModelState getModelState(IModel dependecyModel) {
        if (this.bakedQuadModel instanceof IBakedModelDependant) {
            return ((IBakedModelDependant)this.bakedQuadModel).getModelState(dependecyModel);
        }
        return IBakedModelDependant.super.getModelState(dependecyModel);
    }

    @Override
    public VertexFormat getVertexFormat(IModel dependencyModel) {
        if (this.bakedQuadModel instanceof IBakedModelDependant) {
            return ((IBakedModelDependant)this.bakedQuadModel).getVertexFormat(dependencyModel);
        }
        return IBakedModelDependant.super.getVertexFormat(dependencyModel);
    }

    @Override
    public Function<ResourceLocation, TextureAtlasSprite> getTextureGetter(IModel dependencyModel) {
        if (this.bakedQuadModel instanceof IBakedModelDependant) {
            return ((IBakedModelDependant)this.bakedQuadModel).getTextureGetter(dependencyModel);
        }
        return IBakedModelDependant.super.getTextureGetter(dependencyModel);
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        return this.bakedQuadModel.func_188616_a(state, side, rand);
    }

    public boolean func_177555_b() {
        return this.bakedQuadModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.bakedQuadModel.func_177556_c();
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.bakedQuadModel.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.transformsModel.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        if (this.shouldInheritOverrides) {
            return this.transformsModel.func_188617_f();
        }
        if (this.wrappedOverrideList == null) {
            this.wrappedOverrideList = new WrappedItemOverrideList(this.bakedQuadModel.func_188617_f(), this.dependencies);
        }
        return this.wrappedOverrideList;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        Pair result = this.transformsModel != null ? this.transformsModel.handlePerspective(cameraTransformType) : PerspectiveMapWrapper.handlePerspective((IBakedModel)this, (IModelState)this.func_177552_f().func_181688_b(cameraTransformType), (ItemCameraTransforms.TransformType)cameraTransformType);
        return Pair.of((Object)this, (Object)result.getValue());
    }

    private static final class WrappedItemOverrideList
    extends ItemOverrideList {
        private final Collection<ResourceLocation> dependencies;
        private final Map<IBakedModel, IBakedModel> cachedModels = new HashMap<IBakedModel, IBakedModel>();
        private final ItemOverrideList parent;

        protected WrappedItemOverrideList(ItemOverrideList parent, Collection<ResourceLocation> dependencies) {
            super((List)ImmutableList.of());
            this.parent = parent;
            this.dependencies = dependencies;
        }

        public ResourceLocation func_188021_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
            return this.parent.func_188021_a(stack, worldIn, entityIn);
        }

        public ImmutableList<ItemOverride> getOverrides() {
            return this.parent.getOverrides();
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            BakedModelItemWrapper wrapper = (BakedModelItemWrapper)originalModel;
            IBakedModel quadModel = wrapper.bakedQuadModel;
            IBakedModel newModel = this.parent.handleItemState(quadModel, stack, world, entity);
            if (!(newModel instanceof BakedModelItemWrapper)) {
                if (wrapper.shouldCacheOverrideModels) {
                    IBakedModel cachedModel = this.cachedModels.get(newModel);
                    if (cachedModel == null) {
                        cachedModel = new BakedModelItemWrapper(wrapper.transformsModel, newModel, this.dependencies).setInheritOverrides(wrapper.shouldInheritOverrides);
                        this.cachedModels.put(newModel, cachedModel);
                    }
                    return cachedModel;
                }
                return new BakedModelItemWrapper(wrapper.transformsModel, newModel, this.dependencies).setInheritOverrides(wrapper.shouldInheritOverrides);
            }
            return newModel;
        }
    }
}

