/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.model.entity.ModelLargeSludgeWorm;
import thebetweenlands.client.render.model.entity.ModelTinyWormEggSac;
import thebetweenlands.common.entity.mobs.EntityLargeSludgeWorm;

@SideOnly(value=Side.CLIENT)
public class RenderLargeSludgeWorm
extends RenderLiving<EntityLargeSludgeWorm> {
    public static final ResourceLocation MODEL_TEXTURE = new ResourceLocation("thebetweenlands:textures/entity/large_sludge_worm.png");
    public static final ResourceLocation HULL_TEXTURE = new ResourceLocation("thebetweenlands:textures/entity/large_sludge_worm_hull.png");
    public static final ResourceLocation EGG_SAC_TEXTURE = new ResourceLocation("thebetweenlands", "textures/entity/worm_egg_sac.png");
    private final ModelLargeSludgeWorm model;
    private final ModelTinyWormEggSac modelEggSac = new ModelTinyWormEggSac();

    public RenderLargeSludgeWorm(RenderManager manager) {
        super(manager, (ModelBase)new ModelLargeSludgeWorm(), 0.0f);
        this.model = (ModelLargeSludgeWorm)this.field_77045_g;
    }

    public void doRender(EntityLargeSludgeWorm entity, double x, double y, double z, float yaw, float partialTicks) {
        if (MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Pre((EntityLivingBase)entity, (RenderLivingBase)this, partialTicks, x, y, z))) {
            return;
        }
        this.renderPass(entity, x, y, z, yaw, partialTicks, false);
        MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Post((EntityLivingBase)entity, (RenderLivingBase)this, partialTicks, x, y, z));
    }

    public void renderMultipass(EntityLargeSludgeWorm entity, double x, double y, double z, float yaw, float partialTicks) {
        this.renderPass(entity, x, y, z, yaw, partialTicks, true);
    }

    protected void renderPass(EntityLargeSludgeWorm entity, double x, double y, double z, float yaw, float partialTicks, boolean isMultiPass) {
        boolean isTranslucentToPlayer;
        if (!entity.segmentsAvailable) {
            return;
        }
        boolean isVisible = this.func_193115_c((EntityLivingBase)entity);
        boolean bl = isTranslucentToPlayer = !isVisible && !entity.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (!isVisible && !isTranslucentToPlayer) {
            return;
        }
        boolean useBrightness = this.func_177090_c((EntityLivingBase)entity, partialTicks);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (isTranslucentToPlayer) {
            GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)(y + 0.55), (double)z);
        if (isMultiPass && !this.field_188301_f) {
            GlStateManager.func_179089_o();
            GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.FRONT);
            GlStateManager.func_179132_a((boolean)false);
            this.renderParts(entity, false, partialTicks);
        }
        GlStateManager.func_179129_p();
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        GlStateManager.func_179132_a((boolean)true);
        boolean useTeamColors = false;
        if (this.field_188301_f) {
            useTeamColors = this.func_177088_c((EntityLivingBase)entity);
            GlStateManager.func_179142_g();
            GlStateManager.func_187431_e((int)this.func_188298_c((Entity)entity));
        }
        if (!isMultiPass) {
            this.renderParts(entity, true, partialTicks);
        }
        if (this.field_188301_f) {
            GlStateManager.func_187417_n();
            GlStateManager.func_179119_h();
        }
        if (useTeamColors) {
            this.func_180565_e();
        }
        GlStateManager.func_179089_o();
        if (isMultiPass && !this.field_188301_f) {
            this.renderParts(entity, false, partialTicks);
        }
        GlStateManager.func_179121_F();
        if (isTranslucentToPlayer) {
            GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
        }
        GlStateManager.func_179084_k();
        if (useBrightness) {
            this.func_177091_f();
        }
        if (!isMultiPass && !this.field_188301_f) {
            this.func_110827_b((EntityLiving)entity, x, y, z, yaw, partialTicks);
        }
    }

    protected void renderParts(EntityLargeSludgeWorm entity, boolean renderSolids, float partialTicks) {
        this.renderHead(entity, renderSolids, partialTicks);
        this.renderTail(entity, renderSolids, partialTicks);
        if (!renderSolids) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.0, (double)0.055, (double)0.0);
            this.renderBodyHull(entity, partialTicks);
            GlStateManager.func_179121_F();
        }
        if (renderSolids) {
            this.renderSpine(entity, partialTicks);
            this.renderEggSac(entity, partialTicks);
        }
    }

    protected void renderEggSac(EntityLargeSludgeWorm entity, float partialTicks) {
        if (entity.eggSacPosition != null && entity.prevEggSacPosition != null) {
            this.func_110776_a(EGG_SAC_TEXTURE);
            Vec3d pos = entity.eggSacPosition;
            Vec3d prevPos = entity.prevEggSacPosition;
            double x = RenderLargeSludgeWorm.lerp(prevPos.field_72450_a, pos.field_72450_a, partialTicks);
            double y = RenderLargeSludgeWorm.lerp(prevPos.field_72448_b, pos.field_72448_b, partialTicks);
            double z = RenderLargeSludgeWorm.lerp(prevPos.field_72449_c, pos.field_72449_c, partialTicks);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)(y - 0.4 + Math.sin((double)((float)entity.field_70173_aa + partialTicks) * 0.25) * 0.025), (double)z);
            GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
            float scale = Math.max(0.0f, Math.min(1.0f, entity.getEggSacPercentage()));
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            GlStateManager.func_179137_b((double)0.0, (double)-1.5, (double)0.0);
            this.modelEggSac.render(0.0625f);
            GlStateManager.func_179121_F();
        }
    }

    protected void renderBodyHull(EntityLargeSludgeWorm entity, float partialTicks) {
        this.func_110776_a(HULL_TEXTURE);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181703_c);
        float uOffset = 0.0f;
        int i = 0;
        double pos1X = 0.0;
        double pos1Y = 0.0;
        double pos1Z = 0.0;
        EntityLargeSludgeWorm.HullSegment segment1 = null;
        for (EntityLargeSludgeWorm.HullSegment segment2 : entity.segments) {
            Vec3d pos = segment2.pos;
            Vec3d prevPos = segment2.prevPos;
            double pos2X = RenderLargeSludgeWorm.lerp(prevPos.field_72450_a, pos.field_72450_a, partialTicks);
            double pos2Y = RenderLargeSludgeWorm.lerp(prevPos.field_72448_b, pos.field_72448_b, partialTicks);
            double pos2Z = RenderLargeSludgeWorm.lerp(prevPos.field_72449_c, pos.field_72449_c, partialTicks);
            if (segment1 != null) {
                float maxUW = 0.0f;
                int hullVerts = Math.min(segment1.offsetX.length, segment2.offsetX.length);
                for (int vertIndex = 0; vertIndex < hullVerts; ++vertIndex) {
                    int nextVertIndex = (vertIndex + 1) % hullVerts;
                    float contraction1 = this.calculateHullContraction(entity, (float)(i - 1) / (float)(entity.segments.length - 1), partialTicks);
                    float contraction2 = this.calculateHullContraction(entity, (float)i / (float)(entity.segments.length - 1), partialTicks);
                    double v11x = pos1X + (double)(segment1.offsetX[vertIndex] * contraction1);
                    double v11y = pos1Y + (double)(segment1.offsetY[vertIndex] * contraction1);
                    double v11z = pos1Z + (double)(segment1.offsetZ[vertIndex] * contraction1);
                    double v12x = pos1X + (double)(segment1.offsetX[nextVertIndex] * contraction1);
                    double v12y = pos1Y + (double)(segment1.offsetY[nextVertIndex] * contraction1);
                    double v12z = pos1Z + (double)(segment1.offsetZ[nextVertIndex] * contraction1);
                    double v21x = pos2X + (double)(segment2.offsetX[vertIndex] * contraction2);
                    double v21y = pos2Y + (double)(segment2.offsetY[vertIndex] * contraction2);
                    double v21z = pos2Z + (double)(segment2.offsetZ[vertIndex] * contraction2);
                    double v22x = pos2X + (double)(segment2.offsetX[nextVertIndex] * contraction2);
                    double v22y = pos2Y + (double)(segment2.offsetY[nextVertIndex] * contraction2);
                    double v22z = pos2Z + (double)(segment2.offsetZ[nextVertIndex] * contraction2);
                    float uw1 = RenderLargeSludgeWorm.dist(v12x, v12y, v12z, v11x, v11y, v11z) * 0.5f;
                    float vw1 = RenderLargeSludgeWorm.dist(v21x, v21y, v21z, v11x, v11y, v11z);
                    float uw2 = RenderLargeSludgeWorm.dist(v22x, v22y, v22z, v21x, v21y, v21z) * 0.5f;
                    float vw2 = RenderLargeSludgeWorm.dist(v22x, v22y, v22z, v12x, v12y, v12z);
                    float uw = Math.max(uw1, uw2);
                    float vw = Math.max(vw1, vw2);
                    float d1x = (float)(v21x - v12x);
                    float d1y = (float)(v21y - v12y);
                    float d1z = (float)(v21z - v12z);
                    float d2x = (float)(v22x - v11x);
                    float d2y = (float)(v22y - v11y);
                    float d2z = (float)(v22z - v11z);
                    float nx = d1y * d2z - d1z * d2y;
                    float ny = d1z * d2x - d1x * d2z;
                    float nz = d1x * d2y - d1y * d2x;
                    float len = RenderLargeSludgeWorm.len(nx, ny, nz);
                    float us = uOffset;
                    float vs = 0.0f;
                    bufferBuilder.func_181662_b(v11x, v11y, v11z).func_187315_a((double)us, (double)vs).func_181663_c(nx /= len, ny /= len, nz /= len).func_181675_d();
                    bufferBuilder.func_181662_b(v21x, v21y, v21z).func_187315_a((double)us, (double)(vs + vw)).func_181663_c(nx, ny, nz).func_181675_d();
                    bufferBuilder.func_181662_b(v22x, v22y, v22z).func_187315_a((double)(us + uw), (double)(vs + vw)).func_181663_c(nx, ny, nz).func_181675_d();
                    bufferBuilder.func_181662_b(v12x, v12y, v12z).func_187315_a((double)(us + uw), (double)vs).func_181663_c(nx, ny, nz).func_181675_d();
                    maxUW = Math.max(maxUW, uw);
                }
                uOffset += maxUW;
            }
            segment1 = segment2;
            pos1X = pos2X;
            pos1Y = pos2Y;
            pos1Z = pos2Z;
            ++i;
        }
        tessellator.func_78381_a();
    }

    protected float calculateHullContraction(EntityLargeSludgeWorm entity, float percent, float partialTicks) {
        double arcLength = entity.spineySpliney.getArcLength();
        float minBound = 1.8f / (float)arcLength;
        float maxBound = 1.0f - minBound;
        float lerp = 1.0f;
        if (percent < minBound) {
            lerp = percent / minBound;
        } else if (percent > maxBound) {
            lerp = 1.0f - (percent - maxBound) / minBound;
        }
        float contraction = ((float)Math.sin((double)percent * entity.spineySpliney.getArcLength() * 4.0 - (double)(((float)entity.field_70173_aa + partialTicks) * 0.25f)) + 1.0f) / 2.0f * 0.2f + 0.8f;
        return 0.99f + (contraction - 0.99f) * lerp;
    }

    protected void renderSpine(EntityLargeSludgeWorm entity, float partialTicks) {
        this.func_110776_a(MODEL_TEXTURE);
        int i = 0;
        for (EntityLargeSludgeWorm.SpineBone bone : entity.bones) {
            Vec3d pos = bone.pos;
            Vec3d prevPos = bone.prevPos;
            double x = RenderLargeSludgeWorm.lerp(prevPos.field_72450_a, pos.field_72450_a, partialTicks);
            double y = RenderLargeSludgeWorm.lerp(prevPos.field_72448_b, pos.field_72448_b, partialTicks);
            double z = RenderLargeSludgeWorm.lerp(prevPos.field_72449_c, pos.field_72449_c, partialTicks);
            float boneYaw = RenderLargeSludgeWorm.lerp(bone.prevYaw, bone.yaw, partialTicks);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)(y + Math.sin(-((float)entity.field_70173_aa + partialTicks) * 0.25f + (float)i * 0.2f) * (double)0.05f), (double)z);
            this.model.renderSpinePiece(i % 6, boneYaw);
            GlStateManager.func_179121_F();
            ++i;
        }
    }

    protected void renderHead(EntityLargeSludgeWorm entity, boolean renderSolids, float partialTicks) {
        this.func_110776_a(MODEL_TEXTURE);
        GlStateManager.func_179094_E();
        EntityLargeSludgeWorm.HullSegment headSegment = entity.segments[0];
        float headYaw = RenderLargeSludgeWorm.lerp(headSegment.prevYaw, headSegment.yaw, partialTicks);
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)headYaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)0.0f);
        this.model.renderHead(entity, 0, 0.0f, partialTicks, renderSolids);
        GlStateManager.func_179121_F();
    }

    protected void renderTail(EntityLargeSludgeWorm entity, boolean renderSolids, float partialTicks) {
        this.func_110776_a(MODEL_TEXTURE);
        GlStateManager.func_179094_E();
        EntityLargeSludgeWorm.HullSegment tailSegment = entity.segments[entity.segments.length - 1];
        Vec3d pos = tailSegment.pos;
        Vec3d prevPos = tailSegment.prevPos;
        double x = RenderLargeSludgeWorm.lerp(prevPos.field_72450_a, pos.field_72450_a, partialTicks);
        double y = RenderLargeSludgeWorm.lerp(prevPos.field_72448_b, pos.field_72448_b, partialTicks);
        double z = RenderLargeSludgeWorm.lerp(prevPos.field_72449_c, pos.field_72449_c, partialTicks);
        float tailYaw = RenderLargeSludgeWorm.lerp(tailSegment.prevYaw, tailSegment.yaw, partialTicks);
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)tailYaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)0.0, (double)-1.0, (double)-1.8);
        this.model.renderTail(entity, 0, 0.0f, partialTicks, renderSolids);
        GlStateManager.func_179121_F();
    }

    protected static float dist(double x1, double y1, double z1, double x2, double y2, double z2) {
        return RenderLargeSludgeWorm.len(x2 - x1, y2 - y1, z2 - z1);
    }

    protected static float len(double x, double y, double z) {
        return MathHelper.func_76133_a((double)(x * x + y * y + z * z));
    }

    protected static float lerp(float start, float end, float delta) {
        return start + (end - start) * delta;
    }

    protected static double lerp(double start, double end, float delta) {
        return start + (end - start) * (double)delta;
    }

    protected ResourceLocation getEntityTexture(EntityLargeSludgeWorm entity) {
        return MODEL_TEXTURE;
    }

    public boolean func_188295_H_() {
        return true;
    }
}

