/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.block;

import javax.annotation.Nullable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.VertexBufferUploader;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class VertexBatchRenderer {
    private final boolean useVbo;
    private final VertexFormat format;
    private final WorldVertexBufferUploader worldVertexUploader = new WorldVertexBufferUploader();
    private int displayList;
    private final VertexBufferUploader vertexBufferUploader = new VertexBufferUploader();
    private VertexBuffer vertexBuffer;

    public VertexBatchRenderer(VertexFormat format, boolean useVbo) {
        this(format, useVbo, null, -1);
    }

    public VertexBatchRenderer(VertexFormat format, boolean useVbo, @Nullable VertexBuffer vertexBuffer, int displayList) {
        this.format = format;
        this.useVbo = useVbo;
        this.vertexBuffer = vertexBuffer;
        this.displayList = displayList;
    }

    public void compile(BufferBuilder bufferBuilder) {
        bufferBuilder.func_178977_d();
        if (this.useVbo) {
            if (this.vertexBuffer == null) {
                this.vertexBuffer = new VertexBuffer(this.format);
            }
            this.vertexBufferUploader.func_178178_a(this.vertexBuffer);
            this.vertexBufferUploader.func_181679_a(bufferBuilder);
        } else {
            if (this.displayList < 0) {
                this.displayList = GL11.glGenLists((int)1);
            }
            GL11.glNewList((int)this.displayList, (int)4864);
            this.worldVertexUploader.func_181679_a(bufferBuilder);
            GL11.glEndList();
        }
    }

    public void render() {
        if (this.useVbo) {
            if (this.vertexBuffer != null) {
                this.vertexBuffer.func_177359_a();
                int stride = this.format.func_177338_f();
                int elementIndex = 0;
                for (VertexFormatElement element : this.format.func_177343_g()) {
                    int count = element.func_177370_d();
                    int constant = element.func_177367_b().func_177397_c();
                    int offset = this.format.func_181720_d(elementIndex);
                    switch (element.func_177375_c()) {
                        case POSITION: {
                            GlStateManager.func_187420_d((int)count, (int)constant, (int)stride, (int)offset);
                            GlStateManager.func_187410_q((int)32884);
                            break;
                        }
                        case NORMAL: {
                            if (count != 3) {
                                throw new IllegalArgumentException("Normal attribute should have the size 3: " + element);
                            }
                            GL11.glNormalPointer((int)constant, (int)stride, (long)offset);
                            GlStateManager.func_187410_q((int)32885);
                            break;
                        }
                        case COLOR: {
                            GlStateManager.func_187406_e((int)count, (int)constant, (int)stride, (int)offset);
                            GlStateManager.func_187410_q((int)32886);
                            break;
                        }
                        case UV: {
                            OpenGlHelper.func_77472_b((int)(OpenGlHelper.field_77478_a + element.func_177369_e()));
                            GlStateManager.func_187405_c((int)count, (int)constant, (int)stride, (int)offset);
                            GlStateManager.func_187410_q((int)32888);
                            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
                            break;
                        }
                        case PADDING: {
                            break;
                        }
                        case GENERIC: {
                            GL20.glEnableVertexAttribArray((int)element.func_177369_e());
                            GL20.glVertexAttribPointer((int)element.func_177369_e(), (int)count, (int)constant, (boolean)false, (int)stride, (long)offset);
                        }
                    }
                    ++elementIndex;
                }
                this.vertexBuffer.func_177358_a(7);
                this.vertexBuffer.func_177361_b();
                for (VertexFormatElement element : this.format.func_177343_g()) {
                    switch (element.func_177375_c()) {
                        case POSITION: {
                            GlStateManager.func_187429_p((int)32884);
                            break;
                        }
                        case NORMAL: {
                            GlStateManager.func_187429_p((int)32885);
                            break;
                        }
                        case COLOR: {
                            GlStateManager.func_187429_p((int)32886);
                            GlStateManager.func_179117_G();
                            break;
                        }
                        case UV: {
                            OpenGlHelper.func_77472_b((int)(OpenGlHelper.field_77478_a + element.func_177369_e()));
                            GlStateManager.func_187429_p((int)32888);
                            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
                            break;
                        }
                        case PADDING: {
                            break;
                        }
                        case GENERIC: {
                            GL20.glDisableVertexAttribArray((int)element.func_177369_e());
                        }
                    }
                }
            }
        } else if (this.displayList >= 0) {
            GL11.glCallList((int)this.displayList);
        }
    }

    public void deleteBuffers() {
        if (this.vertexBuffer != null) {
            this.vertexBuffer.func_177362_c();
            this.vertexBuffer = null;
        }
        if (this.displayList >= 0) {
            GL11.glDeleteLists((int)this.displayList, (int)1);
            this.displayList = -1;
        }
    }
}

